/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.extensions;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.util.InnerCause;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;

public class DateTimeExtension<V extends BigdataValue>
implements IExtension<V> {
    private static final transient Logger log = Logger.getLogger(DateTimeExtension.class);
    private final Map<IV, BigdataURI> datatypes = new LinkedHashMap<IV, BigdataURI>();
    private final TimeZone defaultTZ;
    public static final DatatypeFactory datatypeFactorySingleton;
    private static transient boolean BSBMHACK;

    public DateTimeExtension(IDatatypeURIResolver resolver, TimeZone defaultTZ) {
        this.resolve(resolver, XSD.DATETIME);
        this.resolve(resolver, XSD.DATE);
        this.resolve(resolver, XSD.TIME);
        this.resolve(resolver, XSD.GDAY);
        this.resolve(resolver, XSD.GMONTH);
        this.resolve(resolver, XSD.GMONTHDAY);
        this.resolve(resolver, XSD.GYEAR);
        this.resolve(resolver, XSD.GYEARMONTH);
        this.defaultTZ = defaultTZ;
    }

    private void resolve(IDatatypeURIResolver resolver, URI uri) {
        if (log.isDebugEnabled()) {
            log.debug("resolving: " + uri);
        }
        BigdataURI val = resolver.resolve(uri);
        this.datatypes.put(val.getIV(), val);
    }

    @Override
    public Set<BigdataURI> getDatatypes() {
        return new LinkedHashSet<BigdataURI>(this.datatypes.values());
    }

    @Override
    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException();
        }
        Literal lit = (Literal)value;
        URI dt = lit.getDatatype();
        String s = value.stringValue();
        long l = DateTimeExtension.getTimestamp(s, this.defaultTZ);
        return this.createIV(l, dt);
    }

    public static long getTimestamp(String dateTime, TimeZone defaultTZ) {
        GregorianCalendar gc;
        XMLGregorianCalendar c = XMLDatatypeUtil.parseCalendar(dateTime);
        if (c.getTimezone() == Integer.MIN_VALUE) {
            gc = c.toGregorianCalendar();
            gc.setGregorianChange(new Date(Long.MIN_VALUE));
            int offsetInMillis = defaultTZ.getOffset(gc.getTimeInMillis());
            int offsetInMinutes = offsetInMillis / 1000 / 60;
            c.setTimezone(offsetInMinutes);
        }
        gc = c.toGregorianCalendar();
        gc.setGregorianChange(new Date(Long.MIN_VALUE));
        long l = gc.getTimeInMillis();
        return l;
    }

    public static long getTimestamp(String dateTime) {
        return DateTimeExtension.getTimestamp(dateTime, TimeZone.getTimeZone("GMT"));
    }

    public LiteralExtensionIV createIV(long timestamp, URI dt) {
        if (dt == null) {
            throw new IllegalArgumentException();
        }
        BigdataURI resolvedDT = null;
        for (BigdataURI val : this.datatypes.values()) {
            if (!val.stringValue().equals(dt.stringValue())) continue;
            resolvedDT = val;
        }
        if (resolvedDT == null) {
            throw new IllegalArgumentException();
        }
        XSDNumericIV<BigdataLiteral> delegate = new XSDNumericIV<BigdataLiteral>(timestamp);
        return new LiteralExtensionIV(delegate, resolvedDT.getIV());
    }

    @Override
    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        if (!this.datatypes.containsKey(iv.getExtensionIV())) {
            throw new IllegalArgumentException("unrecognized datatype");
        }
        long l = iv.getDelegate().longValue();
        TimeZone tz = BSBMHACK ? TimeZone.getDefault() : this.defaultTZ;
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setGregorianChange(new Date(Long.MIN_VALUE));
        c.setTimeInMillis(l);
        try {
            int offset;
            BigdataURI dt = this.datatypes.get(iv.getExtensionIV());
            DatatypeFactory f = datatypeFactorySingleton;
            XMLGregorianCalendar xmlGC = f.newXMLGregorianCalendar(c);
            String s = xmlGC.toString();
            int n = offset = s.startsWith("-") ? 1 : 0;
            if (dt.equals(XSD.DATETIME)) {
                int i;
                if (BSBMHACK && (i = s.lastIndexOf(46)) >= 0) {
                    s = s.substring(0, i);
                }
            } else if (dt.equals(XSD.DATE)) {
                s = s.substring(0, 10 + offset);
            } else if (dt.equals(XSD.TIME)) {
                s = s.substring(11 + offset);
            } else if (dt.equals(XSD.GDAY)) {
                s = "---" + s.substring(8 + offset, 10 + offset);
            } else if (dt.equals(XSD.GMONTH)) {
                s = "--" + s.substring(5 + offset, 7 + offset);
            } else if (dt.equals(XSD.GMONTHDAY)) {
                s = "--" + s.substring(5 + offset, 10 + offset);
            } else if (dt.equals(XSD.GYEAR)) {
                s = s.substring(0, 4 + offset);
            } else if (dt.equals(XSD.GYEARMONTH)) {
                s = s.substring(0, 7 + offset);
            }
            return (V)vf.createLiteral(s, dt);
        }
        catch (RuntimeException ex) {
            if (InnerCause.isInnerCause(ex, InterruptedException.class)) {
                throw ex;
            }
            throw new IllegalArgumentException("bad iv: " + iv, ex);
        }
    }

    static {
        DatatypeFactory f = null;
        try {
            f = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException ex) {
            log.error("Could not configure DatatypeFactory: " + ex, ex);
        }
        datatypeFactorySingleton = f;
        BSBMHACK = Boolean.getBoolean("BSBM_HACK");
    }
}

