/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.extensions;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.impl.literal.LiteralExtensionIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.vocab.decls.BSBMVocabularyDecl;
import java.util.Collections;
import java.util.Set;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;

public class USDFloatExtension<V extends BigdataValue>
implements IExtension<V> {
    private final BigdataURI datatype;

    public USDFloatExtension(IDatatypeURIResolver resolver) {
        this.datatype = resolver.resolve(BSBMVocabularyDecl.USD);
    }

    @Override
    public Set<BigdataURI> getDatatypes() {
        return Collections.singleton(this.datatype);
    }

    @Override
    public LiteralExtensionIV createIV(Value value) {
        if (!(value instanceof Literal)) {
            throw new IllegalArgumentException();
        }
        Literal lit = (Literal)value;
        XSDNumericIV<BigdataLiteral> delegate = new XSDNumericIV<BigdataLiteral>(XMLDatatypeUtil.parseFloat(lit.getLabel()));
        return new LiteralExtensionIV(delegate, this.datatype.getIV());
    }

    @Override
    public V asValue(LiteralExtensionIV iv, BigdataValueFactory vf) {
        String s = Float.toString(iv.getDelegate().floatValue());
        return (V)vf.createLiteral(s, this.datatype);
    }
}

