/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IInlineUnicode;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUnicode;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataValueFactory;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;

public class FullyInlineTypedLiteralIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, String>
implements IInlineUnicode,
Literal {
    private static final long serialVersionUID = 1L;
    private final String label;
    private final String language;
    private final URI datatype;
    private final byte termCode;
    private final boolean temp;
    private transient int byteLength = 0;

    @Override
    public IV<V, String> clone(boolean clearCache) {
        FullyInlineTypedLiteralIV tmp = new FullyInlineTypedLiteralIV(this.label, this.language, this.datatype);
        tmp.byteLength = this.byteLength;
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public FullyInlineTypedLiteralIV(String label) {
        this(label, null, null, false);
    }

    public FullyInlineTypedLiteralIV(String label, boolean temp) {
        this(label, null, null, temp);
    }

    public FullyInlineTypedLiteralIV(String label, String languageCode, URI datatypeURI) {
        this(label, languageCode, datatypeURI, 0, false);
    }

    public FullyInlineTypedLiteralIV(String label, String languageCode, URI datatypeURI, boolean temp) {
        this(label, languageCode, datatypeURI, 0, temp);
    }

    public FullyInlineTypedLiteralIV(String label, String languageCode, URI datatypeURI, int byteLength) {
        this(label, languageCode, datatypeURI, byteLength, false);
    }

    public FullyInlineTypedLiteralIV(String label, String languageCode, URI datatypeURI, int byteLength, boolean temp) {
        super(DTE.XSDString);
        if (label == null) {
            throw new IllegalArgumentException();
        }
        if (languageCode != null && datatypeURI != null) {
            throw new IllegalArgumentException();
        }
        this.label = label;
        this.language = languageCode;
        this.datatype = datatypeURI;
        this.termCode = datatypeURI != null ? (byte)4 : (languageCode != null ? (byte)3 : (byte)2);
        this.byteLength = byteLength;
        this.temp = temp;
    }

    @Override
    public final String getInlineValue() {
        return this.label;
    }

    @Override
    public boolean isNullIV() {
        return this.temp || super.isNullIV();
    }

    @Override
    public final String getLabel() {
        return this.label;
    }

    @Override
    public final String getLanguage() {
        return this.language;
    }

    @Override
    public final URI getDatatype() {
        return this.datatype;
    }

    public final byte getTermCode() {
        return this.termCode;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = this.datatype != null ? f.createLiteral(this.label, this.datatype) : (this.language != null ? f.createLiteral(this.label, this.language) : f.createLiteral(this.label));
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FullyInlineTypedLiteralIV)) {
            return false;
        }
        FullyInlineTypedLiteralIV t = (FullyInlineTypedLiteralIV)o;
        if (!this.label.equals(t.getLabel())) {
            return false;
        }
        if (this.language != null) {
            return this.language.equalsIgnoreCase(t.getLanguage());
        }
        if (t.getLanguage() != null) {
            return false;
        }
        if (this.datatype != null) {
            return this.datatype.equals(t.getDatatype());
        }
        return t.getDatatype() == null;
    }

    @Override
    public int hashCode() {
        return this.label.hashCode();
    }

    @Override
    public int byteLength() {
        if (this.byteLength == 0) {
            this.byteLength = 2 + (this.termCode == 3 ? IVUnicode.byteLengthUnicode(this.language) : (this.termCode == 4 ? IVUnicode.byteLengthUnicode(this.datatype.stringValue()) : 0)) + IVUnicode.byteLengthUnicode(this.label);
        }
        return this.byteLength;
    }

    @Override
    public final void setByteLength(int byteLength) {
        if (byteLength < 0) {
            throw new IllegalArgumentException();
        }
        if (this.byteLength != 0 && this.byteLength != byteLength) {
            throw new IllegalStateException();
        }
        this.byteLength = byteLength;
    }

    @Override
    public int _compareTo(IV o) {
        FullyInlineTypedLiteralIV t = (FullyInlineTypedLiteralIV)o;
        int ret = this.termCode - t.termCode;
        if (ret < 0) {
            return -1;
        }
        if (ret > 0) {
            return 1;
        }
        switch (this.termCode) {
            case 2: {
                return IVUnicode.IVUnicodeComparator.INSTANCE.compare(this.label, t.label);
            }
            case 3: {
                ret = IVUnicode.IVUnicodeComparator.INSTANCE.compare(this.language, t.language);
                if (ret < 0) {
                    return -1;
                }
                if (ret > 0) {
                    return 1;
                }
                return IVUnicode.IVUnicodeComparator.INSTANCE.compare(this.label, t.label);
            }
            case 4: {
                ret = IVUnicode.IVUnicodeComparator.INSTANCE.compare(this.datatype.stringValue(), t.datatype.stringValue());
                if (ret < 0) {
                    return -1;
                }
                if (ret > 0) {
                    return 1;
                }
                return IVUnicode.IVUnicodeComparator.INSTANCE.compare(this.label, t.label);
            }
        }
        throw new AssertionError();
    }
}

