/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.DTEExtension;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.InlineLiteralIV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.util.BytesUtil;
import java.util.Arrays;

public class LiteralArrayIV
extends AbstractLiteralIV<BigdataLiteral, Object[]> {
    private static final long serialVersionUID = 9136542087440805253L;
    private final InlineLiteralIV<?, ?>[] ivs;
    private transient byte[] key;
    private transient int hashCode = 0;

    public LiteralArrayIV(InlineLiteralIV<?, ?> ... ivs) {
        super(DTE.Extension);
        if (ivs == null || ivs.length == 0 || ivs.length > 256) {
            throw new IllegalArgumentException();
        }
        this.ivs = ivs;
    }

    @Override
    public DTEExtension getDTEX() {
        return DTEExtension.ARRAY;
    }

    public InlineLiteralIV<?, ?>[] getIVs() {
        return this.ivs;
    }

    private byte[] key() {
        if (this.key == null) {
            this.key = super.encode(KeyBuilder.newInstance()).getKey();
        }
        return this.key;
    }

    @Override
    public int byteLength() {
        return this.key().length;
    }

    public LiteralArrayIV clone(boolean clearCache) {
        return new LiteralArrayIV(this.ivs);
    }

    @Override
    public int _compareTo(IV o) {
        if (!(o instanceof LiteralArrayIV)) {
            throw new IllegalArgumentException();
        }
        LiteralArrayIV iv = (LiteralArrayIV)o;
        return BytesUtil.compareBytes(this.key(), iv.key());
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Arrays.hashCode(this.ivs);
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LiteralArrayIV other = (LiteralArrayIV)obj;
        return Arrays.equals(this.ivs, other.ivs);
    }

    @Override
    public String getLabel() {
        return "LiteralArrayIV[" + this.ivs.length + "]";
    }

    @Override
    public Object[] getInlineValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigdataLiteral asValue(LexiconRelation lex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

