/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.io.LongPacker;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.DTEExtension;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class PackedLongIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, Long>
implements Serializable,
Literal {
    private static final long serialVersionUID = 925868533758851987L;
    public static final URI PACKED_LONG = new URIImpl("http://www.bigdata.com/rdf/datatype#packedLong");
    public static final long MAX_POS_LONG_WITH_LEADING_ZERO_BYTE = 0xFFFFFFFFFFFFFFL;
    private final long value;
    private transient V literal;

    @Override
    public IV<V, Long> clone(boolean clearCache) {
        PackedLongIV tmp = new PackedLongIV(this.value);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public PackedLongIV(String value) {
        this(Long.valueOf(value));
    }

    public PackedLongIV(long value) {
        super(DTE.Extension);
        if (value < 0L || value > 0xFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("long value out of range: " + value);
        }
        this.value = value;
    }

    @Override
    public Long getInlineValue() throws UnsupportedOperationException {
        return this.value;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        if (this.literal == null) {
            this.literal = lex.getValueFactory().createLiteral(this.getLabel(), PACKED_LONG);
            this.literal.setIV(this);
        }
        return this.literal;
    }

    @Override
    public int byteLength() {
        return 2 + LongPacker.getByteLength(this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PackedLongIV) {
            return this.value == ((PackedLongIV)o).value;
        }
        return false;
    }

    @Override
    public int _compareTo(IV o) {
        if (this.value < ((PackedLongIV)o).value) {
            return -1;
        }
        if (this.value > ((PackedLongIV)o).value) {
            return 1;
        }
        return 0;
    }

    @Override
    public DTEExtension getDTEX() {
        return DTEExtension.PACKED_LONG;
    }

    @Override
    public boolean booleanValue() {
        return this.value > 0L;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public BigInteger integerValue() {
        return BigInteger.valueOf(this.value);
    }

    @Override
    public BigDecimal decimalValue() {
        return BigDecimal.valueOf(this.value);
    }
}

