/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.uri;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractInlineExtensionIV;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class URIExtensionIV<V extends BigdataURI>
extends AbstractInlineExtensionIV<V, Object>
implements URI {
    private static final long serialVersionUID = 8267554196603121194L;
    private final AbstractInlineIV<BigdataURI, ?> namespaceIV;
    private final AbstractLiteralIV<BigdataLiteral, ?> delegateIV;

    @Override
    public IV<V, Object> clone(boolean clearCache) {
        URIExtensionIV tmp = new URIExtensionIV(this.delegateIV, this.namespaceIV);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public URIExtensionIV(AbstractLiteralIV<BigdataLiteral, ?> delegateIV, IV<?, ?> namespaceIV) {
        super(VTE.URI, true, delegateIV.getDTE());
        if (namespaceIV == null) {
            throw new IllegalArgumentException();
        }
        if (!namespaceIV.isInline()) {
            throw new IllegalArgumentException();
        }
        if (!delegateIV.isInline()) {
            throw new IllegalArgumentException();
        }
        this.delegateIV = delegateIV;
        this.namespaceIV = (AbstractInlineIV)namespaceIV;
    }

    @Override
    public boolean needsMaterialization() {
        return this.delegateIV.needsMaterialization() || this.namespaceIV.needsMaterialization();
    }

    public AbstractLiteralIV<BigdataLiteral, ?> getLocalNameIV() {
        return this.delegateIV;
    }

    @Override
    public Object getInlineValue() {
        return new URIImpl(this.stringValue());
    }

    @Override
    public IV<BigdataURI, ?> getExtensionIV() {
        return this.namespaceIV;
    }

    @Override
    public int hashCode() {
        return this.namespaceIV.hashCode() ^ this.delegateIV.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof URIExtensionIV) {
            return this.delegateIV.equals(((URIExtensionIV)o).delegateIV) && this.namespaceIV.equals(((URIExtensionIV)o).namespaceIV);
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.namespaceIV != null && this.delegateIV != null) {
            return this.namespaceIV.toString() + ":" + this.delegateIV.toString();
        }
        return ((BigdataURI)this.getValue()).stringValue();
    }

    @Override
    public String stringValue() {
        return this.toString();
    }

    @Override
    public String getNamespace() {
        if (this.namespaceIV != null) {
            return ((BigdataURI)this.namespaceIV.getValue()).stringValue();
        }
        return ((BigdataURI)this.getValue()).getNamespace();
    }

    @Override
    public String getLocalName() {
        if (this.delegateIV != null) {
            return this.delegateIV.getInlineValue().toString();
        }
        return ((BigdataURI)this.getValue()).getLocalName();
    }

    @Override
    public int _compareTo(IV o) {
        int ret = this.namespaceIV.compareTo(((URIExtensionIV)o).namespaceIV);
        if (ret != 0) {
            return ret;
        }
        return this.delegateIV._compareTo(((URIExtensionIV)o).delegateIV);
    }

    @Override
    public int byteLength() {
        return 1 + this.namespaceIV.byteLength() + this.delegateIV.byteLength();
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataURI v = (BigdataURI)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            URI namespace = (URI)this.namespaceIV.asValue(lex);
            String localName = lex.getLexiconConfiguration().getInlineURILocalNameFromDelegate(namespace, this.delegateIV);
            v = this.setValue(f.createURI(namespace.stringValue(), localName));
            v.setIV(this);
        }
        return (V)v;
    }
}

