/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.uri;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import org.openrdf.model.URI;

public class VocabURIShortIV<V extends BigdataURI>
extends AbstractInlineIV<V, Short>
implements URI {
    private static final long serialVersionUID = -3354960247086946301L;
    private final short value;

    @Override
    public IV<V, Short> clone(boolean clearCache) {
        return this;
    }

    public VocabURIShortIV(short value) {
        super(VTE.URI, DTE.XSDShort);
        this.value = value;
    }

    @Override
    public final boolean isVocabulary() {
        return true;
    }

    @Override
    public int _compareTo(IV o) {
        short value2 = ((VocabURIShortIV)o).value;
        return this.value == value2 ? 0 : (this.value < value2 ? -1 : 1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VocabURIShortIV) {
            return this.value == ((VocabURIShortIV)o).value;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.value;
    }

    @Override
    public V asValue(LexiconRelation lex) throws UnsupportedOperationException {
        BigdataURI v = (BigdataURI)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = (BigdataURI)lex.getContainer().getVocabulary().asValue(this);
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public final int byteLength() {
        return 3;
    }

    @Override
    public final Short getInlineValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "Vocab(" + Short.toString(this.value) + ")" + (this.hasValue() ? "[" + ((BigdataURI)this.getValue()).stringValue() + "]" : "");
    }

    @Override
    public boolean needsMaterialization() {
        return true;
    }

    @Override
    public String stringValue() {
        return ((BigdataURI)this.getValue()).stringValue();
    }

    @Override
    public String getLocalName() {
        return ((BigdataURI)this.getValue()).getLocalName();
    }

    @Override
    public String getNamespace() {
        return ((BigdataURI)this.getValue()).getNamespace();
    }
}

