/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.raba.codec.SimpleRabaCoder;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.ISubjectCentricTextIndexer;
import com.bigdata.rdf.lexicon.RDFFullTextIndexTupleSerializer;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.search.FullTextIndex;
import com.bigdata.search.Hit;
import com.bigdata.search.TokenBuffer;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;

public class BigdataSubjectCentricFullTextIndex
extends FullTextIndex
implements ISubjectCentricTextIndexer<Hit> {
    private static final transient Logger log = Logger.getLogger(BigdataSubjectCentricFullTextIndex.class);
    public static final transient String NAME_SUBJ_SEARCH = "subjectSearch";
    private final boolean indexDatatypeLiterals = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.TEXT_INDEX_DATATYPE_LITERALS, "true"));
    private volatile IIndex ndx;

    public static BigdataSubjectCentricFullTextIndex getInstance(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        return new BigdataSubjectCentricFullTextIndex(indexManager, namespace, timestamp, properties);
    }

    @Override
    public boolean getIndexDatatypeLiterals() {
        return this.indexDatatypeLiterals;
    }

    public BigdataSubjectCentricFullTextIndex(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(indexManager, namespace, timestamp, properties);
    }

    @Override
    public void create() {
        this.assertWritable();
        String name = this.getNamespace() + "." + NAME_SUBJ_SEARCH;
        IIndexManager indexManager = this.getIndexManager();
        Properties p = this.getProperties();
        IndexMetadata indexMetadata = new IndexMetadata(indexManager, p, name, UUID.randomUUID(), IndexTypeEnum.BTree);
        Properties tmp = new Properties(p);
        tmp.setProperty(KeyBuilder.Options.STRENGTH, p.getProperty(FullTextIndex.Options.INDEXER_COLLATOR_STRENGTH, FullTextIndex.Options.DEFAULT_INDEXER_COLLATOR_STRENGTH));
        DefaultKeyBuilderFactory keyBuilderFactory = new DefaultKeyBuilderFactory(tmp);
        boolean fieldsEnabled = Boolean.parseBoolean(p.getProperty(FullTextIndex.Options.FIELDS_ENABLED, "false"));
        if (log.isInfoEnabled()) {
            log.info(FullTextIndex.Options.FIELDS_ENABLED + "=" + fieldsEnabled);
        }
        indexMetadata.setTupleSerializer(new RDFFullTextIndexTupleSerializer(keyBuilderFactory, DefaultTupleSerializer.getDefaultLeafKeysCoder(), SimpleRabaCoder.INSTANCE, fieldsEnabled));
        indexManager.registerIndex(indexMetadata);
        if (log.isInfoEnabled()) {
            log.info("Registered new subject-centric text index: name=" + name);
        }
    }

    @Override
    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info("");
        }
        this.assertWritable();
        String name = this.getNamespace() + "." + NAME_SUBJ_SEARCH;
        this.getIndexManager().dropIndex(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IIndex getIndex() {
        if (this.ndx == null) {
            BigdataSubjectCentricFullTextIndex bigdataSubjectCentricFullTextIndex = this;
            synchronized (bigdataSubjectCentricFullTextIndex) {
                this.ndx = this.getIndex(this.getNamespace() + "." + NAME_SUBJ_SEARCH);
                if (this.ndx == null) {
                    throw new IllegalStateException();
                }
            }
        }
        return this.ndx;
    }

    @Override
    public void index(IV<?, ?> subject, Iterator<BigdataValue> valuesIterator) {
        if (subject == null) {
            throw new IllegalArgumentException();
        }
        if (log.isDebugEnabled()) {
            log.debug("indexing: " + subject);
        }
        TokenBuffer buffer = new TokenBuffer(1, this);
        int n = 0;
        while (valuesIterator.hasNext()) {
            BigdataValue val = valuesIterator.next();
            if (log.isDebugEnabled()) {
                log.debug("value: " + val);
            }
            if (!(val instanceof Literal)) continue;
            Literal lit = (Literal)((Object)val);
            if (!this.indexDatatypeLiterals && lit.getDatatype() != null) continue;
            String languageCode = lit.getLanguage();
            String text = lit.getLabel();
            this.index(buffer, subject, 0, languageCode, new StringReader(text));
            ++n;
        }
        buffer.flush();
        if (log.isInfoEnabled()) {
            log.info("indexed " + n + " new values for s: " + subject);
        }
    }
}

