/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KVO;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.keys.SuccessorUtil;
import com.bigdata.io.ByteArrayBuffer;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.util.BytesUtil;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class BlobsIndexHelper {
    private static final Logger log = Logger.getLogger(BlobsIndexHelper.class);
    public static final transient int SIZEOF_HASH = 4;
    public static final transient int SIZEOF_COUNTER = 2;
    public static final transient int MAX_COUNTER = 65535;
    public static final transient int OFFSET_COUNTER = 6;
    public static final transient int SIZEOF_PREFIX_KEY = 6;
    public static final transient int TERMS_INDEX_KEY_SIZE = 8;
    public static final transient int LOG_WARN_COUNTER_THRESHOLD = 127;
    public static final transient int NOT_FOUND = Integer.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KVO<BigdataValue>[] generateKVOs(BigdataValueSerializer<BigdataValue> valSer, BigdataValue[] terms, int numTerms) {
        if (valSer == null) {
            throw new IllegalArgumentException();
        }
        if (terms == null) {
            throw new IllegalArgumentException();
        }
        if (numTerms <= 0 || numTerms > terms.length) {
            throw new IllegalArgumentException();
        }
        KVO[] a = new KVO[numTerms];
        IKeyBuilder keyBuilder = this.newKeyBuilder();
        ByteArrayBuffer tmp = new ByteArrayBuffer();
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            for (int i = 0; i < numTerms; ++i) {
                BigdataValue term = terms[i];
                VTE vte = VTE.valueOf(term);
                int hashCode = term.hashCode();
                byte[] key = this.makePrefixKey(keyBuilder.reset(), vte, hashCode);
                byte[] val = valSer.serialize(term, out.reset(), tmp);
                a[i] = new KVO<BigdataValue>(key, val, term);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return a;
    }

    public int resolveOrAddValue(IIndex termsIndex, boolean readOnly, IKeyBuilder keyBuilder, byte[] baseKey, byte[] val, byte[] tmp, AtomicInteger bucketSize) {
        assert (baseKey.length == 6) : "Expecting 6 bytes, not " + baseKey.length;
        byte[] fromKey = baseKey;
        byte[] toKey = this.makeToKey(fromKey, tmp);
        long rangeCount = termsIndex.rangeCount(fromKey, toKey);
        if (bucketSize != null) {
            bucketSize.set((int)rangeCount);
        }
        if (rangeCount == 0L && readOnly) {
            return Integer.MIN_VALUE;
        }
        if (rangeCount >= 65535L) {
            throw new CollisionBucketSizeException(rangeCount);
        }
        if (rangeCount == 0L) {
            assert (!readOnly);
            byte[] key = this.makeKey(keyBuilder.reset(), baseKey, (int)rangeCount);
            if (termsIndex.insert(key, val) != null) {
                throw new AssertionError();
            }
            return (int)rangeCount;
        }
        ITupleIterator itr = termsIndex.rangeIterator(fromKey, toKey, 0, 3, null);
        while (itr.hasNext()) {
            ByteArrayBuffer tb;
            ITuple tuple = itr.next();
            if (tuple.isNull() || 0 != BytesUtil.compareBytesWithLenAndOffset(0, val.length, val, 0, (tb = tuple.getValueBuffer()).limit(), tb.array())) continue;
            short asFoundCounter = KeyBuilder.decodeShort(tuple.getKeyBuffer().array(), 6);
            return asFoundCounter;
        }
        if (readOnly) {
            return Integer.MIN_VALUE;
        }
        byte[] key = this.makeKey(keyBuilder.reset(), baseKey, (int)rangeCount);
        if (termsIndex.insert(key, val) != null) {
            throw new AssertionError();
        }
        if (rangeCount >= 127L) {
            log.warn("Collision: hashCode=" + BytesUtil.toString(key) + ", collisionBucketSize=" + rangeCount);
        }
        return (int)rangeCount;
    }

    public int addBNode(IIndex ndx, IKeyBuilder keyBuilder, byte[] baseKey, byte[] val, byte[] tmp) {
        byte[] fromKey = baseKey;
        byte[] toKey = this.makeToKey(fromKey, tmp);
        long rangeCount = ndx.rangeCount(fromKey, toKey);
        if (rangeCount >= 65535L) {
            throw new CollisionBucketSizeException(rangeCount);
        }
        byte[] key = this.makeKey(keyBuilder.reset(), baseKey, (int)rangeCount);
        if (ndx.insert(key, val) != null) {
            throw new AssertionError();
        }
        if (rangeCount >= 127L) {
            log.warn("Collision: hashCode=" + BytesUtil.toString(key) + ", collisionBucketSize=" + rangeCount);
        }
        return (int)rangeCount;
    }

    public byte[] lookup(IIndex ndx, BlobIV<?> iv, IKeyBuilder keyBuilder) {
        byte[] key = iv.encode(keyBuilder.reset()).getKey();
        return ndx.lookup(key);
    }

    public byte[] makeKey(IKeyBuilder keyBuilder, byte[] baseKey, int counter) {
        byte[] key = keyBuilder.append(baseKey).append((short)counter).getKey();
        assert (key.length == 8);
        return key;
    }

    public byte[] makeKey(IKeyBuilder keyBuilder, VTE vte, int hashCode, int counter) {
        keyBuilder.appendSigned(BlobIV.toFlags(vte));
        keyBuilder.appendSigned((byte)0);
        keyBuilder.append(hashCode);
        keyBuilder.append((short)counter);
        byte[] key = keyBuilder.getKey();
        assert (key.length == 8);
        return key;
    }

    public byte[] makePrefixKey(IKeyBuilder keyBuilder, VTE vte, int hashCode) {
        keyBuilder.appendSigned(BlobIV.toFlags(vte));
        keyBuilder.appendSigned((byte)0);
        keyBuilder.append(hashCode);
        byte[] prefixKey = keyBuilder.getKey();
        assert (prefixKey.length == 6);
        return prefixKey;
    }

    public byte[] makePrefixKey(IKeyBuilder keyBuilder, BigdataValue value) {
        VTE vte = VTE.valueOf(value);
        return this.makePrefixKey(keyBuilder, vte, value.hashCode());
    }

    byte[] makeToKey(byte[] fromKey, byte[] tmp) {
        byte[] toKey;
        assert (fromKey.length == 6);
        if (tmp == null) {
            toKey = new byte[6];
        } else {
            if (tmp.length != 6) {
                throw new IllegalArgumentException();
            }
            toKey = tmp;
        }
        System.arraycopy(fromKey, 0, toKey, 0, 6);
        SuccessorUtil.successor(toKey);
        return tmp;
    }

    public IKeyBuilder newKeyBuilder() {
        return new KeyBuilder(8);
    }

    public static class CollisionBucketSizeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CollisionBucketSizeException(long rangeCount) {
            super("ncoll=" + rangeCount);
        }
    }
}

