/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.IIndex;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedure;
import com.bigdata.btree.proc.AbstractKeyArrayIndexProcedureConstructor;
import com.bigdata.btree.proc.AbstractLocalSplitResultAggregator;
import com.bigdata.btree.proc.IParallelizableIndexProcedure;
import com.bigdata.btree.proc.IResultHandler;
import com.bigdata.btree.proc.SplitValuePair;
import com.bigdata.btree.raba.IRaba;
import com.bigdata.btree.raba.codec.IRabaCoder;
import com.bigdata.io.DataOutputBuffer;
import com.bigdata.io.LongPacker;
import com.bigdata.io.ShortPacker;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.relation.IMutableRelationIndexWriteProcedure;
import com.bigdata.service.Split;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.log4j.Logger;

public class BlobsWriteProc
extends AbstractKeyArrayIndexProcedure<Result>
implements IParallelizableIndexProcedure<Result>,
IMutableRelationIndexWriteProcedure<Result> {
    private static final Logger log = Logger.getLogger(BlobsWriteProc.class);
    private static final long serialVersionUID = 1L;
    private boolean readOnly;
    private boolean toldBNodes;

    @Override
    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final boolean isToldBNodes() {
        return this.toldBNodes;
    }

    public BlobsWriteProc() {
    }

    protected BlobsWriteProc(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals, boolean readOnly, boolean storeBlankNodes) {
        super(keySer, valSer, fromIndex, toIndex, keys, vals);
        this.readOnly = readOnly;
        this.toldBNodes = storeBlankNodes;
    }

    @Override
    public Result applyOnce(IIndex ndx, IRaba keys, IRaba vals) {
        int numTerms = keys.size();
        assert (numTerms > 0) : "numTerms=" + numTerms;
        BlobsIndexHelper helper = new BlobsIndexHelper();
        IKeyBuilder keyBuilder = helper.newKeyBuilder();
        int[] counters = new int[numTerms];
        byte[] baseKey = new byte[keyBuilder.capacity() - 2];
        byte[] tmp = new byte[6];
        long totalBucketSize = 0L;
        int maxBucketSize = 0;
        DataOutputBuffer kbuf = new DataOutputBuffer(0, baseKey);
        for (int i = 0; i < numTerms; ++i) {
            int counter;
            keys.copy(i, kbuf.reset());
            VTE vte = AbstractIV.getVTE(KeyBuilder.decodeByte(baseKey[0]));
            if (!this.toldBNodes && vte == VTE.BNODE) {
                counter = this.readOnly ? Integer.MIN_VALUE : helper.addBNode(ndx, keyBuilder, baseKey, vals.get(i), tmp);
            } else {
                byte[] val = vals.get(i);
                counter = helper.resolveOrAddValue(ndx, this.readOnly, keyBuilder, baseKey, val, tmp, null);
            }
            if (!this.readOnly && counter < 0) {
                throw new AssertionError((Object)("counter=" + counter));
            }
            counters[i] = counter;
            if (counter == Integer.MIN_VALUE) continue;
            if (maxBucketSize < counter) {
                maxBucketSize += counter;
            }
            totalBucketSize += (long)counter;
        }
        return new Result(totalBucketSize, maxBucketSize, counters);
    }

    @Override
    protected void readMetadata(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readMetadata(in);
        this.readOnly = in.readBoolean();
    }

    @Override
    protected void writeMetadata(ObjectOutput out) throws IOException {
        super.writeMetadata(out);
        out.writeBoolean(this.readOnly);
    }

    @Override
    protected IResultHandler<Result, Result> newAggregator() {
        return new BlobResultAggregator(this.getKeys().size());
    }

    private class BlobResultAggregator
    extends AbstractLocalSplitResultAggregator<Result> {
        public BlobResultAggregator(int size) {
            super(size);
        }

        @Override
        protected Result newResult(int size, SplitValuePair<Split, Result>[] a) {
            long totalBucketSize = 0L;
            int maxBucketSize = 0;
            int[] counters = new int[size];
            for (int i = 0; i < a.length; ++i) {
                Object split = a[i].key;
                Result tmp = (Result)a[i].val;
                totalBucketSize += tmp.totalBucketSize;
                maxBucketSize = Math.max(maxBucketSize, tmp.maxBucketSize);
                System.arraycopy(tmp.counters, 0, counters, ((Split)split).fromIndex, ((Split)split).ntuples);
            }
            Result r = new Result(totalBucketSize, maxBucketSize, counters);
            return r;
        }
    }

    public static class Result
    implements Externalizable {
        public long totalBucketSize;
        public int maxBucketSize;
        public int[] counters;
        private static final long serialVersionUID = 1L;
        private static final transient short VERSION0 = 0;

        public Result() {
        }

        public Result(long totalBucketSize, int maxBucketSize, int[] counters) {
            if (counters == null) {
                throw new IllegalArgumentException();
            }
            this.totalBucketSize = totalBucketSize;
            this.maxBucketSize = maxBucketSize;
            this.counters = counters;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            short version = ShortPacker.unpackShort(in);
            if (version != 0) {
                throw new IOException("Unknown version: " + version);
            }
            int n = (int)LongPacker.unpackLong(in);
            this.totalBucketSize = LongPacker.unpackLong(in);
            this.maxBucketSize = LongPacker.unpackInt(in);
            this.counters = new int[n];
            for (int i = 0; i < n; ++i) {
                short tmp = ShortPacker.unpackShort(in);
                this.counters[i] = tmp == Short.MAX_VALUE ? Integer.MIN_VALUE : (int)tmp;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            int n = this.counters.length;
            ShortPacker.packShort(out, (short)0);
            LongPacker.packLong(out, (long)n);
            LongPacker.packLong(out, this.totalBucketSize);
            LongPacker.packLong(out, (long)this.maxBucketSize);
            for (int i = 0; i < n; ++i) {
                int c = this.counters[i];
                short tmp = (short)(c == Integer.MIN_VALUE ? Short.MAX_VALUE : (short)c);
                ShortPacker.packShort(out, tmp);
            }
        }
    }

    public static class BlobsWriteProcConstructor
    extends AbstractKeyArrayIndexProcedureConstructor<BlobsWriteProc> {
        private final boolean readOnly;
        private final boolean toldBNodes;

        @Override
        public final boolean sendValues() {
            return true;
        }

        public BlobsWriteProcConstructor(boolean readOnly, boolean toldBNodes) {
            this.readOnly = readOnly;
            this.toldBNodes = toldBNodes;
        }

        @Override
        public BlobsWriteProc newInstance(IRabaCoder keySer, IRabaCoder valSer, int fromIndex, int toIndex, byte[][] keys, byte[][] vals) {
            if (log.isInfoEnabled()) {
                log.info("ntuples=" + (toIndex - fromIndex));
            }
            return new BlobsWriteProc(keySer, valSer, fromIndex, toIndex, keys, vals, this.readOnly, this.toldBNodes);
        }
    }
}

