/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.rdf.load.IStatementBufferFactory;
import com.bigdata.rdf.load.ITaskFactory;
import com.bigdata.rdf.load.RDFLoadTaskFactory;
import com.bigdata.rdf.load.SingleResourceReaderTask;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.io.File;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.rio.RDFFormat;

public class AbstractRDFTaskFactory<S extends Statement, T extends Runnable>
implements ITaskFactory<T> {
    protected static final Logger log = Logger.getLogger(RDFLoadTaskFactory.class);
    protected final AbstractTripleStore db;
    private long beginTime;
    private long endTime;
    public final RDFFormat fallback;
    public final RDFParserOptions parserOptions;
    public final boolean deleteAfter;
    final IStatementBufferFactory bufferFactory;
    final AtomicLong toldTriples = new AtomicLong(0L);

    public void notifyStart() {
        this.endTime = 0L;
        this.beginTime = System.currentTimeMillis();
    }

    public void notifyEnd() {
        this.endTime = System.currentTimeMillis();
        assert (this.beginTime <= this.endTime);
    }

    public long elapsed() {
        if (this.endTime == 0L) {
            return System.currentTimeMillis() - this.beginTime;
        }
        long elapsed = this.endTime - this.beginTime;
        assert (elapsed >= 0L);
        return elapsed;
    }

    public IStatementBufferFactory<S> getBufferFactory() {
        return this.bufferFactory;
    }

    public RDFFormat getRDFFormat(String filename) {
        RDFFormat rdfFormat = this.fallback == null ? RDFFormat.forFileName(filename) : RDFFormat.forFileName(filename, this.fallback);
        return rdfFormat;
    }

    protected AbstractRDFTaskFactory(AbstractTripleStore db, RDFParserOptions parserOptions, boolean deleteAfter, RDFFormat fallback, IStatementBufferFactory bufferFactory) {
        this.db = db;
        this.parserOptions = parserOptions;
        this.deleteAfter = deleteAfter;
        this.fallback = fallback;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public T newTask(String resource) throws Exception {
        String baseURL;
        RDFFormat rdfFormat;
        if (log.isInfoEnabled()) {
            log.info("resource=" + resource);
        }
        if ((rdfFormat = this.getRDFFormat(resource)) == null) {
            throw new RuntimeException("Could not determine interchange syntax - skipping : file=" + resource);
        }
        try {
            baseURL = new File(resource).toURL().toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("resource=" + resource);
        }
        return (T)new SingleResourceReaderTask(resource, baseURL, rdfFormat, this.parserOptions, this.deleteAfter, this.bufferFactory, this.toldTriples);
    }
}

