/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.rio.IStatementBuffer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.ContextStatementImpl;
import org.openrdf.model.impl.StatementImpl;

public abstract class AbstractStatementBuffer<F extends Statement, G extends BigdataStatement>
implements IStatementBuffer<F> {
    protected static final Logger log = Logger.getLogger(AbstractStatementBuffer.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final AbstractTripleStore db;
    protected final boolean readOnly;
    private final int capacity;
    private final BigdataValue[] valueBuffer;
    private int nvalues = 0;
    protected final G[] statementBuffer;
    private int nstmts = 0;
    private final List<G> deferredStatementBuffer;
    private final Map<Value, BigdataValue> distinctValues;
    private Map<String, BigdataBNode> bnodes = null;
    private final BigdataValueFactory valueFactory;
    private long counter = 0L;

    @Override
    public AbstractTripleStore getDatabase() {
        return this.db;
    }

    @Override
    public AbstractTripleStore getStatementStore() {
        return this.db;
    }

    public BigdataValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public AbstractStatementBuffer(AbstractTripleStore db, boolean readOnly, int capacity) {
        if (db == null) {
            throw new IllegalArgumentException();
        }
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.db = db;
        this.readOnly = readOnly;
        this.valueBuffer = new BigdataValue[capacity * 3];
        this.statementBuffer = new BigdataStatement[capacity];
        this.distinctValues = new HashMap<Value, BigdataValue>(capacity * db.getSPOKeyArity());
        this.deferredStatementBuffer = db.getStatementIdentifiers() ? new LinkedList() : null;
        this.valueFactory = db.getValueFactory();
    }

    @Override
    public void setBNodeMap(Map<String, BigdataBNode> bnodes) {
        if (bnodes == null) {
            throw new IllegalArgumentException();
        }
        if (this.bnodes != null) {
            throw new IllegalStateException();
        }
        this.bnodes = bnodes;
    }

    protected BigdataValue convertValue(Value value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BNode) {
            BigdataBNode b;
            String id = ((BNode)value).getID();
            if (this.bnodes == null) {
                this.bnodes = new HashMap<String, BigdataBNode>(this.capacity);
            }
            if ((b = this.bnodes.get(id)) == null) {
                b = this.valueFactory.createBNode(id);
                this.bnodes.put(id, b);
            }
            return b;
        }
        BigdataValue b = this.distinctValues.get(value);
        if (b == null) {
            if (value instanceof URI) {
                b = this.valueFactory.asValue(value);
            } else if (value instanceof Literal) {
                b = this.valueFactory.asValue(value);
            } else {
                throw new AssertionError();
            }
            this.distinctValues.put(value, b);
            this.valueBuffer[this.nvalues++] = b;
        }
        return b;
    }

    @Override
    public boolean isEmpty() {
        return this.nstmts == 0 && (this.deferredStatementBuffer == null || !this.deferredStatementBuffer.isEmpty());
    }

    @Override
    public int size() {
        return this.nstmts + (this.deferredStatementBuffer == null ? 0 : this.deferredStatementBuffer.size());
    }

    @Override
    public void add(F e) {
        if (this.nstmts == this.capacity) {
            this.overflow();
        }
        BigdataStatement stmt = this.getValueFactory().createStatement((BigdataResource)this.convertValue(e.getSubject()), (BigdataURI)this.convertValue(e.getPredicate()), this.convertValue(e.getObject()), (BigdataResource)this.convertValue(e.getContext()), e instanceof BigdataStatement ? ((BigdataStatement)e).getStatementType() : StatementEnum.Explicit);
        if (this.deferredStatementBuffer != null && (e.getSubject() instanceof BNode || e.getObject() instanceof BNode)) {
            if (INFO) {
                log.info("deferred: " + stmt);
            }
            this.deferredStatementBuffer.add(stmt);
        } else {
            if (INFO) {
                log.info("added=" + stmt);
            }
            this.statementBuffer[this.nstmts++] = stmt;
        }
    }

    @Override
    public void add(Resource s, URI p, Value o) {
        this.add((F)new StatementImpl(s, p, o));
    }

    @Override
    public void add(Resource s, URI p, Value o, Resource c) {
        this.add((F)new ContextStatementImpl(s, p, o, c));
    }

    @Override
    public void add(Resource s, URI p, Value o, Resource c, StatementEnum type) {
        BigdataStatement stmt = this.getValueFactory().createStatement((BigdataResource)this.convertValue(s), (BigdataURI)this.convertValue(p), this.convertValue(o), (BigdataResource)this.convertValue(c), type);
        this.add((F)stmt);
    }

    protected void processBufferedValues() {
        if (INFO) {
            log.info("nvalues=" + this.nvalues);
        }
        this.db.getLexiconRelation().addTerms(this.valueBuffer, this.nvalues, this.readOnly);
    }

    protected void processDeferredStatements() {
        if (this.deferredStatementBuffer == null || this.deferredStatementBuffer.isEmpty()) {
            return;
        }
        if (INFO) {
            log.info("");
        }
        throw new UnsupportedOperationException();
    }

    protected final void overflow() {
        if (INFO) {
            log.info("nvalues=" + this.nvalues + ", nstmts=" + this.nstmts);
        }
        if (this.nstmts == 0) {
            return;
        }
        this.processBufferedValues();
        BigdataStatement[] a = new BigdataStatement[this.nstmts];
        for (int i = 0; i < this.nstmts; ++i) {
            a[i] = this.statementBuffer[i];
        }
        this.counter += (long)this.handleProcessedStatements(a);
        this.clear();
    }

    protected abstract int handleProcessedStatements(G[] var1);

    @Override
    public long flush() {
        if (INFO) {
            log.info("");
        }
        this.processBufferedValues();
        this.processDeferredStatements();
        this.overflow();
        long n = this.counter;
        this.reset();
        return n;
    }

    @Override
    public void reset() {
        if (INFO) {
            log.info("");
        }
        this.bnodes = null;
        if (this.deferredStatementBuffer != null) {
            this.deferredStatementBuffer.clear();
        }
        this.counter = 0L;
        this.clear();
    }

    protected void clear() {
        if (INFO) {
            log.info("");
        }
        this.distinctValues.clear();
        this.nvalues = 0;
        this.nstmts = 0;
    }

    public static class StatementBuffer2<F extends Statement, G extends BigdataStatement>
    extends AbstractStatementBuffer<F, G> {
        private final AbstractTripleStore statementStore;

        public StatementBuffer2(AbstractTripleStore lexiconStore, boolean readOnly, int capacity) {
            this(lexiconStore, lexiconStore, readOnly, capacity);
        }

        public StatementBuffer2(AbstractTripleStore lexiconStore, AbstractTripleStore statementStore, boolean readOnly, int capacity) {
            super(lexiconStore, readOnly, capacity);
            if (statementStore == null) {
                throw new IllegalArgumentException();
            }
            this.statementStore = statementStore;
        }

        @Override
        public AbstractTripleStore getStatementStore() {
            return this.statementStore;
        }

        @Override
        protected int handleProcessedStatements(G[] a) {
            if (this.readOnly) {
                return 0;
            }
            ISPO[] b = new SPO[a.length];
            for (int i = 0; i < a.length; ++i) {
                b[i] = new SPO((BigdataStatement)a[i]);
            }
            return (int)this.statementStore.addStatements(b, b.length);
        }

        @Override
        public long flush() {
            return super.flush();
        }
    }
}

