/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.rio.IRioLoader;
import com.bigdata.rdf.rio.RDFParserOptions;
import com.bigdata.rdf.rio.RioLoaderEvent;
import com.bigdata.rdf.rio.RioLoaderListener;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.openrdf.model.Statement;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class BasicRioLoader
implements IRioLoader {
    protected static final transient Logger log = Logger.getLogger(IRioLoader.class);
    public long stmtsAdded;
    long insertTime;
    long insertStart;
    Vector<RioLoaderListener> listeners;
    private final ValueFactory valueFactory;
    protected String defaultGraph;

    public BasicRioLoader(ValueFactory valueFactory) {
        if (valueFactory == null) {
            throw new IllegalArgumentException();
        }
        this.valueFactory = valueFactory;
    }

    @Override
    public final long getStatementsAdded() {
        return this.stmtsAdded;
    }

    @Override
    public final long getInsertTime() {
        return this.insertTime;
    }

    @Override
    public final long getInsertRate() {
        return (long)((double)this.stmtsAdded * 1000.0 / (double)this.insertTime);
    }

    @Override
    public final void addRioLoaderListener(RioLoaderListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public final void removeRioLoaderListener(RioLoaderListener l) {
        this.listeners.remove(l);
    }

    protected final void notifyListeners() {
        if (this.listeners == null) {
            return;
        }
        RioLoaderEvent e = new RioLoaderEvent(this.stmtsAdded, System.currentTimeMillis() - this.insertStart);
        Iterator<RioLoaderListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().processingNotification(e);
        }
    }

    protected final RDFParser getParser(RDFFormat rdfFormat) {
        RDFParser parser = Rio.createParser(rdfFormat, this.valueFactory);
        parser.setValueFactory(this.valueFactory);
        return parser;
    }

    @Override
    public final void loadRdf(InputStream is, String baseURI, RDFFormat rdfFormat, String defaultGraph, RDFParserOptions options) throws Exception {
        this.loadRdf2(is, baseURI, rdfFormat, defaultGraph, options);
    }

    @Override
    public final void loadRdf(Reader reader, String baseURI, RDFFormat rdfFormat, String defaultGraph, RDFParserOptions options) throws Exception {
        this.loadRdf2(reader, baseURI, rdfFormat, defaultGraph, options);
    }

    protected void loadRdf2(Object source, String baseURI, RDFFormat rdfFormat, String defaultGraph, RDFParserOptions options) throws Exception {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        if (!(source instanceof Reader) && !(source instanceof InputStream)) {
            throw new IllegalArgumentException();
        }
        if (options == null) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info("format=" + rdfFormat + ", options=" + options);
        }
        this.defaultGraph = defaultGraph;
        RDFParser parser = this.getParser(rdfFormat);
        options.apply(parser);
        parser.setRDFHandler(this.newRDFHandler());
        this.insertStart = System.currentTimeMillis();
        this.insertTime = 0L;
        this.stmtsAdded = 0L;
        try {
            this.before();
            log.info("Starting parse.");
            if (source instanceof Reader) {
                parser.parse((Reader)source, baseURI);
            } else if (source instanceof InputStream) {
                parser.parse((InputStream)source, baseURI);
            } else {
                throw new AssertionError();
            }
            this.insertTime = System.currentTimeMillis() - this.insertStart;
            if (log.isInfoEnabled()) {
                log.info("parse complete: elapsed=" + this.insertTime + "ms, toldTriples=" + this.stmtsAdded + ", tps=" + this.getInsertRate());
            }
            this.success();
        }
        catch (RuntimeException ex) {
            this.insertTime += System.currentTimeMillis() - this.insertStart;
            try {
                this.error(ex);
            }
            catch (Exception ex2) {
                log.error("Ignoring: " + ex2);
            }
            throw ex;
        }
        finally {
            this.cleanUp();
        }
    }

    protected void before() {
    }

    protected void success() {
    }

    protected void error(Exception ex) {
    }

    protected void cleanUp() {
    }

    public RDFHandler newRDFHandler() {
        return new BasicRDFHandler();
    }

    static {
        ServiceProviderHook.forceLoad();
    }

    private class BasicRDFHandler
    implements RDFHandler {
        @Override
        public void endRDF() throws RDFHandlerException {
        }

        @Override
        public void handleComment(String arg0) throws RDFHandlerException {
        }

        @Override
        public void handleNamespace(String arg0, String arg1) throws RDFHandlerException {
        }

        @Override
        public void handleStatement(Statement arg0) throws RDFHandlerException {
            ++BasicRioLoader.this.stmtsAdded;
        }

        @Override
        public void startRDF() throws RDFHandlerException {
        }
    }
}

