/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio;

import com.bigdata.rdf.rio.IRDFParserOptions;
import java.io.Serializable;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.rio.RDFParser;

public class RDFParserOptions
implements Serializable,
IRDFParserOptions {
    private static final Logger log = Logger.getLogger(RDFParserOptions.class);
    private static final long serialVersionUID = 1L;
    private RDFParser.DatatypeHandling datatypeHandling = RDFParser.DatatypeHandling.IGNORE;
    private boolean preserveBNodeIDs = Boolean.valueOf("false");
    private boolean stopAtFirstError = Boolean.valueOf("false");
    private boolean verifyData = Boolean.valueOf("false");

    @Override
    public synchronized boolean getVerifyData() {
        return this.verifyData;
    }

    @Override
    public synchronized boolean getStopAtFirstError() {
        return this.stopAtFirstError;
    }

    @Override
    public synchronized boolean getPreserveBNodeIDs() {
        return this.preserveBNodeIDs;
    }

    @Override
    public synchronized RDFParser.DatatypeHandling getDatatypeHandling() {
        return this.datatypeHandling;
    }

    public RDFParserOptions() {
    }

    public RDFParserOptions(Properties properties) {
        this.setVerifyData(Boolean.parseBoolean(properties.getProperty(Options.VERIFY_DATA, "false")));
        if (log.isInfoEnabled()) {
            log.info(Options.VERIFY_DATA + "=" + this.getVerifyData());
        }
        this.setStopAtFirstError(Boolean.parseBoolean(properties.getProperty(Options.STOP_AT_FIRST_ERROR, "false")));
        if (log.isInfoEnabled()) {
            log.info(Options.STOP_AT_FIRST_ERROR + "=" + this.getStopAtFirstError());
        }
        this.setDatatypeHandling(RDFParser.DatatypeHandling.valueOf(properties.getProperty(Options.DATATYPE_HANDLING, Options.DEFAULT_DATATYPE_HANDLING)));
        if (log.isInfoEnabled()) {
            log.info(Options.DATATYPE_HANDLING + "=" + (Object)((Object)this.getDatatypeHandling()));
        }
        this.setPreserveBNodeIDs(Boolean.parseBoolean(properties.getProperty(Options.PRESERVE_BNODE_IDS, "false")));
    }

    public RDFParserOptions(boolean verifyData, boolean preserveBlankNodeIDs, boolean stopAtFirstError, RDFParser.DatatypeHandling datatypeHandling) {
        if (datatypeHandling == null) {
            throw new IllegalArgumentException();
        }
        this.verifyData = verifyData;
        this.preserveBNodeIDs = preserveBlankNodeIDs;
        this.stopAtFirstError = stopAtFirstError;
        this.datatypeHandling = datatypeHandling;
    }

    public synchronized String toString() {
        return super.toString() + "{verifyData=" + this.verifyData + ",preserveBNodeIDs=" + this.preserveBNodeIDs + ",stopAtFirstError=" + this.stopAtFirstError + ",datatypeHandling=" + (Object)((Object)this.datatypeHandling) + "}";
    }

    @Override
    public synchronized void setDatatypeHandling(RDFParser.DatatypeHandling datatypeHandling) {
        if (datatypeHandling == null) {
            throw new IllegalArgumentException();
        }
        this.datatypeHandling = datatypeHandling;
    }

    @Override
    public synchronized void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.preserveBNodeIDs = preserveBNodeIDs;
    }

    @Override
    public synchronized void setStopAtFirstError(boolean stopAtFirstError) {
        this.stopAtFirstError = stopAtFirstError;
    }

    @Override
    public synchronized void setVerifyData(boolean verifyData) {
        this.verifyData = verifyData;
    }

    public synchronized void apply(RDFParser p) {
        p.setDatatypeHandling(this.datatypeHandling);
        p.setPreserveBNodeIDs(this.preserveBNodeIDs);
        p.setStopAtFirstError(this.stopAtFirstError);
        p.setVerifyData(this.verifyData);
    }

    public static void apply(IRDFParserOptions opts, RDFParser p) {
        p.setDatatypeHandling(opts.getDatatypeHandling());
        p.setPreserveBNodeIDs(opts.getPreserveBNodeIDs());
        p.setStopAtFirstError(opts.getStopAtFirstError());
        p.setVerifyData(opts.getVerifyData());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IRDFParserOptions)) {
            return false;
        }
        IRDFParserOptions t = (IRDFParserOptions)o;
        if (this.verifyData != t.getVerifyData()) {
            return false;
        }
        if (this.preserveBNodeIDs != t.getPreserveBNodeIDs()) {
            return false;
        }
        if (this.stopAtFirstError != t.getStopAtFirstError()) {
            return false;
        }
        return this.datatypeHandling.equals((Object)this.getDatatypeHandling());
    }

    public static interface Options {
        public static final String VERIFY_DATA = RDFParserOptions.class.getName() + ".verifyData";
        public static final String DEFAULT_VERIFY_DATA = "false";
        public static final String PRESERVE_BNODE_IDS = RDFParserOptions.class.getName() + ".preserveBNodeIDs";
        public static final String DEFAULT_PRESERVE_BNODE_IDS = "false";
        public static final String STOP_AT_FIRST_ERROR = RDFParserOptions.class.getName() + ".stopAtFirstError";
        public static final String DEFAULT_STOP_AT_FIRST_ERROR = "false";
        public static final String DATATYPE_HANDLING = RDFParserOptions.class.getName() + ".datatypeHandling";
        public static final String DEFAULT_DATATYPE_HANDLING = RDFParser.DatatypeHandling.IGNORE.toString();
    }
}

