/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio.json;

import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.rio.json.SPARQLJSONParserBase;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.resultio.QueryResultFormat;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;

public class BigdataSPARQLResultsJSONParser
extends SPARQLJSONParserBase
implements TupleQueryResultParser {
    public static final String SID = "sid";
    public static final String SUBJECT = "subject";
    public static final String PREDICATE = "predicate";
    public static final String OBJECT = "object";
    public static final String CONTEXT = "context";

    public BigdataSPARQLResultsJSONParser() {
    }

    public BigdataSPARQLResultsJSONParser(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public QueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    @Override
    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.JSON;
    }

    @Override
    @Deprecated
    public void setTupleQueryResultHandler(TupleQueryResultHandler handler) {
        this.setQueryResultHandler(handler);
    }

    @Override
    @Deprecated
    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        try {
            this.parseQueryResultInternal(in, false, true);
        }
        catch (TupleQueryResultHandlerException e) {
            throw e;
        }
        catch (QueryResultHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    protected Value parseValue(String bindingStr, JsonParser jp) throws QueryResultParseException, JsonParseException, IOException {
        String lang = null;
        String type = null;
        String datatype = null;
        String value = null;
        LinkedHashMap<String, Value> sid = new LinkedHashMap<String, Value>();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            if (jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                throw new QueryResultParseException("Did not find value attribute under " + bindingStr + " field", jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
            }
            String fieldName = jp.getCurrentName();
            jp.nextToken();
            if ("type".equals(fieldName)) {
                type = jp.getText();
                continue;
            }
            if ("xml:lang".equals(fieldName)) {
                lang = jp.getText();
                continue;
            }
            if ("datatype".equals(fieldName)) {
                datatype = jp.getText();
                continue;
            }
            if ("value".equals(fieldName)) {
                value = jp.getText();
                continue;
            }
            if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
                sid.put(fieldName, this.parseValue(bindingStr, jp));
                continue;
            }
            throw new QueryResultParseException("Unexpected field name: " + fieldName, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
        }
        if (type.equals(SID)) {
            Resource s = (Resource)sid.get(SUBJECT);
            URI p = (URI)sid.get(PREDICATE);
            Value o = (Value)sid.get(OBJECT);
            Resource c = (Resource)sid.get(CONTEXT);
            if (s == null) {
                throw new QueryResultParseException("Missing subject for statement: " + bindingStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
            }
            if (p == null) {
                throw new QueryResultParseException("Missing predicate for statement: " + bindingStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
            }
            if (o == null) {
                throw new QueryResultParseException("Missing object for statement: " + bindingStr, jp.getCurrentLocation().getLineNr(), jp.getCurrentLocation().getColumnNr());
            }
            BigdataValueFactory valueFactory = (BigdataValueFactory)this.valueFactory;
            BigdataStatement stmt = valueFactory.createStatement(s, p, o, c);
            return valueFactory.createBNode(stmt);
        }
        return this.parseValue(type, value, lang, datatype);
    }
}

