/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio.json;

import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.rio.json.SPARQLJSONWriterBase;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openrdf.model.Value;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultWriter;

public class BigdataSPARQLResultsJSONWriter
extends SPARQLJSONWriterBase
implements TupleQueryResultWriter {
    public BigdataSPARQLResultsJSONWriter(Writer writer) {
        super(writer);
    }

    public BigdataSPARQLResultsJSONWriter(OutputStream out) {
        super(out);
    }

    @Override
    public final TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.JSON;
    }

    @Override
    public TupleQueryResultFormat getQueryResultFormat() {
        return this.getTupleQueryResultFormat();
    }

    @Override
    protected void writeValue(Value value) throws IOException, QueryResultHandlerException {
        if (value instanceof BigdataBNode && ((BigdataBNode)value).isStatementIdentifier()) {
            this.writeSid((BigdataBNode)value);
        } else {
            super.writeValue(value);
        }
    }

    protected void writeSid(BigdataBNode sid) throws IOException, QueryResultHandlerException {
        this.jg.writeStartObject();
        this.jg.writeStringField("type", "sid");
        BigdataStatement stmt = sid.getStatement();
        this.jg.writeFieldName("subject");
        this.writeValue(stmt.getSubject());
        this.jg.writeFieldName("predicate");
        this.writeValue(stmt.getPredicate());
        this.jg.writeFieldName("object");
        this.writeValue(stmt.getObject());
        if (stmt.getContext() != null) {
            this.jg.writeFieldName("context");
            this.writeValue(stmt.getContext());
        }
        this.jg.writeEndObject();
    }
}

