/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio.ntriples;

import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.input.BOMInputStream;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.helpers.NTriplesParserSettings;
import org.openrdf.rio.helpers.RDFParserBase;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class BigdataNTriplesParser
extends RDFParserBase {
    private PushbackReader reader;
    private int lineNo;
    private ValueFactory valueFactory;
    private Map<Statement, BigdataBNode> sids = new LinkedHashMap<Statement, BigdataBNode>(){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Statement, BigdataBNode> eldest) {
            return this.size() > 100;
        }
    };
    private final Stack<State> stack = new Stack();
    private static final boolean EXPANDED_LETTERS = true;
    private final StringBuilder buffer = new StringBuilder(100);
    private final StringBuilder languageTagBuffer = new StringBuilder(8);
    private final StringBuilder datatypeUriBuffer = new StringBuilder(40);

    private void push(State state) {
        this.stack.add(state);
    }

    private State pop() {
        return this.stack.pop();
    }

    private State peek() {
        return this.stack.peek();
    }

    public BigdataNTriplesParser() {
        super(BigdataValueFactoryImpl.getInstance(""));
    }

    public BigdataNTriplesParser(BigdataValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public void setValueFactory(ValueFactory valueFactory) {
        super.setValueFactory(valueFactory);
        this.valueFactory = valueFactory;
    }

    protected BigdataValueFactory getValueFactory() {
        return (BigdataValueFactory)this.valueFactory;
    }

    @Override
    public final RDFFormat getRDFFormat() {
        return RDFFormat.NTRIPLES;
    }

    @Override
    public synchronized void parse(InputStream in, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream can not be 'null'");
        }
        try {
            this.parse(new InputStreamReader((InputStream)new BOMInputStream(in, false), "US-ASCII"), baseURI);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void parse(Reader reader, String baseURI) throws IOException, RDFParseException, RDFHandlerException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader can not be 'null'");
        }
        if (baseURI == null) {
            throw new IllegalArgumentException("base URI can not be 'null'");
        }
        this.rdfHandler.startRDF();
        this.reader = new PushbackReader(reader, 1);
        this.lineNo = 1;
        this.reportLocation(this.lineNo, 1);
        this.push(new State());
        try {
            int c = reader.read();
            c = this.skipWhitespace(c);
            while (c != -1) {
                c = c == 35 ? this.skipLine(c) : (c == 13 || c == 10 ? this.skipLine(c) : this.parseTriple(c, false));
                c = this.skipWhitespace(c);
            }
        }
        finally {
            this.clear();
        }
        this.rdfHandler.endRDF();
    }

    protected int skipWhitespace(int c) throws IOException {
        while (c == 32 || c == 9) {
            c = this.reader.read();
        }
        return c;
    }

    protected int assertLineTerminates(int c) throws IOException, RDFParseException {
        c = this.reader.read();
        if ((c = this.skipWhitespace(c)) != -1 && c != 13 && c != 10) {
            this.reportFatalError("Content after '.' is not allowed");
        }
        return c;
    }

    protected int skipLine(int c) throws IOException {
        while (c != -1 && c != 13 && c != 10) {
            c = this.reader.read();
        }
        if (c == 10) {
            c = this.reader.read();
            ++this.lineNo;
            this.reportLocation(this.lineNo, 1);
        } else if (c == 13) {
            c = this.reader.read();
            if (c == 10) {
                c = this.reader.read();
            }
            ++this.lineNo;
            this.reportLocation(this.lineNo, 1);
        }
        return c;
    }

    private int parseTriple(int c, boolean embedded) throws IOException, RDFParseException, RDFHandlerException {
        c = this.parseSubject(c);
        c = this.skipWhitespace(c);
        c = this.parsePredicate(c);
        c = this.skipWhitespace(c);
        c = this.parseObject(c);
        if ((c = this.skipWhitespace(c)) == -1) {
            this.throwEOFException();
        } else if (embedded) {
            if (c != 62) {
                this.reportFatalError("Expected '>', found: " + (char)c);
            }
            if ((c = this.reader.read()) != 62) {
                this.reportFatalError("Expected '>', found: " + (char)c);
            }
            c = this.skipWhitespace(this.reader.read());
        } else {
            if (c != 46) {
                this.reportFatalError("Expected '.', found: " + (char)c);
            }
            c = this.skipLine(c);
        }
        State state = this.peek();
        if (embedded) {
            BigdataStatement st = (BigdataStatement)this.createStatement(state.subject, state.predicate, state.object);
            this.rdfHandler.handleStatement(st);
            state.lastSID = ((BigdataValueFactory)this.valueFactory).createBNode(st);
        } else {
            Statement st = this.createStatement(state.subject, state.predicate, state.object);
            this.rdfHandler.handleStatement(st);
        }
        return c;
    }

    private boolean isStatement(int c) throws RDFParseException, IOException {
        assert (c == 60) : "Supplied char should be a '<', is: " + c;
        c = this.reader.read();
        if (c == -1) {
            this.throwEOFException();
        }
        this.reader.unread(c);
        return c == 60;
    }

    private int parseSubject(int c) throws IOException, RDFParseException, RDFHandlerException {
        State state = this.peek();
        if (c == 60) {
            if (this.isStatement(c)) {
                c = this.reader.read();
                if (c != 60) {
                    this.reportFatalError("Expected '<', found: " + (char)c);
                }
                c = this.reader.read();
                c = this.skipWhitespace(c);
                this.push(new State());
                c = this.parseTriple(c, true);
                state.subject = this.pop().lastSID;
            } else {
                StringBuilder sb = this.getBuffer();
                c = this.parseUriRef(c, sb);
                state.subject = this.createURI(sb.toString());
            }
        } else if (c == 95) {
            StringBuilder sb = this.getBuffer();
            c = this.parseNodeID(c, sb);
            state.subject = this.createBNode(sb.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<' or '_', found: " + (char)c);
        }
        return c;
    }

    private int parsePredicate(int c) throws IOException, RDFParseException {
        if (c == 60) {
            StringBuilder sb = this.getBuffer();
            c = this.parseUriRef(c, sb);
            this.peek().predicate = this.createURI(sb.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<', found: " + (char)c);
        }
        return c;
    }

    private int parseObject(int c) throws IOException, RDFParseException, RDFHandlerException {
        State state = this.peek();
        if (c == 60) {
            if (this.isStatement(c)) {
                c = this.reader.read();
                if (c != 60) {
                    this.reportFatalError("Expected '<', found: " + (char)c);
                }
                c = this.reader.read();
                c = this.skipWhitespace(c);
                this.push(new State());
                c = this.parseTriple(c, true);
                state.object = this.pop().lastSID;
            } else {
                StringBuilder sb = this.getBuffer();
                c = this.parseUriRef(c, sb);
                state.object = this.createURI(sb.toString());
            }
        } else if (c == 95) {
            StringBuilder sb = this.getBuffer();
            c = this.parseNodeID(c, sb);
            state.object = this.createBNode(sb.toString());
        } else if (c == 34) {
            StringBuilder sb = this.getBuffer();
            StringBuilder lang = this.getLanguageTagBuffer();
            StringBuilder datatype = this.getDatatypeUriBuffer();
            c = this.parseLiteral(c, sb, lang, datatype);
            state.object = this.createLiteral(sb.toString(), lang.toString(), datatype.toString());
        } else if (c == -1) {
            this.throwEOFException();
        } else {
            this.reportFatalError("Expected '<', '_' or '\"', found: " + (char)c);
        }
        return c;
    }

    private int parseUriRef(int c, StringBuilder uriRef) throws IOException, RDFParseException {
        assert (c == 60) : "Supplied char should be a '<', is: " + c;
        c = this.reader.read();
        while (c != 62) {
            if (c == -1) {
                this.throwEOFException();
            }
            uriRef.append((char)c);
            c = this.reader.read();
        }
        c = this.reader.read();
        return c;
    }

    private int parseNodeID(int c, StringBuilder name) throws IOException, RDFParseException {
        assert (c == 95) : "Supplied char should be a '_', is: " + c;
        c = this.reader.read();
        if (c == -1) {
            this.throwEOFException();
        } else if (c != 58) {
            this.reportError("Expected ':', found: " + (char)c, NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        }
        c = this.reader.read();
        if (c == -1) {
            this.throwEOFException();
        }
        name.append((char)c);
        c = this.reader.read();
        while (c != -1 && BigdataNTriplesParser.isLetterOrNumber(c)) {
            name.append((char)c);
            c = this.reader.read();
        }
        return c;
    }

    public static boolean isLetterOrNumber(int c) {
        return BigdataNTriplesParser.isLetter(c) || NTriplesUtil.isNumber(c);
    }

    private static boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 95 || c == 45;
    }

    private int parseLiteral(int c, StringBuilder value, StringBuilder lang, StringBuilder datatype) throws IOException, RDFParseException {
        assert (c == 34) : "Supplied char should be a '\"', is: " + c;
        c = this.reader.read();
        while (c != 34) {
            if (c == -1) {
                this.throwEOFException();
            }
            value.append((char)c);
            if (c == 92) {
                c = this.reader.read();
                if (c == -1) {
                    this.throwEOFException();
                }
                value.append((char)c);
            }
            c = this.reader.read();
        }
        c = this.reader.read();
        if (c == 64) {
            c = this.reader.read();
            while (c != -1 && c != 46 && c != 94 && c != 32 && c != 9 && c != 62) {
                lang.append((char)c);
                c = this.reader.read();
            }
        } else if (c == 94) {
            c = this.reader.read();
            if (c == -1) {
                this.throwEOFException();
            } else if (c != 94) {
                this.reportError("Expected '^', found: " + (char)c, NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            }
            c = this.reader.read();
            if (c == -1) {
                this.throwEOFException();
            } else if (c != 60) {
                this.reportError("Expected '<', found: " + (char)c, NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
            }
            c = this.parseUriRef(c, datatype);
        }
        return c;
    }

    @Override
    protected URI createURI(String uri) throws RDFParseException {
        try {
            uri = NTriplesUtil.unescapeString(uri);
        }
        catch (IllegalArgumentException e) {
            this.reportError(e.getMessage(), NTriplesParserSettings.FAIL_ON_NTRIPLES_INVALID_LINES);
        }
        return super.createURI(uri);
    }

    protected Literal createLiteral(String label, String lang, String datatype) throws RDFParseException {
        try {
            label = NTriplesUtil.unescapeString(label);
        }
        catch (IllegalArgumentException e) {
            this.reportFatalError(e.getMessage());
        }
        if (lang.length() == 0) {
            lang = null;
        }
        if (datatype.length() == 0) {
            datatype = null;
        }
        URI dtURI = null;
        if (datatype != null) {
            dtURI = this.createURI(datatype);
        }
        return super.createLiteral(label, lang, dtURI);
    }

    @Override
    protected void reportWarning(String msg) {
        this.reportWarning(msg, this.lineNo, -1);
    }

    @Override
    protected void reportError(String msg, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(msg, this.lineNo, -1, setting);
    }

    protected void reportError(Exception e, RioSetting<Boolean> setting) throws RDFParseException {
        this.reportError(e, this.lineNo, -1, setting);
    }

    @Override
    protected void reportFatalError(String msg) throws RDFParseException {
        this.reportFatalError(msg, this.lineNo, -1);
    }

    @Override
    protected void reportFatalError(Exception e) throws RDFParseException {
        this.reportFatalError(e, this.lineNo, -1);
    }

    private void throwEOFException() throws RDFParseException {
        throw new RDFParseException("Unexpected end of file");
    }

    private StringBuilder getBuffer() {
        this.buffer.setLength(0);
        return this.buffer;
    }

    private StringBuilder getLanguageTagBuffer() {
        this.languageTagBuffer.setLength(0);
        return this.languageTagBuffer;
    }

    private StringBuilder getDatatypeUriBuffer() {
        this.datatypeUriBuffer.setLength(0);
        return this.datatypeUriBuffer;
    }

    private static class State {
        private Resource subject;
        private URI predicate;
        private Value object;
        private BigdataBNode lastSID;

        private State() {
        }
    }
}

