/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rio.turtle;

import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataStatement;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.openrdf.model.BNode;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.turtle.TurtleWriter;

public class BigdataTurtleWriter
extends TurtleWriter
implements RDFWriter {
    public BigdataTurtleWriter(OutputStream out) {
        super(out);
    }

    public BigdataTurtleWriter(Writer writer) {
        super(writer);
    }

    @Override
    protected void writeBNode(BNode bNode) throws IOException {
        if (bNode instanceof BigdataBNode && ((BigdataBNode)bNode).isStatementIdentifier()) {
            this.writeSid((BigdataBNode)bNode);
        } else {
            super.writeBNode(bNode);
        }
    }

    protected void writeSid(BigdataBNode sid) throws IOException {
        BigdataStatement stmt = sid.getStatement();
        this.writer.write("<< ");
        this.writeValue(stmt.getSubject());
        this.writer.write(", ");
        this.writeValue(stmt.getPredicate());
        this.writer.write(", ");
        this.writeValue(stmt.getObject());
        if (stmt.getContext() != null) {
            this.writer.write(", ");
            this.writeValue(stmt.getContext());
        }
        this.writer.write(" >>");
    }
}

