/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.Var;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.spo.SPOPredicate;
import com.bigdata.rdf.spo.SPORelation;
import com.bigdata.relation.IRelation;
import com.bigdata.relation.RelationFusedView;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.QueryOptions;
import com.bigdata.relation.rule.Rule;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IRuleTaskFactory;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.IStepTask;
import com.bigdata.relation.rule.eval.RuleStats;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public abstract class AbstractRuleFastClosure_3_5_6_7_9
extends Rule {
    public AbstractRuleFastClosure_3_5_6_7_9(String name, String relationName, IConstant<IV> rdfsSubPropertyOf, IConstant<IV> propertyId, IRuleTaskFactory taskFactory) {
        super(name, new SPOPredicate(relationName, (IVariableOrConstant<IV>)AbstractRuleFastClosure_3_5_6_7_9.var("x"), propertyId, (IVariableOrConstant<IV>)AbstractRuleFastClosure_3_5_6_7_9.var("y")), new SPOPredicate[]{new SPOPredicate(relationName, (IVariableOrConstant<IV>)AbstractRuleFastClosure_3_5_6_7_9.var("x"), (IVariableOrConstant<IV>)AbstractRuleFastClosure_3_5_6_7_9.var("{P}"), (IVariableOrConstant<IV>)AbstractRuleFastClosure_3_5_6_7_9.var("y"))}, QueryOptions.NONE, null, null, taskFactory);
        if (rdfsSubPropertyOf == null) {
            throw new IllegalArgumentException();
        }
        if (propertyId == null) {
            throw new IllegalArgumentException();
        }
    }

    public static class SubPropertiesOfClosureTask
    implements Callable<Set<IV>> {
        protected static final Logger log = Logger.getLogger(SubPropertyClosureTask.class);
        private final IRelation<ISPO> view;
        private final IConstant<IV> rdfsSubPropertyOf;
        private final IConstant<IV> p;

        public SubPropertiesOfClosureTask(IRelation<ISPO> view, IConstant<IV> rdfsSubPropertyOf, IConstant<IV> p) {
            if (view == null) {
                throw new IllegalArgumentException();
            }
            if (rdfsSubPropertyOf == null) {
                throw new IllegalArgumentException();
            }
            if (p == null) {
                throw new IllegalArgumentException();
            }
            this.view = view;
            this.rdfsSubPropertyOf = rdfsSubPropertyOf;
            this.p = p;
        }

        @Override
        public Set<IV> call() {
            return this.getSubPropertiesOf(this.p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<IV> getSubPropertiesOf(IConstant<IV> p) {
            SPOPredicate pred = new SPOPredicate("view", (IVariableOrConstant<IV>)Var.var("x"), this.rdfsSubPropertyOf, p);
            IAccessPath<ISPO> accessPath = this.view.getAccessPath(pred);
            HashSet<IV> tmp = new HashSet<IV>();
            try (IChunkedOrderedIterator<ISPO> itr = accessPath.iterator();){
                while (itr.hasNext()) {
                    ISPO[] stmts;
                    for (ISPO spo : stmts = (ISPO[])itr.nextChunk()) {
                        boolean added = tmp.add(spo.s());
                        if (!DEBUG) continue;
                        log.debug(spo.toString() + ", added subject=" + added);
                    }
                }
            }
            return tmp;
        }
    }

    public static class SubPropertyClosureTask
    implements Callable<Set<IV>> {
        protected static final Logger log = Logger.getLogger(SubPropertyClosureTask.class);
        private final IRelation<ISPO> view;
        private final IConstant<IV> rdfsSubPropertyOf;

        public SubPropertyClosureTask(IRelation<ISPO> view, IConstant<IV> rdfsSubPropertyOf) {
            if (view == null) {
                throw new IllegalArgumentException();
            }
            if (rdfsSubPropertyOf == null) {
                throw new IllegalArgumentException();
            }
            this.view = view;
            this.rdfsSubPropertyOf = rdfsSubPropertyOf;
        }

        @Override
        public Set<IV> call() {
            return this.getSubProperties();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<IV> getSubProperties() {
            int nbefore;
            HashSet<IV> P = new HashSet<IV>();
            P.add((IV)this.rdfsSubPropertyOf.get());
            int nafter = 0;
            int nrounds = 0;
            HashSet<IV> tmp = new HashSet<IV>();
            do {
                nbefore = P.size();
                tmp.clear();
                for (IV p : P) {
                    SPOPredicate pred = new SPOPredicate("view", (IVariableOrConstant<IV>)Var.var("x"), new Constant<IV>(p), (IVariableOrConstant<IV>)Var.var("y"));
                    IAccessPath<ISPO> accessPath = this.view.getAccessPath(pred);
                    try (IChunkedOrderedIterator<ISPO> itr = accessPath.iterator();){
                        while (itr.hasNext()) {
                            ISPO[] stmts;
                            for (ISPO stmt : stmts = (ISPO[])itr.nextChunk()) {
                                if (!P.contains(stmt.o())) continue;
                                tmp.add(stmt.s());
                            }
                        }
                    }
                }
                P.addAll(tmp);
                nafter = P.size();
                ++nrounds;
            } while (nafter > nbefore);
            return P;
        }
    }

    protected static abstract class FastClosureRuleTask
    implements IStepTask {
        private final String database;
        private final String focusStore;
        private final IRule rule;
        private final IJoinNexus joinNexus;
        private final IBuffer<ISolution[]> buffer;
        protected final IConstant<IV> rdfsSubPropertyOf;
        protected final IConstant<IV> propertyId;
        private transient IRelation<ISPO> view = null;

        public FastClosureRuleTask(String database, String focusStore, IRule rule, IJoinNexus joinNexus, IBuffer<ISolution[]> buffer, IConstant<IV> rdfsSubPropertyOf, IConstant<IV> propertyId) {
            if (database == null) {
                throw new IllegalArgumentException();
            }
            if (rule == null) {
                throw new IllegalArgumentException();
            }
            if (joinNexus == null) {
                throw new IllegalArgumentException();
            }
            if (buffer == null) {
                throw new IllegalArgumentException();
            }
            if (rdfsSubPropertyOf == null) {
                throw new IllegalArgumentException();
            }
            if (propertyId == null) {
                throw new IllegalArgumentException();
            }
            this.database = database;
            this.focusStore = focusStore;
            this.rule = rule;
            this.joinNexus = joinNexus;
            this.buffer = buffer;
            this.rdfsSubPropertyOf = rdfsSubPropertyOf;
            this.propertyId = propertyId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RuleStats call() {
            IV[] a;
            if (INFO) {
                log.info("running: rule=" + this.rule.getName() + ", propertyId=" + this.propertyId);
            }
            RuleStats stats = this.joinNexus.getRuleStatisticsFactory().newInstance(this.rule);
            long begin = System.currentTimeMillis();
            SPORelation relation = (SPORelation)this.joinNexus.getTailRelationView(this.rule.getTail(0));
            for (IV p : a = this.getSortedArray(this.getSet())) {
                if (IVUtility.equals(p, (IV)this.propertyId.get())) continue;
                stats.subqueryCount[0] = stats.subqueryCount[0] + 1;
                IAccessPath<ISPO> accessPath = relation.getAccessPath(null, p, null);
                IBindingSet bindingSet = this.joinNexus.newBindingSet(this.rule);
                try (IChunkedOrderedIterator<ISPO> itr2 = accessPath.iterator();){
                    while (itr2.hasNext()) {
                        Object[] chunk = itr2.nextChunk(SPOKeyOrder.POS);
                        stats.chunkCount[0] = stats.chunkCount[0] + 1L;
                        stats.elementCount[0] = stats.elementCount[0] + (long)chunk.length;
                        if (DEBUG) {
                            log.debug("stmts1: chunk=" + chunk.length + "\n" + Arrays.toString(chunk));
                        }
                        IBuffer<ISolution> tmp = this.joinNexus.newUnsynchronizedBuffer(this.buffer, chunk.length);
                        for (Object spo : chunk) {
                            assert (spo.p().equals(p)) : "spo.p=" + spo.p() + ", p=" + p;
                            if (!this.joinNexus.bind(this.rule, 0, spo, bindingSet)) continue;
                            tmp.add(this.joinNexus.newSolution(this.rule, bindingSet));
                            stats.solutionCount.incrementAndGet();
                        }
                        tmp.flush();
                    }
                }
            }
            stats.elapsed += System.currentTimeMillis() - begin;
            return stats;
        }

        protected IV[] getSortedArray(Set<IV> ivs) {
            int n = ivs.size();
            Object[] a = new IV[n];
            int i = 0;
            for (IV iv : ivs) {
                a[i++] = iv;
            }
            Arrays.sort(a);
            return a;
        }

        protected synchronized IRelation<ISPO> getView() {
            if (this.view == null) {
                IResourceLocator resourceLocator = this.joinNexus.getIndexManager().getResourceLocator();
                if (this.focusStore == null) {
                    long timestamp = this.joinNexus.getReadTimestamp();
                    return (IRelation)resourceLocator.locate(this.database, timestamp);
                }
                long timestamp0 = this.joinNexus.getReadTimestamp();
                long timestamp1 = this.joinNexus.getReadTimestamp();
                return new RelationFusedView((IRelation)resourceLocator.locate(this.database, timestamp0), (IRelation)resourceLocator.locate(this.focusStore, timestamp1)).init();
            }
            return this.view;
        }

        protected abstract Set<IV> getSet();

        protected Set<IV> getSubProperties() {
            return new SubPropertyClosureTask(this.getView(), this.rdfsSubPropertyOf).call();
        }

        protected Set<IV> getSubPropertiesOf(IConstant<IV> propertyId) {
            return new SubPropertiesOfClosureTask(this.getView(), this.rdfsSubPropertyOf, propertyId).call();
        }
    }
}

