/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.IPredicate;
import com.bigdata.btree.IIndex;
import com.bigdata.rdf.axioms.Axioms;
import com.bigdata.rdf.inf.BackchainTypeResourceIterator;
import com.bigdata.rdf.inf.OwlSameAsPropertiesExpandingIterator;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.rules.InferenceEngine;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.accesspath.IElementFilter;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import org.apache.log4j.Logger;
import org.openrdf.model.vocabulary.OWL;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class BackchainAccessPath
implements IAccessPath<ISPO> {
    protected static final transient Logger log = Logger.getLogger(BackchainAccessPath.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    private final AbstractTripleStore database;
    private final IAccessPath<ISPO> accessPath;
    private Boolean isOwlSameAsUsed;

    public BackchainAccessPath(AbstractTripleStore database, IAccessPath<ISPO> accessPath) {
        this(database, accessPath, null);
    }

    public BackchainAccessPath(AbstractTripleStore database, IAccessPath<ISPO> accessPath, Boolean isOwlSameAsUsed) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        if (accessPath == null) {
            throw new IllegalArgumentException();
        }
        this.database = database;
        this.accessPath = accessPath;
        this.isOwlSameAsUsed = isOwlSameAsUsed;
    }

    public final IAccessPath<ISPO> getSource() {
        return this.accessPath;
    }

    @Override
    public final IIndex getIndex() {
        return this.accessPath.getIndex();
    }

    @Override
    public final IKeyOrder<ISPO> getKeyOrder() {
        return this.accessPath.getKeyOrder();
    }

    @Override
    public final IPredicate<ISPO> getPredicate() {
        return this.accessPath.getPredicate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        try (IChunkedOrderedIterator<ISPO> itr = this.iterator(0L, 1L, 1);){
            boolean bl = !itr.hasNext();
            return bl;
        }
    }

    @Override
    public IChunkedOrderedIterator<ISPO> iterator() {
        return this.iterator(0L, 0L, 0);
    }

    @Override
    public IChunkedOrderedIterator<ISPO> iterator(long offset, long limit, int capacity) {
        IChunkedOrderedIterator<Object> itr;
        OwlSameAsPropertiesExpandingIterator owlSameAsItr;
        if (offset > 0L) {
            throw new UnsupportedOperationException();
        }
        if (limit == Long.MAX_VALUE) {
            limit = 0L;
        }
        if (limit > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        if (INFO) {
            log.info(this.accessPath.getPredicate().toString());
        }
        IPredicate<ISPO> predicate = this.accessPath.getPredicate();
        InferenceEngine inf = this.database.getInferenceEngine();
        Vocabulary vocab = this.database.getVocabulary();
        Axioms axioms = this.database.getAxioms();
        if (!axioms.isOwlSameAs()) {
            owlSameAsItr = null;
        } else if (inf.forwardChainOwlSameAsClosure && !inf.forwardChainOwlSameAsProperties) {
            if (this.isOwlSameAsUsed != null && !this.isOwlSameAsUsed.booleanValue()) {
                owlSameAsItr = null;
            } else {
                IV owlSameAs = vocab.get(OWL.SAMEAS);
                if (this.isOwlSameAsUsed == null) {
                    this.isOwlSameAsUsed = this.database.getAccessPath(null, owlSameAs, null).isEmpty();
                }
                if (this.isOwlSameAsUsed.booleanValue()) {
                    owlSameAsItr = null;
                } else {
                    SPO spo = new SPO(predicate);
                    owlSameAsItr = new OwlSameAsPropertiesExpandingIterator(spo.s, spo.p, spo.o, this.database, owlSameAs, this.accessPath.getKeyOrder());
                }
            }
        } else {
            owlSameAsItr = null;
        }
        if (predicate.getIndexLocalFilter() != null) {
            throw new UnsupportedOperationException("indexLocalFilter in expander: " + this);
        }
        if (predicate.getAccessPathFilter() != null) {
            throw new UnsupportedOperationException("accessPathFilter in expander: " + this);
        }
        IElementFilter filter = null;
        IChunkedOrderedIterator<Object> iChunkedOrderedIterator = owlSameAsItr == null ? this.accessPath.iterator(offset, limit, capacity) : (itr = new ChunkedWrappedIterator(owlSameAsItr, capacity == 0 ? inf.database.getChunkCapacity() : capacity, null, filter));
        if (axioms.isRdfSchema() && !inf.forwardChainRdfTypeRdfsResource) {
            IV rdfType = vocab.get(RDF.TYPE);
            IV rdfsResource = vocab.get(RDFS.RESOURCE);
            itr = BackchainTypeResourceIterator.newInstance(itr, this.accessPath, this.database, rdfType, rdfsResource);
        }
        return itr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long rangeCount(boolean exact) {
        if (!exact) {
            return this.accessPath.rangeCount(exact);
        }
        log.warn("Will materialize statements and generate inferences");
        long n = 0L;
        try (IChunkedOrderedIterator<ISPO> itr = this.iterator();){
            while (itr.hasNext()) {
                itr.next();
                ++n;
            }
        }
        return n;
    }

    @Override
    public long removeAll() {
        return this.accessPath.removeAll();
    }

    public String toString() {
        return super.toString() + "{isOwlSameAsUsed=" + this.isOwlSameAsUsed + ", source=" + this.accessPath + "}";
    }
}

