/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.bop.joinGraph.fast.DefaultEvaluationPlanFactory2;
import com.bigdata.rdf.axioms.Axioms;
import com.bigdata.rdf.inf.ClosureStats;
import com.bigdata.rdf.rules.BaseClosure;
import com.bigdata.rdf.rules.DoNotAddFilter;
import com.bigdata.rdf.rules.MappedProgram;
import com.bigdata.rdf.rules.RuleContextEnum;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.rule.eval.ActionEnum;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.IJoinNexusFactory;
import java.util.Properties;
import org.apache.log4j.Logger;

public class InferenceEngine {
    protected static final Logger log = Logger.getLogger(InferenceEngine.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    public final AbstractTripleStore database;
    public final DoNotAddFilter doNotAddFilter;
    private BaseClosure baseClosure = null;
    protected final boolean forwardChainRdfTypeRdfsResource;
    protected final boolean forwardChainOwlSameAsClosure;
    protected final boolean forwardChainOwlSameAsProperties;
    protected final boolean forwardChainOwlEquivalentProperty;
    protected final boolean forwardChainOwlEquivalentClass;
    protected final boolean forwardChainOwlInverseOf;
    protected final boolean forwardChainOwlTransitiveProperty;
    protected final boolean forwardChainOwlHasValue;
    protected final boolean forwardChainOwlSymmetricProperty;
    protected final boolean enableOwlFunctionalAndInverseFunctionalProperty;

    public InferenceEngine(AbstractTripleStore database) {
        Axioms axioms;
        boolean rdfsOnly;
        if (database == null) {
            throw new IllegalArgumentException();
        }
        this.database = database;
        Properties properties = database.getProperties();
        this.forwardChainRdfTypeRdfsResource = Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_RDF_TYPE_RDFS_RESOURCE, "false"));
        if (INFO) {
            log.info(Options.FORWARD_CHAIN_RDF_TYPE_RDFS_RESOURCE + "=" + this.forwardChainRdfTypeRdfsResource);
        }
        boolean bl = rdfsOnly = (axioms = database.getAxioms()).isRdfSchema() && !axioms.isOwlSameAs();
        if (rdfsOnly) {
            this.forwardChainOwlSameAsClosure = false;
            this.forwardChainOwlSameAsProperties = false;
            this.forwardChainOwlEquivalentProperty = false;
            this.forwardChainOwlEquivalentClass = false;
            this.forwardChainOwlInverseOf = false;
            this.forwardChainOwlTransitiveProperty = false;
            this.forwardChainOwlHasValue = false;
            this.forwardChainOwlSymmetricProperty = false;
            this.enableOwlFunctionalAndInverseFunctionalProperty = false;
        } else {
            this.forwardChainOwlSameAsClosure = Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_OWL_SAMEAS_CLOSURE, "true"));
            if (INFO) {
                log.info(Options.FORWARD_CHAIN_OWL_SAMEAS_CLOSURE + "=" + this.forwardChainOwlSameAsClosure);
            }
            this.forwardChainOwlSameAsProperties = this.forwardChainOwlSameAsClosure ? Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_OWL_SAMEAS_PROPERTIES, "true")) : false;
            if (INFO) {
                log.info(Options.FORWARD_CHAIN_OWL_SAMEAS_CLOSURE + "=" + this.forwardChainOwlSameAsClosure);
            }
            this.forwardChainOwlEquivalentProperty = Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_OWL_EQUIVALENT_PROPERTY, "true"));
            if (INFO) {
                log.info(Options.FORWARD_CHAIN_OWL_EQUIVALENT_PROPERTY + "=" + this.forwardChainOwlEquivalentProperty);
            }
            this.forwardChainOwlEquivalentClass = Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_OWL_EQUIVALENT_CLASS, "true"));
            if (INFO) {
                log.info(Options.FORWARD_CHAIN_OWL_EQUIVALENT_CLASS + "=" + this.forwardChainOwlEquivalentClass);
            }
            this.forwardChainOwlInverseOf = Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_OWL_INVERSE_OF, "true"));
            if (INFO) {
                log.info(Options.FORWARD_CHAIN_OWL_INVERSE_OF + "=" + this.forwardChainOwlInverseOf);
            }
            this.forwardChainOwlTransitiveProperty = Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_OWL_TRANSITIVE_PROPERTY, "true"));
            if (INFO) {
                log.info(Options.FORWARD_CHAIN_OWL_TRANSITIVE_PROPERTY + "=" + this.forwardChainOwlTransitiveProperty);
            }
            this.forwardChainOwlHasValue = Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_OWL_HAS_VALUE, "true"));
            if (INFO) {
                log.info(Options.FORWARD_CHAIN_OWL_HAS_VALUE + "=" + this.forwardChainOwlHasValue);
            }
            this.forwardChainOwlSymmetricProperty = Boolean.parseBoolean(properties.getProperty(Options.FORWARD_CHAIN_OWL_SYMMETRIC_PROPERTY, "true"));
            if (INFO) {
                log.info(Options.FORWARD_CHAIN_OWL_SYMMETRIC_PROPERTY + "=" + this.forwardChainOwlSymmetricProperty);
            }
            this.enableOwlFunctionalAndInverseFunctionalProperty = Boolean.parseBoolean(properties.getProperty(Options.ENABLE_OWL_FUNCTIONAL_AND_INVERSE_FUNCTIONAL_PROPERTY, "true"));
            if (INFO) {
                log.info(Options.ENABLE_OWL_FUNCTIONAL_AND_INVERSE_FUNCTIONAL_PROPERTY + "=" + this.enableOwlFunctionalAndInverseFunctionalProperty);
            }
        }
        this.doNotAddFilter = new DoNotAddFilter(database.getVocabulary(), database.getAxioms(), this.forwardChainRdfTypeRdfsResource);
    }

    public ClosureStats computeClosure(AbstractTripleStore focusStore) {
        return this.computeClosure(focusStore, this.database.isJustify());
    }

    public synchronized ClosureStats computeClosure(AbstractTripleStore focusStore, boolean justify) {
        if (this.baseClosure == null) {
            this.baseClosure = this.database.getClosureInstance();
        }
        MappedProgram program = this.baseClosure.getProgram(this.database.getSPORelation().getNamespace(), focusStore == null ? null : focusStore.getSPORelation().getNamespace());
        if (INFO) {
            log.info("\n\nforwardClosure=" + this.baseClosure.getClass().getName() + ", program=" + program);
        }
        try {
            long begin = System.currentTimeMillis();
            int solutionFlags = 1 | (justify ? 6 : 0);
            RuleContextEnum ruleContext = focusStore == null ? RuleContextEnum.DatabaseAtOnceClosure : RuleContextEnum.TruthMaintenance;
            IJoinNexusFactory joinNexusFactory = this.database.newJoinNexusFactory(ruleContext, ActionEnum.Insert, solutionFlags, this.doNotAddFilter, justify, false, DefaultEvaluationPlanFactory2.INSTANCE);
            IJoinNexus joinNexus = joinNexusFactory.newInstance(this.database.getIndexManager());
            long mutationCount = joinNexus.runMutation(program);
            long elapsed = System.currentTimeMillis() - begin;
            return new ClosureStats(mutationCount, elapsed);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static interface Options {
        public static final String FORWARD_CHAIN_RDF_TYPE_RDFS_RESOURCE = InferenceEngine.class.getName() + ".forwardChainRdfTypeRdfsResource";
        public static final String DEFAULT_FORWARD_RDF_TYPE_RDFS_RESOURCE = "false";
        public static final String FORWARD_CHAIN_OWL_SAMEAS_CLOSURE = InferenceEngine.class.getName() + ".forwardChainOwlSameAsClosure";
        public static final String DEFAULT_FORWARD_CHAIN_OWL_SAMEAS_CLOSURE = "true";
        public static final String FORWARD_CHAIN_OWL_SAMEAS_PROPERTIES = InferenceEngine.class.getName() + ".forwardChainOwlSameAsProperties";
        public static final String DEFAULT_FORWARD_CHAIN_OWL_SAMEAS_PROPERTIES = "true";
        public static final String FORWARD_CHAIN_OWL_EQUIVALENT_PROPERTY = InferenceEngine.class.getName() + ".forwardChainOwlEquivalentProperty";
        public static final String DEFAULT_FORWARD_CHAIN_OWL_EQUIVALENT_PROPERTY = "true";
        public static final String FORWARD_CHAIN_OWL_EQUIVALENT_CLASS = InferenceEngine.class.getName() + ".forwardChainOwlEquivalentClass";
        public static final String DEFAULT_FORWARD_CHAIN_OWL_EQUIVALENT_CLASS = "true";
        public static final String FORWARD_CHAIN_OWL_INVERSE_OF = InferenceEngine.class.getName() + ".forwardChainOwlInverseOf";
        public static final String DEFAULT_FORWARD_CHAIN_OWL_INVERSE_OF = "true";
        public static final String FORWARD_CHAIN_OWL_TRANSITIVE_PROPERTY = InferenceEngine.class.getName() + ".forwardChainOwlTransitiveProperty";
        public static final String DEFAULT_FORWARD_CHAIN_OWL_TRANSITIVE_PROPERTY = "true";
        public static final String FORWARD_CHAIN_OWL_HAS_VALUE = InferenceEngine.class.getName() + ".forwardChainOwlHasValue";
        public static final String DEFAULT_FORWARD_CHAIN_OWL_HAS_VALUE = "true";
        public static final String FORWARD_CHAIN_OWL_SYMMETRIC_PROPERTY = InferenceEngine.class.getName() + ".forwardChainOwlSymmetricProperty";
        public static final String DEFAULT_FORWARD_CHAIN_OWL_SYMMETRIC_PROPERTY = "true";
        public static final String ENABLE_OWL_FUNCTIONAL_AND_INVERSE_FUNCTIONAL_PROPERTY = InferenceEngine.class.getName() + ".enableOwlFunctionalAndInverseFunctionalProperty";
        public static final String DEFAULT_ENABLE_OWL_FUNCTIONAL_AND_INVERSE_FUNCTIONAL_PROPERTY = "true";
    }
}

