/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.impl.BindingImpl;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.impl.MapBindingSet;

public class BigdataValueReplacer {
    private static final Logger log = Logger.getLogger(BigdataValueReplacer.class);
    private final AbstractTripleStore database;

    public BigdataValueReplacer(AbstractTripleStore database) {
        if (database == null) {
            throw new IllegalArgumentException();
        }
        this.database = database;
    }

    public Object[] replaceValues(Dataset dataset, BindingSet[] bindingSets) {
        DatasetImpl dataset2;
        BindingSet[] bindingSets2;
        if (dataset == null && bindingSets == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<Value, BigdataValue> values = new LinkedHashMap<Value, BigdataValue>();
        BigdataValueFactory valueFactory = this.database.getValueFactory();
        if (dataset != null) {
            for (URI uri : dataset.getDefaultGraphs()) {
                if (uri == null) continue;
                values.put(uri, valueFactory.asValue(uri));
            }
            for (URI uri : dataset.getNamedGraphs()) {
                if (uri == null) continue;
                values.put(uri, valueFactory.asValue(uri));
            }
        }
        if (bindingSets != null && bindingSets.length > 0) {
            for (BindingSet bindings : bindingSets) {
                for (Binding binding : bindings) {
                    Value val = binding.getValue();
                    values.put(val, valueFactory.asValue(val));
                }
            }
        }
        BigdataValue[] terms = values.values().toArray(new BigdataValue[0]);
        this.database.getLexiconRelation().addTerms(terms, terms.length, true);
        for (BigdataValue term : terms) {
            IV iv = term.getIV();
            if (iv == null) {
                if (log.isInfoEnabled()) {
                    log.info("Not in knowledge base: " + term);
                }
                TermId<?> dummy = TermId.mockIV(VTE.valueOf(term));
                term.setIV(dummy);
                dummy.setValue(term);
                continue;
            }
            iv.setValue(term);
        }
        if (bindingSets == null) {
            bindingSets2 = null;
        } else {
            bindingSets2 = new BindingSet[bindingSets.length];
            for (int i = 0; i < bindingSets.length; ++i) {
                MapBindingSet bindings2 = new MapBindingSet();
                bindingSets2[i] = bindings2;
                for (BindingImpl binding : bindingSets[i]) {
                    Value val = binding.getValue();
                    BigdataValue val2 = (BigdataValue)values.get(val);
                    assert (val2 != null) : "value not found: " + binding.getValue();
                    if (log.isDebugEnabled()) {
                        log.debug("value: " + val + " : " + val2 + " (" + val2.getIV() + ")");
                    }
                    bindings2.addBinding(binding.getName(), val2);
                }
            }
        }
        if (dataset == null) {
            dataset2 = null;
        } else {
            dataset2 = new DatasetImpl();
            for (URI uri : dataset.getDefaultGraphs()) {
                dataset2.addDefaultGraph((URI)values.get(uri));
            }
            for (URI uri : dataset.getNamedGraphs()) {
                dataset2.addNamedGraph((URI)values.get(uri));
            }
        }
        return new Object[]{dataset2, bindingSets2};
    }
}

