/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.rdf.sail.model.RunningQuery;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class QueryCancellationHelper {
    private static final transient Logger log = Logger.getLogger(QueryCancellationHelper.class);

    public static void cancelQuery(UUID queryId, QueryEngine queryEngine) {
        LinkedList<UUID> queryIds = new LinkedList<UUID>();
        queryIds.add(queryId);
        QueryCancellationHelper.cancelQueries(queryIds, queryEngine);
    }

    public static void cancelQueries(Collection<UUID> queryIds, QueryEngine queryEngine) {
        for (UUID queryId : queryIds) {
            if (QueryCancellationHelper.tryCancelQuery(queryEngine, queryId) || QueryCancellationHelper.tryCancelUpdate(queryEngine, queryId, null)) continue;
            queryEngine.addPendingCancel(queryId);
            if (!log.isInfoEnabled()) continue;
            log.info("No such QUERY or UPDATE: " + queryId);
        }
    }

    public static boolean tryCancelQuery(QueryEngine queryEngine, UUID queryId) {
        AbstractRunningQuery q;
        try {
            q = queryEngine.getRunningQuery(queryId);
        }
        catch (RuntimeException ex) {
            return false;
        }
        if (q != null && q.cancel(true)) {
            if (log.isInfoEnabled()) {
                log.info("Cancelled query: " + queryId);
            }
            return true;
        }
        return false;
    }

    public static boolean tryCancelUpdate(QueryEngine queryEngine, RunningQuery query) {
        if (query != null) {
            try {
                AbstractRunningQuery q = queryEngine.getRunningQuery(query.getQueryUuid());
                if (q != null && q.cancel(true)) {
                    return true;
                }
            }
            catch (RuntimeException ex) {
                return false;
            }
        }
        return false;
    }

    public static boolean tryCancelUpdate(QueryEngine queryEngine, UUID queryId, Future<Void> f) {
        try {
            AbstractRunningQuery q = queryEngine.getRunningQuery(queryId);
            if (q != null && q.cancel(true)) {
                return true;
            }
        }
        catch (RuntimeException ex) {
            return false;
        }
        return f != null && f.cancel(true);
    }
}

