/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.changesets.ChangeAction;
import com.bigdata.rdf.changesets.IChangeLog;
import com.bigdata.rdf.changesets.IChangeRecord;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.internal.impl.literal.XSDNumericIV;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPO;
import com.bigdata.rdf.spo.SPOKeyOrder;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.TempTripleStore;
import com.bigdata.relation.accesspath.AbstractArrayBuffer;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.ChunkedResolvingIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;

public class RDRHistory
implements IChangeLog {
    private static final Logger log = Logger.getLogger(RDRHistory.class);
    protected final AbstractTripleStore database;
    protected TempTripleStore tempStore = null;
    protected Buffer buffer = null;
    private IV<?, ?> added = null;
    private IV<?, ?> removed = null;
    private IV<?, ?> nullTime = null;

    public RDRHistory(AbstractTripleStore database) {
        if (!database.isStatementIdentifiers()) {
            throw new IllegalArgumentException("database must be in sids mode");
        }
        this.database = database;
    }

    public void init() {
        try {
            IV<?, ?>[] ivs = this.resolveTerms(new URI[]{Vocab.ADDED, Vocab.REMOVED});
            this.added = ivs[0];
            this.removed = ivs[1];
            this.nullTime = new XSDNumericIV(0L);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected IV<?, ?>[] resolveTerms(URI[] terms) throws Exception {
        BigdataValueFactory vf = this.database.getValueFactory();
        BigdataValue[] values = new BigdataValue[terms.length];
        for (int i = 0; i < terms.length; ++i) {
            values[i] = vf.asValue(terms[i]);
        }
        this.database.addTerms(values);
        IV[] ivs = new IV[terms.length];
        for (int i = 0; i < values.length; ++i) {
            ivs[i] = values[i].getIV();
        }
        return ivs;
    }

    public TempTripleStore newTempTripleStore() {
        Properties properties = this.database.getProperties();
        properties.setProperty(AbstractTripleStore.Options.LEXICON, "false");
        properties.setProperty(AbstractTripleStore.Options.ONE_ACCESS_PATH, "true");
        properties.setProperty(AbstractTripleStore.Options.BLOOM_FILTER, "false");
        properties.setProperty(AbstractTripleStore.Options.RDR_HISTORY_CLASS, "");
        TempTripleStore tempStore = new TempTripleStore(this.database.getIndexManager().getTempStore(), properties, this.database);
        return tempStore;
    }

    @Override
    public void changeEvent(IChangeRecord record) {
        IV p;
        if (log.isTraceEnabled()) {
            log.trace(record);
        }
        if (this.added.equals(p = record.getStatement().p()) || this.removed.equals(p)) {
            return;
        }
        if (!this.accept(record)) {
            return;
        }
        ChangeAction action = record.getChangeAction();
        if (action != ChangeAction.INSERTED && action != ChangeAction.REMOVED) {
            return;
        }
        IV<?, ?> p2 = action == ChangeAction.INSERTED ? this.added : this.removed;
        SidIV sid = new SidIV(record.getStatement());
        SPO spo = new SPO(sid, p2, this.nullTime, StatementEnum.Explicit);
        if (log.isTraceEnabled()) {
            log.trace(spo);
        }
        this.getOrCreateBuffer().add(spo);
    }

    protected boolean accept(IChangeRecord record) {
        return true;
    }

    protected Buffer getOrCreateBuffer() {
        if (this.buffer == null) {
            if (log.isInfoEnabled()) {
                log.info("starting rdr history");
            }
            this.tempStore = this.newTempTripleStore();
            this.buffer = new Buffer();
        }
        return this.buffer;
    }

    @Override
    public void transactionBegin() {
    }

    @Override
    public void transactionPrepare() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionCommited(long commitTime) {
        if (log.isDebugEnabled()) {
            log.debug("commit time: " + commitTime);
        }
        if (this.buffer == null) {
            return;
        }
        try {
            this.buffer.flush();
            if (log.isDebugEnabled()) {
                log.debug("# of adds: " + this.buffer.counter);
            }
            RemoveBuffer removes = new RemoveBuffer();
            IChunkedOrderedIterator<ISPO> it = this.tempStore.getAccessPath(SPOKeyOrder.SPO).iterator();
            ISPO last = null;
            while (it.hasNext()) {
                ISPO curr = (ISPO)it.next();
                if (last != null && last.s().equals(curr.s())) {
                    removes.add(last);
                    removes.add(curr);
                    last = null;
                    continue;
                }
                last = curr;
            }
            removes.flush();
            if (log.isDebugEnabled()) {
                log.debug("# of removes: " + removes.counter);
            }
            if (this.buffer.counter - removes.counter == 0L) {
                return;
            }
            final IV timestamp = this.database.addTerm(this.database.getValueFactory().createXSDDateTime(commitTime));
            this.database.addStatements((IChunkedOrderedIterator<ISPO>)new ChunkedResolvingIterator<ISPO, ISPO>(this.tempStore.getAccessPath(SPOKeyOrder.SPO).iterator()){

                @Override
                protected ISPO resolve(ISPO spo) {
                    SPO timestamped = new SPO(spo.s(), spo.p(), timestamp, StatementEnum.Explicit);
                    if (log.isTraceEnabled()) {
                        log.trace(spo);
                        log.trace(timestamped);
                    }
                    return timestamped;
                }
            }, null);
            this.database.commit();
        }
        finally {
            this.close();
        }
    }

    @Override
    public void transactionAborted() {
        this.close();
    }

    @Override
    public void close() {
        if (this.tempStore != null) {
            if (log.isInfoEnabled()) {
                log.info("closing rdr history");
            }
            this.tempStore.close();
            this.tempStore = null;
            this.buffer.reset();
            this.buffer = null;
        }
    }

    private class RemoveBuffer
    extends AbstractArrayBuffer<ISPO> {
        private static final int capacity = 10000;
        private long counter;

        public RemoveBuffer() {
            super(10000, ISPO.class, null);
            this.counter = 0L;
        }

        protected long flush(int n, ISPO[] a) {
            long l = RDRHistory.this.tempStore.removeStatements(new ChunkedArrayIterator<ISPO>(n, a, null), false);
            this.counter += l;
            return l;
        }
    }

    private class Buffer
    extends AbstractArrayBuffer<ISPO> {
        private static final int capacity = 10000;
        private long counter;

        public Buffer() {
            super(10000, ISPO.class, null);
            this.counter = 0L;
        }

        protected long flush(int n, ISPO[] a) {
            long l = RDRHistory.this.tempStore.addStatements(a, n);
            this.counter += l;
            return l;
        }
    }

    public static interface Vocab {
        public static final URI ADDED = new URIImpl("blaze:history:added");
        public static final URI REMOVED = new URIImpl("blaze:history:removed");
    }
}

