/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import java.io.File;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SailBase
implements Sail {
    public static final String CONNECTION_TIMEOUT = SailBase.class.getName() + ".connectionTimeout";
    protected static final long DEFAULT_CONNECTION_TIMEOUT = Long.valueOf(System.getProperty(CONNECTION_TIMEOUT, "20000"));
    static final String DEBUG_PROP = "org.openrdf.repository.debug";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile File dataDir;
    private volatile boolean initialized = false;
    protected final ReentrantReadWriteLock initializationLock = new ReentrantReadWriteLock();
    protected volatile long connectionTimeOut = DEFAULT_CONNECTION_TIMEOUT;
    private final Map<SailConnection, ConnectionContext> activeConnections = new IdentityHashMap<SailConnection, ConnectionContext>();

    protected static boolean debugEnabled() {
        try {
            String value = System.getProperty(DEBUG_PROP);
            return value != null && !value.equals("false");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void manageConnection(SailConnection cnxn) {
        Map<SailConnection, ConnectionContext> map = this.activeConnections;
        synchronized (map) {
            if (this.activeConnections.containsKey(cnxn)) {
                throw new IllegalStateException("Connection already managed");
            }
            Throwable stackTrace = SailBase.debugEnabled() ? new Throwable() : null;
            this.activeConnections.put(cnxn, new ConnectionContext(stackTrace));
        }
    }

    @Override
    public void setDataDir(File dataDir) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been initialized");
        }
        this.dataDir = dataDir;
    }

    @Override
    public File getDataDir() {
        return this.dataDir;
    }

    public String toString() {
        if (this.dataDir == null) {
            return super.toString();
        }
        return this.dataDir.toString();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() throws SailException {
        this.initializationLock.writeLock().lock();
        try {
            if (this.isInitialized()) {
                throw new IllegalStateException("sail has already been intialized");
            }
            this.initializeInternal();
            this.initialized = true;
        }
        finally {
            this.initializationLock.writeLock().unlock();
        }
    }

    protected void initializeInternal() throws SailException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() throws SailException {
        this.initializationLock.writeLock().lock();
        try {
            if (!this.isInitialized()) {
                return;
            }
            Map<SailConnection, ConnectionContext> map = this.activeConnections;
            synchronized (map) {
                if (!this.activeConnections.isEmpty()) {
                    this.logger.debug("Waiting for active connections to close before shutting down...");
                    try {
                        this.activeConnections.wait(DEFAULT_CONNECTION_TIMEOUT);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                Iterator<Map.Entry<SailConnection, ConnectionContext>> iter2 = this.activeConnections.entrySet().iterator();
                while (iter2.hasNext()) {
                    Map.Entry<SailConnection, ConnectionContext> entry = iter2.next();
                    SailConnection con = entry.getKey();
                    ConnectionContext context = entry.getValue();
                    iter2.remove();
                    if (context.trace == null) {
                        this.logger.warn("Closing active connection due to shut down; consider setting the {} system property", (Object)DEBUG_PROP);
                    } else {
                        this.logger.warn("Closing active connection due to shut down, connection was acquired in", context.trace);
                    }
                    try {
                        con.close();
                    }
                    catch (SailException e) {
                        this.logger.error("Failed to close connection", e);
                    }
                }
            }
            this.shutDownInternal();
        }
        finally {
            this.initialized = false;
            this.initializationLock.writeLock().unlock();
        }
    }

    protected abstract void shutDownInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SailConnection getConnection() throws SailException {
        this.initializationLock.readLock().lock();
        try {
            if (!this.isInitialized()) {
                throw new IllegalStateException("Sail is not initialized or has been shut down");
            }
            SailConnection connection = this.getConnectionInternal();
            Object object = this.activeConnections;
            synchronized (object) {
                if (!this.activeConnections.containsKey(connection)) {
                    throw new IllegalStateException("Connection is not managed");
                }
            }
            object = connection;
            return object;
        }
        finally {
            this.initializationLock.readLock().unlock();
        }
    }

    protected abstract SailConnection getConnectionInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(SailConnection connection) {
        Map<SailConnection, ConnectionContext> map = this.activeConnections;
        synchronized (map) {
            if (this.activeConnections.containsKey(connection)) {
                this.activeConnections.remove(connection);
                if (this.activeConnections.isEmpty()) {
                    this.activeConnections.notifyAll();
                }
            }
        }
    }

    static class ConnectionContext {
        final Throwable trace;

        ConnectionContext(Throwable trace) {
            this.trace = trace;
        }
    }
}

