/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.config;

import com.bigdata.rdf.sail.config.BigdataConfigSchema;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryImplConfigBase;

public class BigdataRepositoryConfig
extends RepositoryImplConfigBase {
    private String propertiesFile;

    public BigdataRepositoryConfig(String type) {
        super(type);
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public Properties getProperties() throws FileNotFoundException, IOException {
        if (this.propertiesFile == null) {
            return new Properties();
        }
        FileInputStream is = new FileInputStream(new File(this.propertiesFile));
        Properties props = new Properties();
        props.load(is);
        return props;
    }

    @Override
    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (this.propertiesFile != null) {
            graph.add(implNode, BigdataConfigSchema.PROPERTIES, graph.getValueFactory().createLiteral(this.propertiesFile), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            Literal propertiesLit = GraphUtil.getOptionalObjectLiteral(graph, implNode, BigdataConfigSchema.PROPERTIES);
            if (propertiesLit == null) {
                throw new RepositoryConfigException("Properties file required");
            }
            this.setPropertiesFile(propertiesLit.getLabel());
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

