/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.remote.AbstractBigdataRemoteQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedBooleanQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import java.util.concurrent.TimeUnit;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.QueryEvaluationException;

public class BigdataRemoteBooleanQuery
extends AbstractBigdataRemoteQuery
implements BooleanQuery {
    private IPreparedBooleanQuery q;

    public BigdataRemoteBooleanQuery(RemoteRepository remote, String query, String baseURI) throws Exception {
        super(baseURI);
        this.q = remote.prepareBooleanQuery(query);
    }

    @Override
    public boolean evaluate() throws QueryEvaluationException {
        try {
            this.configureConnectOptions(this.q);
            return this.q.evaluate();
        }
        catch (Exception ex) {
            throw new QueryEvaluationException(ex);
        }
    }

    @Override
    public int getMaxQueryTime() {
        long millis = this.q.getMaxQueryMillis();
        if (millis == -1L) {
            return -1;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    @Override
    public void setMaxQueryTime(int seconds) {
        this.q.setMaxQueryMillis(TimeUnit.SECONDS.toMillis(seconds));
    }
}

