/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.remote.AbstractBigdataRemoteQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedGraphQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import java.util.concurrent.TimeUnit;
import org.openrdf.model.Statement;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class BigdataRemoteGraphQuery
extends AbstractBigdataRemoteQuery
implements GraphQuery {
    private IPreparedGraphQuery q;

    public BigdataRemoteGraphQuery(RemoteRepository remote, String query, String baseURI) throws Exception {
        super(baseURI);
        this.q = remote.prepareGraphQuery(query);
    }

    @Override
    public GraphQueryResult evaluate() throws QueryEvaluationException {
        try {
            this.configureConnectOptions(this.q);
            return this.q.evaluate();
        }
        catch (Exception ex) {
            throw new QueryEvaluationException(ex);
        }
    }

    @Override
    public int getMaxQueryTime() {
        long millis = this.q.getMaxQueryMillis();
        if (millis == -1L) {
            return -1;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    @Override
    public void setMaxQueryTime(int seconds) {
        this.q.setMaxQueryMillis(TimeUnit.SECONDS.toMillis(seconds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        try (GraphQueryResult gqr = this.evaluate();){
            handler.startRDF();
            while (gqr.hasNext()) {
                handler.handleStatement((Statement)gqr.next());
            }
            handler.endRDF();
        }
    }
}

