/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.remote.AbstractBigdataRemoteQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import java.util.concurrent.TimeUnit;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;

public class BigdataRemoteTupleQuery
extends AbstractBigdataRemoteQuery
implements TupleQuery {
    private IPreparedTupleQuery q;

    public BigdataRemoteTupleQuery(RemoteRepository remote, String query, String baseURI) throws Exception {
        super(baseURI);
        this.q = remote.prepareTupleQuery(query);
    }

    @Override
    public TupleQueryResult evaluate() throws QueryEvaluationException {
        try {
            this.configureConnectOptions(this.q);
            return this.q.evaluate();
        }
        catch (Exception ex) {
            throw new QueryEvaluationException(ex);
        }
    }

    @Override
    public int getMaxQueryTime() {
        long millis = this.q.getMaxQueryMillis();
        if (millis == -1L) {
            return -1;
        }
        return (int)TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    @Override
    public void setMaxQueryTime(int seconds) {
        this.q.setMaxQueryMillis(TimeUnit.SECONDS.toMillis(seconds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        try (TupleQueryResult tqr = this.evaluate();){
            handler.startQueryResult(tqr.getBindingNames());
            while (tqr.hasNext()) {
                handler.handleSolution((BindingSet)tqr.next());
            }
            handler.endQueryResult();
        }
    }
}

