/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.remote.BigdataRemoteBooleanQuery;
import com.bigdata.rdf.sail.remote.BigdataRemoteGraphQuery;
import com.bigdata.rdf.sail.remote.BigdataRemoteTupleQuery;
import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepository;
import com.bigdata.rdf.sail.webapp.client.IPreparedSparqlUpdate;
import com.bigdata.rdf.sail.webapp.client.IRemoteTx;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.rdf.sail.webapp.client.RemoteTransactionNotFoundException;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.StatementImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.Dataset;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.Update;
import org.openrdf.query.UpdateExecutionException;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.UnknownTransactionStateException;
import org.openrdf.rio.ParserConfig;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

public class BigdataSailRemoteRepositoryConnection
implements RepositoryConnection {
    private static final transient Logger log = Logger.getLogger(BigdataSailRemoteRepositoryConnection.class);
    private final BigdataSailRemoteRepository repo;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final AtomicReference<IRemoteTx> remoteTx = new AtomicReference();

    public BigdataSailRemoteRepositoryConnection(BigdataSailRemoteRepository repo) {
        this.repo = repo;
    }

    protected RemoteRepository getRepositoryForConnection() {
        IRemoteTx tx = this.remoteTx.get();
        if (tx != null) {
            RemoteRepository rtmp = this.repo.getRemoteRepository();
            String sparqlEndpointURL = rtmp.getSparqlEndPoint();
            RemoteRepositoryManager rmgr = rtmp.getRemoteRepositoryManager();
            return rmgr.getRepositoryForURL(sparqlEndpointURL, tx);
        }
        return this.repo.getRemoteRepository();
    }

    public long count(Resource s, URI p, Value o, Resource ... c) throws RepositoryException {
        try {
            RemoteRepository remote = this.getRepositoryForConnection();
            return remote.rangeCount(s, p, o, c);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource s, URI p, Value o, boolean includeInferred, Resource ... c) throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final GraphQueryResult src = remote.getStatements(s, p, o, includeInferred, c);
            return new RepositoryResult<Statement>(new CloseableIteration<Statement, RepositoryException>(){

                @Override
                public boolean hasNext() throws RepositoryException {
                    try {
                        return src.hasNext();
                    }
                    catch (Exception ex) {
                        throw new RepositoryException(ex);
                    }
                }

                @Override
                public Statement next() throws RepositoryException {
                    try {
                        return (Statement)src.next();
                    }
                    catch (Exception ex) {
                        throw new RepositoryException(ex);
                    }
                }

                @Override
                public void remove() throws RepositoryException {
                    try {
                        src.remove();
                    }
                    catch (Exception ex) {
                        throw new RepositoryException(ex);
                    }
                }

                @Override
                public void close() throws RepositoryException {
                    try {
                        src.close();
                    }
                    catch (Exception ex) {
                        throw new RepositoryException(ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public boolean hasStatement(Resource s, URI p, Value o, boolean includeInferred, Resource ... c) throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            return remote.hasStatement(s, p, o, includeInferred, c);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException("unsupported query language: " + ql);
        }
        try {
            return new BigdataRemoteBooleanQuery(this.repo.getRemoteRepository(), query, baseURI);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareBooleanQuery(ql, query, null);
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException("unsupported query language: " + ql);
        }
        try {
            return new BigdataRemoteGraphQuery(this.repo.getRemoteRepository(), query, baseURI);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareGraphQuery(ql, query, null);
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        throw new UnsupportedOperationException("please use the specific operation for your query type: prepare[Boolean/Tuple/Graph]Query");
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        return this.prepareQuery(ql, query);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException("unsupported query language: " + ql);
        }
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            return new BigdataRemoteTupleQuery(remote, query, baseURI);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(ql, query, null);
    }

    @Override
    public boolean hasStatement(Statement s, boolean includeInferred, Resource ... c) throws RepositoryException {
        return this.hasStatement(s.getSubject(), s.getPredicate(), s.getObject(), includeInferred, c);
    }

    @Override
    public <E extends Exception> void add(Iteration<? extends Statement, E> stmts, Resource ... c) throws RepositoryException, E {
        LinkedHashModel g = new LinkedHashModel();
        while (stmts.hasNext()) {
            g.add(stmts.next());
        }
        this.add(g, c);
    }

    @Override
    public void add(Resource s, URI p, Value o, Resource ... c) throws RepositoryException {
        this.add(new StatementImpl(s, p, o), c);
    }

    @Override
    public void add(Statement stmt, Resource ... c) throws RepositoryException {
        LinkedHashModel g = new LinkedHashModel();
        g.add(stmt);
        this.add(g, c);
    }

    @Override
    public void add(Iterable<? extends Statement> stmts, Resource ... c) throws RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(stmts);
        this.add(op, c);
    }

    @Override
    public void add(Reader input, String baseURI, RDFFormat format, Resource ... c) throws IOException, RDFParseException, RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(input, format);
        this.add(op, c);
    }

    @Override
    public void add(URL input, String baseURI, RDFFormat format, Resource ... c) throws IOException, RDFParseException, RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(input.toString());
        this.add(op, c);
    }

    @Override
    public void add(File input, String baseURI, RDFFormat format, Resource ... c) throws IOException, RDFParseException, RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(input, format);
        this.add(op, c);
    }

    @Override
    public void add(InputStream input, String baseURI, RDFFormat format, Resource ... c) throws IOException, RDFParseException, RepositoryException {
        RemoteRepository.AddOp op = new RemoteRepository.AddOp(input, format);
        this.add(op, c);
    }

    private void add(RemoteRepository.AddOp op, Resource ... c) throws RepositoryException {
        try {
            op.setContext(c);
            RemoteRepository remote = this.repo.getRemoteRepository();
            remote.add(op);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public <E extends Exception> void remove(Iteration<? extends Statement, E> stmts, Resource ... c) throws RepositoryException, E {
        LinkedHashModel g = new LinkedHashModel();
        while (stmts.hasNext()) {
            g.add(stmts.next());
        }
        this.remove(g, c);
    }

    @Override
    public void remove(Statement stmt, Resource ... c) throws RepositoryException {
        LinkedHashModel g = new LinkedHashModel();
        g.add(stmt);
        this.remove(g, c);
    }

    @Override
    public void remove(Iterable<? extends Statement> stmts, Resource ... c) throws RepositoryException {
        RemoteRepository.RemoveOp op = new RemoteRepository.RemoveOp(stmts);
        this.remove(op, c);
    }

    @Override
    public void remove(Resource s, URI p, Value o, Resource ... c) throws RepositoryException {
        RemoteRepository.RemoveOp op = new RemoteRepository.RemoveOp(s, p, o, c);
        this.remove(op, c);
    }

    private void remove(RemoteRepository.RemoveOp op, Resource ... c) throws RepositoryException {
        try {
            op.setContext(c);
            RemoteRepository remote = this.repo.getRemoteRepository();
            remote.remove(op);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public Repository getRepository() {
        return this.repo;
    }

    @Override
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final Iterator<Resource> contexts = remote.getContexts().iterator();
            return new RepositoryResult<Resource>(new CloseableIteration<Resource, RepositoryException>(){

                @Override
                public boolean hasNext() throws RepositoryException {
                    return contexts.hasNext();
                }

                @Override
                public Resource next() throws RepositoryException {
                    return (Resource)contexts.next();
                }

                @Override
                public void remove() throws RepositoryException {
                    contexts.remove();
                }

                @Override
                public void close() throws RepositoryException {
                }
            });
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        return this.hasStatement(null, null, null, false, new Resource[0]);
    }

    @Override
    public long size(Resource ... c) throws RepositoryException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            return remote.rangeCount(null, null, null, c);
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public void clear(Resource ... c) throws RepositoryException {
        this.remove(null, null, null, c);
    }

    @Override
    public void export(RDFHandler handler, Resource ... c) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, true, handler, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportStatements(Resource s, URI p, Value o, boolean includeInferred, RDFHandler handler, Resource ... c) throws RepositoryException, RDFHandlerException {
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            try (GraphQueryResult src = remote.getStatements(s, p, o, includeInferred, c);){
                handler.startRDF();
                while (src.hasNext()) {
                    handler.handleStatement((Statement)src.next());
                }
                handler.endRDF();
            }
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new UnsupportedOperationException("unsupported query language: " + ql);
        }
        try {
            RemoteRepository remote = this.repo.getRemoteRepository();
            final IPreparedSparqlUpdate update = remote.prepareUpdate(query);
            return new Update(){

                @Override
                public void execute() throws UpdateExecutionException {
                    try {
                        update.evaluate();
                    }
                    catch (Exception ex) {
                        throw new UpdateExecutionException(ex);
                    }
                }

                @Override
                public void clearBindings() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public BindingSet getBindings() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void removeBinding(String arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setBinding(String arg0, Value arg1) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Dataset getDataset() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setDataset(Dataset arg0) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean getIncludeInferred() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setIncludeInferred(boolean arg0) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception ex) {
            throw new RepositoryException(ex);
        }
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String query, String baseURI) throws RepositoryException, MalformedQueryException {
        if (baseURI != null) {
            throw new UnsupportedOperationException("baseURI not supported");
        }
        return this.prepareUpdate(ql, query);
    }

    @Override
    public void setNamespace(String arg0, String arg1) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespace(String arg0) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeNamespace(String arg0) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setParserConfig(ParserConfig arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParserConfig getParserConfig() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.repo.getValueFactory();
    }

    @Override
    public boolean isOpen() throws RepositoryException {
        return this.open.get();
    }

    private void assertOpen() throws RepositoryException {
        if (!this.open.get()) {
            throw new RepositoryException("Connection is not open");
        }
    }

    @Override
    @Deprecated
    public boolean isAutoCommit() throws RepositoryException {
        return this.remoteTx.get() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        AtomicReference<IRemoteTx> atomicReference = this.remoteTx;
        synchronized (atomicReference) {
            if (!autoCommit && this.remoteTx.get() == null) {
                return;
            }
            if (this.remoteTx.get() != null) {
                this.commit();
            }
        }
    }

    @Override
    public void close() throws RepositoryException {
        if (this.open.compareAndSet(true, false)) {
            this.repo.getRemoteRepository().getRemoteRepositoryManager().getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    AtomicReference atomicReference = BigdataSailRemoteRepositoryConnection.this.remoteTx;
                    synchronized (atomicReference) {
                        IRemoteTx tx = (IRemoteTx)BigdataSailRemoteRepositoryConnection.this.remoteTx.get();
                        if (tx != null) {
                            try {
                                tx.abort();
                            }
                            catch (RuntimeException e) {
                                log.error(e, e);
                            }
                            catch (Exception e) {
                                log.error(e, e);
                            }
                            finally {
                                BigdataSailRemoteRepositoryConnection.this.remoteTx.set(null);
                            }
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        this.assertOpen();
        if (this.remoteTx.get() == null) {
            return false;
        }
        AtomicReference<IRemoteTx> atomicReference = this.remoteTx;
        synchronized (atomicReference) {
            this.assertOpen();
            IRemoteTx tx = this.remoteTx.get();
            return tx != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() throws RepositoryException {
        this.assertOpen();
        AtomicReference<IRemoteTx> atomicReference = this.remoteTx;
        synchronized (atomicReference) {
            this.assertOpen();
            if (this.remoteTx.get() != null) {
                throw new RepositoryException("Active transaction exists");
            }
            try {
                this.remoteTx.set(this.repo.getRemoteRepository().getRemoteRepositoryManager().getTransactionManager().createTx(0L));
            }
            catch (RuntimeException e) {
                throw new RepositoryException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginReadOnly() throws RepositoryException {
        this.assertOpen();
        AtomicReference<IRemoteTx> atomicReference = this.remoteTx;
        synchronized (atomicReference) {
            this.assertOpen();
            if (this.remoteTx.get() != null) {
                throw new RepositoryException("Active transaction exists");
            }
            try {
                this.remoteTx.set(this.repo.getRemoteRepository().getRemoteRepositoryManager().getTransactionManager().createTx(-1L));
            }
            catch (RuntimeException e) {
                throw new RepositoryException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginReadOnly(long timestamp) throws RepositoryException {
        if (timestamp <= 0L) {
            throw new IllegalArgumentException();
        }
        this.assertOpen();
        AtomicReference<IRemoteTx> atomicReference = this.remoteTx;
        synchronized (atomicReference) {
            this.assertOpen();
            if (this.remoteTx.get() != null) {
                throw new RepositoryException("Active transaction exists");
            }
            try {
                this.remoteTx.set(this.repo.getRemoteRepository().getRemoteRepositoryManager().getTransactionManager().createTx(timestamp));
            }
            catch (RuntimeException e) {
                throw new RepositoryException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws RepositoryException {
        this.assertOpen();
        AtomicReference<IRemoteTx> atomicReference = this.remoteTx;
        synchronized (atomicReference) {
            this.assertOpen();
            IRemoteTx tx = this.remoteTx.get();
            if (tx != null) {
                try {
                    tx.commit();
                    this.remoteTx.set(null);
                }
                catch (RemoteTransactionNotFoundException e) {
                    throw new UnknownTransactionStateException(e);
                }
                catch (RuntimeException e) {
                    throw new UnknownTransactionStateException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws RepositoryException {
        this.assertOpen();
        AtomicReference<IRemoteTx> atomicReference = this.remoteTx;
        synchronized (atomicReference) {
            this.assertOpen();
            IRemoteTx tx = this.remoteTx.get();
            if (tx != null) {
                try {
                    tx.abort();
                    this.remoteTx.set(null);
                }
                catch (RemoteTransactionNotFoundException e) {
                    throw new UnknownTransactionStateException(e);
                }
                catch (Exception e) {
                    throw new UnknownTransactionStateException(e);
                }
            }
        }
    }
}

