/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.BOpUtility;
import com.bigdata.rdf.sparql.ast.FilterNode;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.PathNode;
import com.bigdata.rdf.sparql.ast.PropertyPathNode;
import com.bigdata.rdf.sparql.ast.QuadData;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.openrdf.query.algebra.StatementPattern;

class GroupGraphPattern {
    private static final Logger log = Logger.getLogger(GroupGraphPattern.class);
    private boolean invalid = false;
    private TermNode context;
    private StatementPattern.Scope spScope = StatementPattern.Scope.DEFAULT_CONTEXTS;
    private final List<IGroupMemberNode> children = new LinkedList<IGroupMemberNode>();

    private void assertValid() {
        if (this.invalid) {
            throw new IllegalStateException();
        }
    }

    public GroupGraphPattern() {
    }

    public GroupGraphPattern(GroupGraphPattern parent) {
        this(parent.context, parent.spScope);
    }

    public GroupGraphPattern(TermNode context, StatementPattern.Scope spScope) {
        this.context = context;
        this.spScope = spScope;
    }

    public void setContextVar(TermNode context) {
        this.assertValid();
        this.context = context;
    }

    public TermNode getContext() {
        this.assertValid();
        return this.context;
    }

    public void setStatementPatternScope(StatementPattern.Scope spScope) {
        this.assertValid();
        this.spScope = spScope;
    }

    public StatementPattern.Scope getStatementPatternScope() {
        this.assertValid();
        return this.spScope;
    }

    public void add(IGroupMemberNode child) {
        this.assertValid();
        if (log.isInfoEnabled()) {
            log.info("child=" + BOpUtility.toString(child));
        }
        this.children.add(child);
    }

    public void addSP(TermNode s, TermNode p, TermNode o) {
        this.assertValid();
        if (log.isInfoEnabled()) {
            log.info("pattern= ( " + s + " " + p + " " + o + " )");
        }
        this.children.add(new StatementPatternNode(s, p, o, this.context, this.spScope));
    }

    public void addPP(TermNode s, PathNode p, TermNode o) {
        this.assertValid();
        if (log.isInfoEnabled()) {
            log.info("pattern= ( " + s + " " + p + " " + o + " )");
        }
        this.children.add(new PropertyPathNode(s, p, o, this.context, this.spScope));
    }

    public void addSP(StatementPatternNode sp) {
        this.assertValid();
        if (log.isInfoEnabled()) {
            log.info("pattern=" + sp);
        }
        if (this.context != null) {
            sp.setC(this.context);
        }
        sp.setScope(this.spScope);
        this.children.add(sp);
    }

    public void addConstraint(ValueExpressionNode constraint) {
        this.assertValid();
        if (log.isInfoEnabled()) {
            log.info("constraint=" + constraint);
        }
        this.children.add(new FilterNode(constraint));
    }

    public <T extends GroupNodeBase> T buildGroup(T groupNode) {
        this.assertValid();
        this.invalid = true;
        boolean isUnion = groupNode instanceof UnionNode;
        if (isUnion) {
            for (IGroupMemberNode child : this.children) {
                if (child instanceof JoinGroupNode) {
                    groupNode.addChild((IGroupMemberNode)child);
                    continue;
                }
                if (child instanceof UnionNode) {
                    UnionNode childUnion = (UnionNode)child;
                    for (IGroupMemberNode child2 : childUnion) {
                        groupNode.addChild((IGroupMemberNode)child2);
                    }
                    continue;
                }
                groupNode.addChild((JoinGroupNode)new JoinGroupNode(child));
            }
        } else {
            for (IGroupMemberNode child : this.children) {
                if (child instanceof QuadData && groupNode instanceof JoinGroupNode) {
                    JoinGroupNode newGroup = new JoinGroupNode();
                    ((QuadData)child).flatten(newGroup);
                    StatementPatternNode sp = (StatementPatternNode)newGroup.get(0);
                    TermNode context = sp.get(3);
                    assert (context != null);
                    assert (sp.getScope() == StatementPattern.Scope.NAMED_CONTEXTS);
                    newGroup.setContext(context);
                    groupNode.addChild((JoinGroupNode)newGroup);
                    continue;
                }
                groupNode.addChild((IGroupMemberNode)child);
            }
        }
        return groupNode;
    }

    public JoinGroupNode getSingletonGroup() {
        this.assertValid();
        this.invalid = true;
        if (this.children.size() != 1) {
            throw new RuntimeException("Expecting one child, not " + this.children.size());
        }
        return (JoinGroupNode)this.children.get(0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString() + "{");
        sb.append("context=" + this.context);
        sb.append(", scope=" + (Object)((Object)this.spScope));
        sb.append(", children=[");
        boolean first = true;
        for (IGroupMemberNode child : this.children) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(child);
            first = false;
        }
        sb.append("]}");
        return sb.toString();
    }
}

