/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.GroupGraphPattern;
import com.bigdata.rdf.sail.sparql.TriplePatternExprBuilder;
import com.bigdata.rdf.sail.sparql.ast.ASTBind;
import com.bigdata.rdf.sail.sparql.ast.ASTBindingSet;
import com.bigdata.rdf.sail.sparql.ast.ASTConstraint;
import com.bigdata.rdf.sail.sparql.ast.ASTConstruct;
import com.bigdata.rdf.sail.sparql.ast.ASTGraphGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTGraphPatternGroup;
import com.bigdata.rdf.sail.sparql.ast.ASTInlineData;
import com.bigdata.rdf.sail.sparql.ast.ASTLet;
import com.bigdata.rdf.sail.sparql.ast.ASTMinusGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTNamedSubqueryInclude;
import com.bigdata.rdf.sail.sparql.ast.ASTOptionalGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTServiceGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTTRefPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTUnionGraphPattern;
import com.bigdata.rdf.sail.sparql.ast.ASTVar;
import com.bigdata.rdf.sail.sparql.ast.ASTWhereClause;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.AssignmentNode;
import com.bigdata.rdf.sparql.ast.BindingsClause;
import com.bigdata.rdf.sparql.ast.ConstructNode;
import com.bigdata.rdf.sparql.ast.GroupNodeBase;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.NamedSubqueryInclude;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.UnionNode;
import com.bigdata.rdf.sparql.ast.ValueExpressionNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openrdf.query.algebra.StatementPattern;

public class GroupGraphPatternBuilder
extends TriplePatternExprBuilder {
    private static final Logger log = Logger.getLogger(GroupGraphPatternBuilder.class);

    public GroupGraphPatternBuilder(BigdataASTContext context) {
        super(context);
        this.graphPattern = new GroupGraphPattern();
    }

    @Override
    public final ConstructNode visit(ASTConstruct node, Object data) throws VisitorException {
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern();
        super.visit(node, null);
        ConstructNode group = this.graphPattern.buildGroup(new ConstructNode());
        this.graphPattern = parentGP;
        return group;
    }

    @Override
    public final GroupNodeBase<?> visit(ASTGraphPatternGroup node, Object data) throws VisitorException {
        JoinGroupNode ret2;
        if (log.isInfoEnabled()) {
            log.info("\ndepth=" + this.depth(node) + ", parentGP(in)=" + this.graphPattern + "\n" + node.dump(this.indent(node)));
        }
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern(parentGP);
        Object ret = super.visit(node, null);
        if (ret instanceof SubqueryRoot) {
            SubqueryRoot subqueryRoot = (SubqueryRoot)ret;
            if (node.jjtGetParent() instanceof ASTWhereClause) {
                JoinGroupNode group;
                this.graphPattern = new GroupGraphPattern(parentGP);
                this.graphPattern.add(new JoinGroupNode(subqueryRoot));
                ret2 = group = this.graphPattern.buildGroup(new JoinGroupNode());
            } else {
                JoinGroupNode group = new JoinGroupNode(subqueryRoot);
                parentGP.add(group);
                ret2 = group;
            }
        } else {
            TermNode s;
            Node child;
            JoinGroupNode joinGroup = new JoinGroupNode();
            ASTGraphGraphPattern scopePattern = this.firstASTGraphGraphAncestor(node.jjtGetParent());
            if (scopePattern != null && (child = scopePattern.jjtGetChild(0)) != null && (s = (TermNode)scopePattern.jjtGetChild(0).jjtAccept(this, data)) != null) {
                joinGroup.setContext(s);
            }
            JoinGroupNode group = this.graphPattern.buildGroup(joinGroup);
            parentGP.add(group);
            ret2 = group;
        }
        if (log.isInfoEnabled()) {
            log.info("\ndepth=" + this.depth(node) + ", graphPattern(out)=" + this.graphPattern);
        }
        this.graphPattern = parentGP;
        return ret2;
    }

    @Override
    public final Void visit(ASTOptionalGraphPattern node, Object data) throws VisitorException {
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern(parentGP);
        Object tmp = super.visit(node, null);
        JoinGroupNode joinGroup = new JoinGroupNode();
        joinGroup.setOptional(true);
        if (tmp instanceof SubqueryRoot) {
            joinGroup.addChild((SubqueryRoot)tmp);
        } else {
            JoinGroupNode group = this.graphPattern.buildGroup(joinGroup);
            assert (group == joinGroup);
        }
        parentGP.add(joinGroup);
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public Object visit(ASTMinusGraphPattern node, Object data) throws VisitorException {
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern(parentGP);
        super.visit(node, null);
        JoinGroupNode group = (JoinGroupNode)this.graphPattern.buildGroup(new JoinGroupNode()).get(0);
        group.setMinus(true);
        parentGP.add(group);
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public final Void visit(ASTGraphGraphPattern node, Object data) throws VisitorException {
        TermNode oldContext = this.graphPattern.getContext();
        StatementPattern.Scope oldScope = this.graphPattern.getStatementPatternScope();
        TermNode newContext = (TermNode)node.jjtGetChild(0).jjtAccept(this, null);
        this.graphPattern.setContextVar(newContext);
        this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        node.jjtGetChild(1).jjtAccept(this, null);
        this.graphPattern.setContextVar(oldContext);
        this.graphPattern.setStatementPatternScope(oldScope);
        return null;
    }

    @Override
    public final Void visit(ASTUnionGraphPattern node, Object data) throws VisitorException {
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern(parentGP);
        node.jjtGetChild(0).jjtAccept(this, null);
        node.jjtGetChild(1).jjtAccept(this, null);
        UnionNode union = this.graphPattern.buildGroup(new UnionNode());
        parentGP.add(union);
        this.graphPattern = parentGP;
        return null;
    }

    @Override
    public final Object visit(ASTBind node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() != 2) {
            throw new AssertionError((Object)("Expecting two children, not " + node.jjtGetNumChildren() + ", node=" + node.dump(">>>")));
        }
        if (node.jjtGetChild(0) instanceof ASTTRefPattern) {
            node.jjtGetChild(0).jjtAccept(this, data);
            return null;
        }
        Object expr = node.jjtGetChild(0).jjtAccept(this, data);
        ValueExpressionNode ve = (ValueExpressionNode)expr;
        Node aliasNode = node.jjtGetChild(1);
        String alias = ((ASTVar)aliasNode).getName();
        AssignmentNode bind = new AssignmentNode(new VarNode(alias), ve);
        this.graphPattern.add(bind);
        return bind;
    }

    @Override
    public final BindingsClause visit(ASTInlineData node, Object data) throws VisitorException {
        List<ASTVar> varNodes = node.jjtGetChildren(ASTVar.class);
        int nvars = varNodes.size();
        LinkedHashSet vars = new LinkedHashSet(nvars);
        for (ASTVar varNode : varNodes) {
            VarNode var = (VarNode)varNode.jjtAccept(this, data);
            IVariableOrConstant v = var.getValueExpression();
            if (vars.add((IVariable<?>)v)) continue;
            throw new VisitorException("duplicate variable in BINDINGS");
        }
        List<ASTBindingSet> bindingNodes = node.jjtGetChildren(ASTBindingSet.class);
        LinkedList<IBindingSet> bindingSets = new LinkedList<IBindingSet>();
        IVariable[] declaredVars = vars.toArray(new IVariable[nvars]);
        for (ASTBindingSet bindingNode : bindingNodes) {
            IBindingSet bindingSet = (IBindingSet)bindingNode.jjtAccept(this, declaredVars);
            bindingSets.add(bindingSet);
        }
        BindingsClause bind = new BindingsClause(vars, bindingSets);
        this.graphPattern.add(bind);
        return bind;
    }

    @Override
    public final AssignmentNode visit(ASTLet node, Object data) throws VisitorException {
        if (node.jjtGetNumChildren() != 2) {
            throw new AssertionError((Object)("Expecting two children, not " + node.jjtGetNumChildren() + ", node=" + node.dump(">>>")));
        }
        ValueExpressionNode ve = (ValueExpressionNode)node.jjtGetChild(1).jjtAccept(this, data);
        Node aliasNode = node.jjtGetChild(0);
        String alias = ((ASTVar)aliasNode).getName();
        AssignmentNode bind = new AssignmentNode(new VarNode(alias), ve);
        this.graphPattern.add(bind);
        return bind;
    }

    @Override
    public final ValueExpressionNode visit(ASTConstraint node, Object data) throws VisitorException {
        ValueExpressionNode valueExpr = (ValueExpressionNode)node.jjtGetChild(0).jjtAccept(this, null);
        this.graphPattern.addConstraint(valueExpr);
        return valueExpr;
    }

    @Override
    public final Void visit(ASTNamedSubqueryInclude node, Object data) throws VisitorException {
        NamedSubqueryInclude includeNode = new NamedSubqueryInclude(node.getName());
        this.graphPattern.add(includeNode);
        return null;
    }

    @Override
    public final Void visit(ASTServiceGraphPattern node, Object data) throws VisitorException {
        TermNode serviceRef = (TermNode)node.jjtGetChild(0).jjtAccept(this, null);
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern(parentGP);
        node.jjtGetChild(1).jjtAccept(this, null);
        JoinGroupNode graphNode = this.graphPattern.getSingletonGroup();
        this.graphPattern = parentGP;
        ServiceNode serviceNode = new ServiceNode(serviceRef, graphNode);
        serviceNode.setExprImage(node.getPatternString());
        Map<String, String> prefixDecls = node.getPrefixDeclarations();
        if (prefixDecls != null && !prefixDecls.isEmpty()) {
            serviceNode.setPrefixDecls(prefixDecls);
        }
        if (node.isSilent()) {
            serviceNode.setSilent(true);
        }
        this.graphPattern.add(serviceNode);
        return null;
    }
}

