/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.bop.BOpUtility;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.sail.sparql.BigdataASTContext;
import com.bigdata.rdf.sail.sparql.BigdataExprBuilder;
import com.bigdata.rdf.sail.sparql.GroupGraphPattern;
import com.bigdata.rdf.sail.sparql.SPARQLStarUpdateDataBlockParser;
import com.bigdata.rdf.sail.sparql.ast.ASTAdd;
import com.bigdata.rdf.sail.sparql.ast.ASTClear;
import com.bigdata.rdf.sail.sparql.ast.ASTCopy;
import com.bigdata.rdf.sail.sparql.ast.ASTCreate;
import com.bigdata.rdf.sail.sparql.ast.ASTCreateEntailments;
import com.bigdata.rdf.sail.sparql.ast.ASTDeleteClause;
import com.bigdata.rdf.sail.sparql.ast.ASTDeleteData;
import com.bigdata.rdf.sail.sparql.ast.ASTDeleteWhere;
import com.bigdata.rdf.sail.sparql.ast.ASTDisableEntailments;
import com.bigdata.rdf.sail.sparql.ast.ASTDrop;
import com.bigdata.rdf.sail.sparql.ast.ASTDropEntailments;
import com.bigdata.rdf.sail.sparql.ast.ASTEnableEntailments;
import com.bigdata.rdf.sail.sparql.ast.ASTGraphOrDefault;
import com.bigdata.rdf.sail.sparql.ast.ASTGraphPatternGroup;
import com.bigdata.rdf.sail.sparql.ast.ASTGraphRefAll;
import com.bigdata.rdf.sail.sparql.ast.ASTIRI;
import com.bigdata.rdf.sail.sparql.ast.ASTInsertClause;
import com.bigdata.rdf.sail.sparql.ast.ASTInsertData;
import com.bigdata.rdf.sail.sparql.ast.ASTLoad;
import com.bigdata.rdf.sail.sparql.ast.ASTModify;
import com.bigdata.rdf.sail.sparql.ast.ASTMove;
import com.bigdata.rdf.sail.sparql.ast.ASTQuadsNotTriples;
import com.bigdata.rdf.sail.sparql.ast.ASTSolutionsRef;
import com.bigdata.rdf.sail.sparql.ast.ASTUnparsedQuadDataBlock;
import com.bigdata.rdf.sail.sparql.ast.ASTUpdate;
import com.bigdata.rdf.sail.sparql.ast.Node;
import com.bigdata.rdf.sail.sparql.ast.VisitorException;
import com.bigdata.rdf.sparql.ast.AddGraph;
import com.bigdata.rdf.sparql.ast.ClearGraph;
import com.bigdata.rdf.sparql.ast.ConstantNode;
import com.bigdata.rdf.sparql.ast.CopyGraph;
import com.bigdata.rdf.sparql.ast.CreateEntailments;
import com.bigdata.rdf.sparql.ast.CreateGraph;
import com.bigdata.rdf.sparql.ast.DeleteData;
import com.bigdata.rdf.sparql.ast.DeleteInsertGraph;
import com.bigdata.rdf.sparql.ast.DisableEntailments;
import com.bigdata.rdf.sparql.ast.DropEntailments;
import com.bigdata.rdf.sparql.ast.DropGraph;
import com.bigdata.rdf.sparql.ast.EnableEntailments;
import com.bigdata.rdf.sparql.ast.GraphPatternGroup;
import com.bigdata.rdf.sparql.ast.InsertData;
import com.bigdata.rdf.sparql.ast.JoinGroupNode;
import com.bigdata.rdf.sparql.ast.LoadGraph;
import com.bigdata.rdf.sparql.ast.MoveGraph;
import com.bigdata.rdf.sparql.ast.QuadData;
import com.bigdata.rdf.sparql.ast.QuadsDataOrNamedSolutionSet;
import com.bigdata.rdf.sparql.ast.StatementPatternNode;
import com.bigdata.rdf.sparql.ast.TermNode;
import com.bigdata.rdf.sparql.ast.VarNode;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import org.openrdf.model.BNode;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.BasicParserSettings;
import org.openrdf.rio.helpers.StatementCollector;

public class UpdateExprBuilder
extends BigdataExprBuilder {
    public UpdateExprBuilder(BigdataASTContext context) {
        super(context);
    }

    @Override
    public InsertData visit(ASTInsertData node, Object data) throws VisitorException {
        InsertData op = new InsertData();
        op.setData(this.doUnparsedQuadsDataBlock(node, data, false, true));
        return op;
    }

    @Override
    public DeleteData visit(ASTDeleteData node, Object data) throws VisitorException {
        DeleteData op = new DeleteData();
        op.setData(this.doUnparsedQuadsDataBlock(node, data, false, false));
        return op;
    }

    @Override
    public QuadData visit(ASTQuadsNotTriples node, Object data) throws VisitorException {
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = this.scopedGroupGraphPattern(node);
        TermNode contextNode = (TermNode)node.jjtGetChild(0).jjtAccept(this, data);
        this.graphPattern.setContextVar(contextNode);
        this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        QuadData group = this.graphPattern.buildGroup(new QuadData());
        parentGP.add(group);
        this.graphPattern = parentGP;
        return group;
    }

    @Override
    public DeleteInsertGraph visit(ASTDeleteWhere node, Object data) throws VisitorException {
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContext());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        JoinGroupNode whereClause = this.graphPattern.buildGroup(new JoinGroupNode());
        this.graphPattern = parentGP;
        Iterator<StatementPatternNode> itr = BOpUtility.visitAll(whereClause, StatementPatternNode.class);
        while (itr.hasNext()) {
            StatementPatternNode sp = itr.next();
            this.assertNotAnonymousVariable(sp.s());
            this.assertNotAnonymousVariable(sp.o());
        }
        DeleteInsertGraph op = new DeleteInsertGraph();
        op.setWhereClause(whereClause);
        return op;
    }

    @Override
    public LoadGraph visit(ASTLoad node, Object data) throws VisitorException {
        ConstantNode sourceGraph = (ConstantNode)node.jjtGetChild(0).jjtAccept(this, data);
        LoadGraph op = new LoadGraph();
        op.setSourceGraph(sourceGraph);
        if (node.isSilent()) {
            op.setSilent(true);
        }
        if (node.jjtGetNumChildren() > 1) {
            ConstantNode targetGraph = (ConstantNode)node.jjtGetChild(1).jjtAccept(this, data);
            op.setTargetGraph(targetGraph);
        }
        return op;
    }

    @Override
    public ClearGraph visit(ASTClear node, Object data) throws VisitorException {
        ASTGraphRefAll graphRef;
        ClearGraph op = new ClearGraph();
        if (node.isSilent()) {
            op.setSilent(true);
        }
        if ((graphRef = node.jjtGetChild(ASTGraphRefAll.class)).jjtGetNumChildren() > 0) {
            TermNode targetGraph = (TermNode)graphRef.jjtGetChild(0).jjtAccept(this, data);
            if (targetGraph instanceof ConstantNode) {
                op.setTargetGraph((ConstantNode)targetGraph);
            } else {
                op.setTargetSolutionSet(targetGraph.getValueExpression().getName());
            }
        } else {
            if (graphRef.isDefault()) {
                op.setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
            } else if (graphRef.isNamed()) {
                op.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
            }
            if (graphRef.isAllGraphs()) {
                op.setAllGraphs(true);
            }
            if (graphRef.isAllSolutions()) {
                op.setAllSolutionSets(true);
            }
        }
        return op;
    }

    @Override
    public DropGraph visit(ASTDrop node, Object data) throws VisitorException {
        ASTGraphRefAll graphRef;
        DropGraph op = new DropGraph();
        if (node.isSilent()) {
            op.setSilent(true);
        }
        if ((graphRef = node.jjtGetChild(ASTGraphRefAll.class)).jjtGetNumChildren() > 0) {
            TermNode targetGraph = (TermNode)graphRef.jjtGetChild(0).jjtAccept(this, data);
            if (targetGraph instanceof ConstantNode) {
                op.setTargetGraph((ConstantNode)targetGraph);
            } else {
                op.setTargetSolutionSet(targetGraph.getValueExpression().getName());
            }
        } else {
            if (graphRef.isDefault()) {
                op.setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
            } else if (graphRef.isNamed()) {
                op.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
            }
            if (graphRef.isAllGraphs()) {
                op.setAllGraphs(true);
            }
            if (graphRef.isAllSolutions()) {
                op.setAllSolutionSets(true);
            }
        }
        return op;
    }

    @Override
    public CreateGraph visit(ASTCreate node, Object data) throws VisitorException {
        TermNode target = (TermNode)node.jjtGetChild(0).jjtAccept(this, data);
        CreateGraph op = new CreateGraph();
        if (target instanceof ConstantNode) {
            op.setTargetGraph((ConstantNode)target);
        } else {
            op.setTargetSolutionSet(target.getValueExpression().getName());
            BigdataStatement[] params = this.doQuadsData(node, data, false, true);
            if (params != null && params.length > 0) {
                op.setParams(params);
            }
        }
        if (node.isSilent()) {
            op.setSilent(true);
        }
        return op;
    }

    @Override
    public CopyGraph visit(ASTCopy node, Object data) throws VisitorException {
        ASTGraphOrDefault destinationNode;
        ASTGraphOrDefault sourceNode;
        CopyGraph op = new CopyGraph();
        if (node.isSilent()) {
            op.setSilent(true);
        }
        if ((sourceNode = (ASTGraphOrDefault)node.jjtGetChild(0)).jjtGetNumChildren() > 0) {
            ConstantNode sourceGraph = (ConstantNode)sourceNode.jjtGetChild(0).jjtAccept(this, data);
            op.setSourceGraph(sourceGraph);
        }
        if ((destinationNode = (ASTGraphOrDefault)node.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ConstantNode targetGraph = (ConstantNode)destinationNode.jjtGetChild(0).jjtAccept(this, data);
            op.setTargetGraph(targetGraph);
        }
        return op;
    }

    @Override
    public MoveGraph visit(ASTMove node, Object data) throws VisitorException {
        ASTGraphOrDefault targetNode;
        ASTGraphOrDefault sourceNode;
        MoveGraph op = new MoveGraph();
        if (node.isSilent()) {
            op.setSilent(true);
        }
        if ((sourceNode = (ASTGraphOrDefault)node.jjtGetChild(0)).jjtGetNumChildren() > 0) {
            ConstantNode sourceGraph = (ConstantNode)sourceNode.jjtGetChild(0).jjtAccept(this, data);
            op.setSourceGraph(sourceGraph);
        }
        if ((targetNode = (ASTGraphOrDefault)node.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ConstantNode targetGraph = (ConstantNode)targetNode.jjtGetChild(0).jjtAccept(this, data);
            op.setTargetGraph(targetGraph);
        }
        return op;
    }

    @Override
    public AddGraph visit(ASTAdd node, Object data) throws VisitorException {
        ASTGraphOrDefault targetNode;
        ASTGraphOrDefault sourceNode;
        AddGraph op = new AddGraph();
        if (node.isSilent()) {
            op.setSilent(true);
        }
        if ((sourceNode = (ASTGraphOrDefault)node.jjtGetChild(0)).jjtGetNumChildren() > 0) {
            ConstantNode sourceGraph = (ConstantNode)sourceNode.jjtGetChild(0).jjtAccept(this, data);
            op.setSourceGraph(sourceGraph);
        }
        if ((targetNode = (ASTGraphOrDefault)node.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ConstantNode targetGraph = (ConstantNode)targetNode.jjtGetChild(0).jjtAccept(this, data);
            op.setTargetGraph(targetGraph);
        }
        return op;
    }

    @Override
    public DeleteInsertGraph visit(ASTModify node, Object data) throws VisitorException {
        ASTInsertClause insertNode;
        QuadData quadData;
        ASTDeleteClause deleteNode;
        ASTGraphPatternGroup whereClause;
        DeleteInsertGraph op = new DeleteInsertGraph();
        ConstantNode with = null;
        ASTIRI withNode = node.getWithClause();
        if (withNode != null) {
            with = (ConstantNode)withNode.jjtAccept(this, data);
            this.graphPattern.setContextVar(with);
            this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        }
        if ((whereClause = node.getWhereClause()) != null) {
            GraphPatternGroup ret = (GraphPatternGroup)whereClause.jjtAccept(this, null);
            op.setWhereClause(ret);
        }
        if ((deleteNode = node.getDeleteClause()) != null) {
            if (deleteNode.getName() == null) {
                quadData = (QuadData)deleteNode.jjtAccept(this, data);
                op.setDeleteClause(new QuadsDataOrNamedSolutionSet(quadData));
            } else {
                QuadsDataOrNamedSolutionSet deleteClause = new QuadsDataOrNamedSolutionSet(deleteNode.getName());
                this.handleSelect(deleteNode.getSelect(), deleteClause);
                op.setDeleteClause(deleteClause);
            }
        }
        if ((insertNode = node.getInsertClause()) != null) {
            if (insertNode.getName() == null) {
                quadData = (QuadData)insertNode.jjtAccept(this, data);
                op.setInsertClause(new QuadsDataOrNamedSolutionSet(quadData));
            } else {
                QuadsDataOrNamedSolutionSet insertClause = new QuadsDataOrNamedSolutionSet(insertNode.getName());
                this.handleSelect(insertNode.getSelect(), insertClause);
                op.setInsertClause(insertClause);
            }
        }
        return op;
    }

    @Override
    public QuadData visit(ASTDeleteClause node, Object data) throws VisitorException {
        return this.doQuadsPatternClause(node, data, false);
    }

    @Override
    public QuadData visit(ASTInsertClause node, Object data) throws VisitorException {
        return this.doQuadsPatternClause(node, data, true);
    }

    private BigdataStatement[] doUnparsedQuadsDataBlock(ASTUpdate node, Object data, boolean allowVars, boolean allowBlankNodes) throws VisitorException {
        ASTUnparsedQuadDataBlock dataBlock = node.jjtGetChild(ASTUnparsedQuadDataBlock.class);
        SPARQLStarUpdateDataBlockParser parser = new SPARQLStarUpdateDataBlockParser(this.context.valueFactory);
        LinkedList<Statement> stmts = new LinkedList<Statement>();
        StatementCollector sc = new StatementCollector(stmts);
        parser.setRDFHandler(sc);
        parser.getParserConfig().addNonFatalError(BasicParserSettings.VERIFY_DATATYPE_VALUES);
        parser.getParserConfig().addNonFatalError(BasicParserSettings.FAIL_ON_UNKNOWN_DATATYPES);
        try {
            parser.parse(new StringReader(dataBlock.getDataBlock()), "");
        }
        catch (RDFParseException e) {
            throw new VisitorException(e);
        }
        catch (RDFHandlerException e) {
            throw new VisitorException(e);
        }
        catch (IOException e) {
            throw new VisitorException(e);
        }
        if (!allowBlankNodes) {
            for (Statement stmt : stmts) {
                if (!this.isInvalidBlankNode(stmt.getSubject()) && !(stmt.getPredicate() instanceof BNode) && !this.isInvalidBlankNode(stmt.getObject()) && (stmt.getContext() == null || !(stmt.getContext() instanceof BNode))) continue;
                throw new VisitorException("Blank nodes are not permitted in DELETE DATA");
            }
        }
        BigdataStatement[] a = stmts.toArray(new BigdataStatement[stmts.size()]);
        return a;
    }

    private boolean isInvalidBlankNode(Value v) {
        if (v instanceof BigdataBNode && ((BigdataBNode)v).isStatementIdentifier()) {
            return false;
        }
        return v instanceof BNode;
    }

    private BigdataStatement[] doQuadsData(ASTUpdate node, Object data, boolean allowVars, boolean allowBlankNodes) throws VisitorException {
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContext());
        if (node.jjtGetNumChildren() > 0) {
            Node child0 = node.jjtGetChild(0);
            Object algebraExpr = child0.jjtAccept(this, data);
            if (algebraExpr instanceof ConstantNode) {
                ConstantNode context = (ConstantNode)algebraExpr;
                this.graphPattern.setContextVar(context);
                this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
            }
            for (int i = 1; i < node.jjtGetNumChildren(); ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
        }
        QuadData quadData = this.graphPattern.buildGroup(new QuadData());
        this.graphPattern = parentGP;
        LinkedList<BigdataStatement> stmts = new LinkedList<BigdataStatement>();
        Iterator<StatementPatternNode> itr = BOpUtility.visitAll(quadData, StatementPatternNode.class);
        while (itr.hasNext()) {
            StatementPatternNode sp = itr.next();
            if (!allowVars) {
                this.assertNotVariable(sp.s());
                this.assertNotVariable(sp.p());
                this.assertNotVariable(sp.o());
                this.assertNotVariable(sp.c());
            }
            if (!allowBlankNodes) {
                this.assertNotAnonymousVariable(sp.s());
                this.assertNotAnonymousVariable(sp.o());
            }
            BigdataResource s = (BigdataResource)this.toValue(sp.s());
            BigdataValue o = this.toValue(sp.o());
            BigdataStatement spo = this.context.valueFactory.createStatement(s, (BigdataURI)sp.p().getValue(), o, (BigdataResource)(sp.c() != null ? sp.c().getValue() : null), StatementEnum.Explicit);
            stmts.add(spo);
        }
        BigdataStatement[] a = stmts.toArray(new BigdataStatement[stmts.size()]);
        return a;
    }

    private void assertNotVariable(TermNode t) throws VisitorException {
        if (t == null) {
            return;
        }
        if (!t.isVariable()) {
            return;
        }
        VarNode v = (VarNode)t;
        if (v.isAnonymous()) {
            return;
        }
        throw new VisitorException("Variable not permitted in this context: " + t);
    }

    private void assertNotAnonymousVariable(TermNode t) throws VisitorException {
        IV iv;
        VarNode v;
        if (t.isVariable() ? (v = (VarNode)t).isAnonymous() : (iv = (IV)t.getValueExpression().get()).isBNode()) {
            throw new VisitorException("BlankNode not permitted in this context: " + t);
        }
    }

    private BigdataValue toValue(TermNode t) {
        if (t.isVariable() && ((VarNode)t).isAnonymous()) {
            BigdataBNode s = this.context.valueFactory.createBNode(t.getValueExpression().getName());
            return s;
        }
        return t.getValue();
    }

    private QuadData doQuadsPatternClause(Node node, Object data, boolean allowBlankNodes) throws VisitorException {
        GroupGraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GroupGraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContext());
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        QuadData quadData = this.graphPattern.buildGroup(new QuadData());
        if (!allowBlankNodes) {
            Iterator<StatementPatternNode> itr = BOpUtility.visitAll(quadData, StatementPatternNode.class);
            while (itr.hasNext()) {
                StatementPatternNode sp = itr.next();
                this.assertNotAnonymousVariable(sp.s());
                this.assertNotAnonymousVariable(sp.o());
            }
        }
        this.graphPattern = parentGP;
        return quadData;
    }

    @Override
    public final VarNode visit(ASTSolutionsRef node, Object data) throws VisitorException {
        String name = node.getName();
        VarNode c = new VarNode(name);
        c.setSolutionSet(true);
        return c;
    }

    @Override
    public DropEntailments visit(ASTDropEntailments node, Object data) throws VisitorException {
        return new DropEntailments();
    }

    @Override
    public CreateEntailments visit(ASTCreateEntailments node, Object data) throws VisitorException {
        return new CreateEntailments();
    }

    @Override
    public EnableEntailments visit(ASTEnableEntailments node, Object data) throws VisitorException {
        return new EnableEntailments();
    }

    @Override
    public DisableEntailments visit(ASTDisableEntailments node, Object data) throws VisitorException {
        return new DisableEntailments();
    }
}

