/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.webapp.XMLBuilder;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.util.NV;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractRestApiTask<T>
extends AbstractApiTask<T> {
    private static final Logger log = Logger.getLogger(AbstractRestApiTask.class);
    protected final UUID uuid;
    protected final HttpServletRequest req;
    protected final HttpServletResponse resp;
    private ServletOutputStream os;
    private PrintWriter writer;
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        this.lock.lock();
        try {
            this.os = this.resp.getOutputStream();
            FilterOutputStream filterOutputStream = new FilterOutputStream(this.os){

                @Override
                public void flush() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException();
                }
            };
            return filterOutputStream;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter getWriter() throws IOException {
        this.lock.lock();
        try {
            this.writer = this.resp.getWriter();
            PrintWriter printWriter = new PrintWriter(this.writer){

                @Override
                public void flush() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException();
                }
            };
            return printWriter;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAndClose() throws IOException {
        this.lock.lock();
        try {
            if (log.isInfoEnabled()) {
                log.info("FLUSH-AND-CLOSE: " + this.toString());
            }
            if (this.os != null) {
                ServletOutputStream tmp = this.resp.getOutputStream();
                tmp.flush();
                tmp.close();
            } else if (this.writer != null) {
                PrintWriter tmp = this.resp.getWriter();
                tmp.flush();
                tmp.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected AbstractRestApiTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp) {
        this(req, resp, namespace, timestamp, false);
    }

    protected AbstractRestApiTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, boolean isGRSRequired) {
        super(namespace, timestamp, isGRSRequired);
        this.req = req;
        this.resp = resp;
        String s = req.getParameter("queryId");
        this.uuid = s == null ? UUID.randomUUID() : UUID.fromString(s);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{namespace=" + this.getNamespace() + ",timestamp=" + this.getTimestamp() + ", isGRSRequired=" + this.isGRSRequired() + "}";
    }

    protected void reportModifiedCount(long nmodified, long elapsed) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("task=" + this + ", nmodified=" + nmodified);
        }
        StringWriter stringWriter = new StringWriter();
        XMLBuilder t = new XMLBuilder(stringWriter);
        t.root("data").attr("modified", nmodified).attr("milliseconds", elapsed).close();
        this.resp.setStatus(200);
        this.resp.setContentType("application/xml");
        PrintWriter writer = this.resp.getWriter();
        ((Writer)writer).write(stringWriter.toString());
    }

    protected void buildResponse(int status, String mimeType, String content, NV ... headers) throws IOException {
        if (status < 200 || status >= 300) {
            throw new AssertionError((Object)"This method must not be used for non-success outcomes");
        }
        if (log.isInfoEnabled()) {
            log.info("task=" + this + ", status=" + status + ", mimeType=" + mimeType + ", content=[" + content + "]");
        }
        this.resp.setStatus(status);
        this.resp.setContentType(mimeType);
        for (NV nv : headers) {
            this.resp.setHeader(nv.getName(), nv.getValue());
        }
        PrintWriter w = this.resp.getWriter();
        if (content != null) {
            ((Writer)w).write(content);
        }
    }
}

