/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.properties.PropertiesWriter;
import com.bigdata.rdf.properties.PropertiesWriterFactory;
import com.bigdata.rdf.properties.PropertiesWriterRegistry;
import com.bigdata.rdf.rules.ConstraintViolationException;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.ConnegUtil;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.sail.webapp.HttpOperationException;
import com.bigdata.rdf.sail.webapp.XMLBuilder;
import com.bigdata.rdf.sail.webapp.client.EncodeDecodeValue;
import com.bigdata.rdf.sparql.ast.QuadsOperationInTriplesModeException;
import com.bigdata.util.InnerCause;
import com.bigdata.util.NV;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;

public abstract class BigdataRDFServlet
extends BigdataServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(BigdataRDFServlet.class);
    protected static final String UTF8 = "UTF-8";
    protected static final String NA = "N/A";
    public static final transient String MIME_SPARQL_RESULTS_XML = "application/sparql-results+xml";
    public static final transient String MIME_SPARQL_RESULTS_JSON = "application/sparql-results+json";
    public static final transient String MIME_RDF_XML = "application/rdf+xml";
    public static final String MIME_JSON = "application/json";
    public static final String MIME_SPARQL_QUERY = "application/sparql-query";
    public static final String MIME_SPARQL_UPDATE = "application/sparql-update";
    public static final String OUTPUT_FORMAT_QUERY_PARAMETER = "format";
    public static final String OUTPUT_FORMAT_JSON = "sparql-results+json";
    public static final String OUTPUT_FORMAT_XML = "sparql-results+xml";
    public static final String OUTPUT_FORMAT_JSON_SHORT = "json";
    public static final String OUTPUT_FORMAT_XML_SHORT = "xml";
    public static final String UNDEFINED_WORKBENCH_NAMESPACE = "undefined";
    public static final transient String ATTR_BLUEPRINTS = "blueprints";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launderThrowable(Throwable t, HttpServletResponse resp, String queryStr) {
        boolean isQuery = queryStr != null && queryStr.length() > 0;
        log.error("cause=" + t + (isQuery ? ", query=" + queryStr : ""), t);
        if (resp == null) {
            return;
        }
        if (!resp.isCommitted()) {
            if (InnerCause.isInnerCause(t, DatasetNotFoundException.class)) {
                resp.setStatus(404);
                resp.setContentType("text/plain");
            } else if (InnerCause.isInnerCause(t, ConstraintViolationException.class)) {
                resp.setStatus(400);
                resp.setContentType("text/plain");
            } else if (InnerCause.isInnerCause(t, MalformedQueryException.class)) {
                resp.setStatus(400);
                resp.setContentType("text/plain");
            } else if (InnerCause.isInnerCause(t, QuadsOperationInTriplesModeException.class)) {
                resp.setStatus(400);
                resp.setContentType("text/plain");
            } else {
                if (InnerCause.isInnerCause(t, HttpOperationException.class)) {
                    HttpOperationException ex = (HttpOperationException)InnerCause.getInnerCause(t, HttpOperationException.class);
                    resp.setStatus(ex.status);
                    resp.setContentType(ex.mimeType);
                    try {
                        PrintWriter w = resp.getWriter();
                        if (ex.content != null) {
                            ((Writer)w).write(ex.content);
                        }
                        ((Writer)w).flush();
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    return;
                }
                resp.setStatus(500);
                resp.setContentType("text/plain");
            }
        }
        ServletOutputStream os = null;
        PrintWriter w = null;
        try {
            try {
                os = resp.getOutputStream();
                w = new PrintWriter(os);
            }
            catch (IllegalStateException ex) {
                w = resp.getWriter();
            }
            if (queryStr != null) {
                w.write(queryStr);
                w.write("\n");
            }
            t.printStackTrace(w);
            w.flush();
            if (os != null) {
                os.flush();
            }
        }
        catch (IOException ex) {}
        if (w != null) {
            try {
                w.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (Throwable t2) {
                // empty catch block
            }
        }
    }

    protected long getTimestamp(HttpServletRequest req) {
        String timestamp = req.getParameter("timestamp");
        if (timestamp == null) {
            return BigdataRDFServlet.getConfig((ServletContext)this.getServletContext()).timestamp;
        }
        return Long.valueOf(timestamp);
    }

    protected String getNamespace(HttpServletRequest req) {
        String namespace;
        String uri = req.getRequestURI();
        int snmsp = uri.indexOf("/namespace/");
        if (snmsp == -1) {
            String s = req.getParameter("namespace");
            if (s != null && (s = s.trim()).length() > 0) {
                return s;
            }
            return BigdataRDFServlet.getConfig((ServletContext)this.getServletContext()).namespace;
        }
        int beginIndex = uri.indexOf(47, snmsp + 1);
        int endIndex = uri.indexOf(47, beginIndex + 1);
        if (endIndex == -1) {
            endIndex = uri.length();
        }
        String t = uri.substring(beginIndex + 1, endIndex);
        try {
            namespace = URLDecoder.decode(t, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (UNDEFINED_WORKBENCH_NAMESPACE.equals(namespace)) {
            namespace = BigdataRDFServlet.getConfig((ServletContext)this.getServletContext()).namespace;
        }
        return namespace;
    }

    protected static final PipedInputStream newPipedInputStream(PipedOutputStream os) throws IOException {
        return new PipedInputStream(os);
    }

    protected void buildAndCommitNamespaceNotFoundResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        BigdataRDFServlet.buildAndCommitResponse(resp, 404, "text/plain", "Not found: namespace=" + this.getNamespace(req), new NV[0]);
    }

    protected static void buildAndCommitRangeCountResponse(HttpServletResponse resp, long rangeCount, long elapsed) throws IOException {
        StringWriter w = new StringWriter();
        XMLBuilder t = new XMLBuilder(w);
        t.root("data").attr("rangeCount", rangeCount).attr("milliseconds", elapsed).close();
        BigdataRDFServlet.buildAndCommitResponse(resp, 200, "application/xml", w.toString(), new NV[0]);
    }

    protected static void buildAndCommitBooleanResponse(HttpServletResponse resp, boolean result, long elapsed) throws IOException {
        StringWriter w = new StringWriter();
        XMLBuilder t = new XMLBuilder(w);
        t.root("data").attr("result", result).attr("milliseconds", elapsed).close();
        BigdataRDFServlet.buildAndCommitResponse(resp, 200, "application/xml", w.toString(), new NV[0]);
    }

    public static void sendGraph(HttpServletRequest req, HttpServletResponse resp, Graph g) throws IOException {
        RDFWriterFactory writerFactory;
        ArrayList<String> acceptHeaders = Collections.list(req.getHeaders("Accept"));
        String acceptStr = ConnegUtil.getMimeTypeForQueryParameterQueryRequest(req.getParameter(OUTPUT_FORMAT_QUERY_PARAMETER), acceptHeaders.toArray(new String[acceptHeaders.size()]));
        ConnegUtil util = new ConnegUtil(acceptStr);
        RDFFormat format = util.getRDFFormat();
        if (format == null) {
            format = RDFFormat.RDFXML;
        }
        if ((writerFactory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get(format)) == null) {
            if (log.isDebugEnabled()) {
                log.debug("No writer for format: format=" + format + ", Accept=\"" + acceptStr + "\"");
            }
            format = RDFFormat.RDFXML;
            writerFactory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get(format);
        }
        resp.setStatus(200);
        resp.setContentType(format.getDefaultMIMEType());
        try (ServletOutputStream os = resp.getOutputStream();){
            RDFWriter writer = writerFactory.getWriter(os);
            writer.startRDF();
            for (Statement stmt : g) {
                writer.handleStatement(stmt);
            }
            writer.endRDF();
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendProperties(HttpServletRequest req, HttpServletResponse resp, Properties properties) throws IOException {
        ArrayList<String> acceptHeaders = Collections.list(req.getHeaders("Accept"));
        String acceptStr = ConnegUtil.getMimeTypeForQueryParameterQueryRequest(req.getParameter(OUTPUT_FORMAT_QUERY_PARAMETER), acceptHeaders.toArray(new String[acceptHeaders.size()]));
        ConnegUtil util = new ConnegUtil(acceptStr);
        PropertiesFormat format = util.getPropertiesFormat();
        if (format == null) {
            format = PropertiesFormat.XML;
        }
        resp.setStatus(200);
        resp.setContentType(format.getDefaultMIMEType());
        try (ServletOutputStream os = resp.getOutputStream();){
            PropertiesWriter writer = ((PropertiesWriterFactory)PropertiesWriterRegistry.getInstance().get(format)).getWriter(os);
            writer.write(properties);
            os.flush();
        }
    }

    protected static boolean isAttachment(String mimeType) {
        if (mimeType.equals("text/plain")) {
            return false;
        }
        if (mimeType.equals(MIME_SPARQL_RESULTS_XML)) {
            return false;
        }
        if (mimeType.equals(MIME_SPARQL_RESULTS_JSON)) {
            return false;
        }
        return !mimeType.equals("application/xml");
    }

    protected static Resource[] toURIs(String[] s) {
        if (s == null) {
            return null;
        }
        if (s.length == 0) {
            return new Resource[0];
        }
        Resource[] uris = new Resource[s.length];
        for (int i = 0; i < s.length; ++i) {
            uris[i] = new URIImpl(s[i]);
        }
        return uris;
    }

    protected Map<String, Value> parseBindings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Enumeration<String> parameterNames = req.getParameterNames();
        StringBuilder sb = new StringBuilder();
        HashMap<String, Value> result = new HashMap<String, Value>();
        while (parameterNames.hasMoreElements()) {
            String param = parameterNames.nextElement();
            if (!param.startsWith("$")) continue;
            String name = param.substring(1);
            String valueStr = req.getParameter(param);
            if (valueStr == null || valueStr.isEmpty()) {
                sb.append("Invalid binding ").append(name).append(" with no value ").append("\n");
                continue;
            }
            try {
                Value value = EncodeDecodeValue.decodeValue(valueStr);
                result.put(name, value);
            }
            catch (Exception e) {
                sb.append("Invalid binding ").append(name).append(" with value ").append(valueStr).append(": ").append(e.getMessage()).append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.append("Values should follow N-Triples representation (quoted literals or URIs)");
            BigdataRDFServlet.buildAndCommitResponse(resp, 400, "text/plain", sb.toString(), new NV[0]);
            return null;
        }
        return result;
    }
}

