/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.ha.HAStatusEnum;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.sail.webapp.SparqlEndpointConfig;
import com.bigdata.rdf.sail.webapp.client.EncodeDecodeValue;
import com.bigdata.rdf.sail.webapp.client.IMimeTypes;
import com.bigdata.rdf.task.AbstractApiTask;
import com.bigdata.util.NV;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;

public abstract class BigdataServlet
extends HttpServlet
implements IMimeTypes {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(BigdataServlet.class);
    public static final transient String ATTRIBUTE_RDF_CONTEXT = BigdataRDFContext.class.getName();
    static final transient String ATTRIBUTE_INDEX_MANAGER = IIndexManager.class.getName();
    static final String ATTRIBUTE_LBS_PREFIX = "com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.prefix";
    static final String ATTRIBUTE_LBS_INSTANCES = "com.bigdata.rdf.sail.webapp.HALoadBalancerServlet.instances";
    protected static final String charset = "UTF-8";
    protected static final transient String GET = "GET";
    protected static final transient String POST = "POST";
    protected static final transient String PUT = "PUT";
    protected static final transient String DELETE = "DELETE";
    public static final String HTTP_HEADER_BIGDATA_READ_ONLY = "X-BIGDATA-READ-ONLY";
    public static final transient int HTTP_OK = 200;
    public static final transient int HTTP_NOTFOUND = 404;
    public static final transient int HTTP_BADREQUEST = 400;
    public static final transient int HTTP_METHOD_NOT_ALLOWED = 405;
    public static final transient int HTTP_INTERNALERROR = 500;
    public static final transient int HTTP_NOTIMPLEMENTED = 501;
    private static final Resource[] EMPTY_RESOURCE_ARRAY = new Resource[0];

    static <T> T getRequiredServletContextAttribute(ServletContext servletContext, String name) {
        if (servletContext == null) {
            throw new IllegalArgumentException();
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Object v = servletContext.getAttribute(name);
        if (v == null) {
            throw new RuntimeException("Not set: " + name);
        }
        return (T)v;
    }

    static final SparqlEndpointConfig getConfig(ServletContext servletContext) {
        return BigdataServlet.getBigdataRDFContext(servletContext).getConfig();
    }

    protected final BigdataRDFContext getBigdataRDFContext() {
        return BigdataServlet.getBigdataRDFContext(this.getServletContext());
    }

    static final BigdataRDFContext getBigdataRDFContext(ServletContext servletContext) {
        return (BigdataRDFContext)BigdataServlet.getRequiredServletContextAttribute(servletContext, ATTRIBUTE_RDF_CONTEXT);
    }

    protected IIndexManager getIndexManager() {
        return BigdataServlet.getIndexManager(this.getServletContext());
    }

    public static IIndexManager getIndexManager(ServletContext servletContext) {
        return (IIndexManager)BigdataServlet.getRequiredServletContextAttribute(servletContext, ATTRIBUTE_INDEX_MANAGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> FutureTask<T> submitApiTask(AbstractRestApiTask<T> task) throws DatasetNotFoundException, InterruptedException, ExecutionException, IOException, TimeoutException {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        IIndexManager indexManager = this.getIndexManager();
        BigdataRDFContext context = this.getBigdataRDFContext();
        try {
            FutureTask<T> ft = AbstractApiTask.submitApiTask(indexManager, task);
            context.addTask(task, ft);
            long queryTimeout = BigdataRDFContext.getQueryTimeout(task.req, context.getConfig().queryTimeout);
            if (queryTimeout > 0L) {
                ft.get(queryTimeout, TimeUnit.MILLISECONDS);
            } else {
                ft.get();
            }
            task.flushAndClose();
            FutureTask<T> futureTask = ft;
            return futureTask;
        }
        finally {
            context.removeTask(task.uuid);
        }
    }

    static HAStatusEnum getHAStatus(IIndexManager indexManager) {
        if (indexManager == null) {
            throw new IllegalArgumentException();
        }
        if (indexManager instanceof AbstractJournal) {
            return ((AbstractJournal)indexManager).getHAStatus();
        }
        return null;
    }

    static boolean isWritable(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getHeader(HTTP_HEADER_BIGDATA_READ_ONLY) != null || BigdataServlet.getConfig((ServletContext)servletContext).readOnly) {
            BigdataServlet.buildAndCommitResponse(resp, 405, "text/plain", "Not writable.", new NV[0]);
            return false;
        }
        HAStatusEnum haStatus = BigdataServlet.getHAStatus(BigdataServlet.getIndexManager(servletContext));
        if (haStatus == null) {
            return true;
        }
        switch (haStatus) {
            case Leader: {
                return true;
            }
        }
        log.warn(haStatus.name());
        BigdataServlet.buildAndCommitResponse(resp, 405, "text/plain", haStatus.name(), new NV[0]);
        return false;
    }

    static boolean isReadable(ServletContext ctx, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HAStatusEnum haStatus = BigdataServlet.getHAStatus(BigdataServlet.getIndexManager(ctx));
        if (haStatus == null) {
            return true;
        }
        switch (haStatus) {
            case Leader: 
            case Follower: {
                return true;
            }
        }
        log.warn(haStatus.name());
        BigdataServlet.buildAndCommitResponse(resp, 405, "text/plain", haStatus.name(), new NV[0]);
        return false;
    }

    public static String[] getServiceURIs(ServletContext servletContext, HttpServletRequest req) {
        LinkedList<String> serviceURIs = new LinkedList<String>();
        StringBuffer sb = req.getRequestURL();
        int indexOf = sb.indexOf("?");
        String uri = indexOf == -1 ? sb.toString() : sb.substring(0, indexOf);
        serviceURIs.add(uri);
        String prefix = (String)servletContext.getAttribute(ATTRIBUTE_LBS_PREFIX);
        if (prefix != null) {
            int doubleSlash = uri.indexOf("//");
            int nextSlash = uri.indexOf(47, doubleSlash + 2);
            String contextPath = servletContext.getContextPath();
            int endContextPath = nextSlash + contextPath.length();
            String baseURL = uri.substring(0, nextSlash);
            String s = baseURL + prefix + (prefix.endsWith("/") ? "" : "/") + uri.substring(endContextPath + 1);
            serviceURIs.add(s);
        }
        return serviceURIs.toArray(new String[serviceURIs.size()]);
    }

    public static void buildAndCommitResponse(HttpServletResponse resp, int status, String mimeType, String content, NV ... headers) throws IOException {
        resp.setStatus(status);
        resp.setContentType(mimeType);
        for (NV nv : headers) {
            resp.setHeader(nv.getName(), nv.getValue());
        }
        PrintWriter w = resp.getWriter();
        if (content != null) {
            ((Writer)w).write(content);
        }
        ((Writer)w).flush();
    }

    protected boolean getBooleanValue(HttpServletRequest req, String name, boolean defaultValue) {
        String s = req.getParameter(name);
        if (s == null) {
            return defaultValue;
        }
        boolean b = Boolean.valueOf(s);
        return b;
    }

    protected static Resource[] decodeContexts(HttpServletRequest req, String name) {
        String[] values = req.getParameterValues(name);
        if (values == null) {
            return EMPTY_RESOURCE_ARRAY;
        }
        Resource[] contexts = EncodeDecodeValue.decodeContexts(values);
        return contexts;
    }

    protected static String readFully(Reader reader) throws IOException {
        int numChars;
        char[] arr = new char[8192];
        StringBuffer buf = new StringBuffer();
        while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
            buf.append(arr, 0, numChars);
        }
        return buf.toString();
    }
}

