/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.format.CounterSetFormat;
import com.bigdata.counters.query.CounterSetSelector;
import com.bigdata.counters.query.URLQueryModel;
import com.bigdata.counters.render.IRenderer;
import com.bigdata.counters.render.RendererFactory;
import com.bigdata.journal.IIndexManager;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.ConnegUtil;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.IService;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CountersServlet
extends BigdataServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(CountersServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            IService service = null;
            IIndexManager indexManager = this.getIndexManager();
            if (indexManager instanceof IBigdataFederation) {
                ((IBigdataFederation)indexManager).reattachDynamicCounters();
            }
            CounterSet counterSet = indexManager.getCounters();
            CounterSetSelector counterSelector = new CounterSetSelector(counterSet);
            String acceptStr = req.getHeader("Accept");
            ConnegUtil util = new ConnegUtil(acceptStr);
            CounterSetFormat format = util.getCounterSetFormat(CounterSetFormat.HTML);
            String mimeType = format.getDefaultMIMEType();
            if (log.isDebugEnabled()) {
                log.debug("\nAccept=" + acceptStr + ",\nformat=" + format + ", mimeType=" + mimeType);
            }
            URLQueryModel model = URLQueryModel.getInstance(service, req, resp);
            if (log.isDebugEnabled()) {
                log.debug("\nmodel=" + model);
            }
            IRenderer renderer = RendererFactory.get(model, counterSelector, mimeType);
            if (log.isDebugEnabled()) {
                log.debug("\nrenderer=" + renderer);
            }
            resp.setStatus(200);
            resp.setContentType(mimeType);
            if (format.hasCharset()) {
                resp.setCharacterEncoding(format.getCharset().name());
            }
            resp.addHeader("Cache-Control", "max-age=60, must-revalidate, public");
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8");
            renderer.render(w);
            w.flush();
            if (log.isTraceEnabled()) {
                log.trace("done");
            }
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, "");
        }
    }
}

