/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.inf.ClosureStats;
import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.properties.PropertiesParser;
import com.bigdata.rdf.properties.PropertiesParserFactory;
import com.bigdata.rdf.properties.PropertiesParserRegistry;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.RESTServlet;
import com.bigdata.rdf.sail.webapp.RestApiCreateKBTask;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.store.DataLoader;
import com.bigdata.util.NV;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.rio.RDFFormat;

public class DataLoaderServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(DataLoaderServlet.class);
    private RESTServlet m_restServlet;

    @Override
    public void init() throws ServletException {
        super.init();
        this.m_restServlet = new RESTServlet();
        this.m_restServlet.init(this.getServletConfig());
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getRequestURI().endsWith("/dataloader")) {
            if (log.isDebugEnabled()) {
                log.debug("");
            }
            this.doBulkLoad(req, resp);
            return;
        }
        this.m_restServlet.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBulkLoad(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PropertiesParserFactory parserFactory;
        PropertiesFormat format;
        if (!DataLoaderServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info("Request body: " + contentType);
        }
        if ((format = PropertiesFormat.forMIMEType(contentType)) == null) {
            DataLoaderServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as Properties: " + contentType, new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Format=" + format);
        }
        if ((parserFactory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get(format)) == null) {
            DataLoaderServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + format, new NV[0]);
            return;
        }
        PropertiesParser parser = parserFactory.getParser();
        Properties props = parser.parse(req.getInputStream());
        String namespace = props.getProperty("namespace", "kb");
        String fileOrDirs = props.getProperty("fileOrDirs");
        if (fileOrDirs == null) {
            throw new RuntimeException("fileOrDirs is required for the DataLoader");
        }
        String propertyFile = props.getProperty("propertyFile");
        if (propertyFile == null) {
            throw new RuntimeException("propertyFile is required for the DataLoader");
        }
        AbstractTripleStore kb = (AbstractTripleStore)this.getBigdataRDFContext().getIndexManager().getResourceLocator().locate(namespace, 0L);
        if (kb == null) {
            Properties kbProps = new Properties();
            try (FileInputStream is = new FileInputStream(propertyFile);){
                kbProps.load(is);
            }
            try {
                this.submitApiTask(new RestApiCreateKBTask(req, resp, namespace, kbProps)).get();
            }
            catch (Throwable t) {
                BigdataRDFServlet.launderThrowable(t, resp, "DATALOADER-SERVLET: Exception creating " + namespace + " with properties: " + propertyFile);
            }
            if (log.isInfoEnabled()) {
                log.info("Created namespace:  " + namespace);
            }
        }
        try {
            this.submitApiTask(new DataLoaderTask(req, resp, namespace, 0L, props)).get();
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, "DATALOADER-SERVLET: " + namespace);
        }
        DataLoaderServlet.buildAndCommitResponse(resp, 200, "text/plain", "DATALOADER-SERVLET: Loaded " + namespace + " with properties: " + propertyFile, new NV[0]);
    }

    private static boolean getBooleanProperty(Properties props, String property, boolean defaultValue) {
        String propVal = props.getProperty(property);
        if (propVal != null) {
            boolean retVal = Boolean.parseBoolean(propVal);
            return retVal;
        }
        return defaultValue;
    }

    private static int getIntProperty(Properties props, String property, int defaultValue) {
        String propVal = props.getProperty(property);
        if (propVal != null) {
            int retVal = Integer.parseInt(propVal);
            return retVal;
        }
        return defaultValue;
    }

    private static class DataLoaderTask
    extends AbstractRestApiTask<Void> {
        private final String namespace;
        private final Properties props;

        public DataLoaderTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, Properties props) {
            super(req, resp, namespace, timestamp);
            this.namespace = namespace;
            this.props = props;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            RDFFormat rdfFormat = RDFFormat.valueOf(this.props.getProperty("format", "rdf/xml"));
            String baseURI = this.props.getProperty("baseURI");
            String defaultGraph = this.props.getProperty("defaultGraph");
            boolean quiet = DataLoaderServlet.getBooleanProperty(this.props, "quiet", true);
            int verbose = DataLoaderServlet.getIntProperty(this.props, "verbose", 0);
            boolean closure = DataLoaderServlet.getBooleanProperty(this.props, "closure", false);
            boolean durableQueues = DataLoaderServlet.getBooleanProperty(this.props, "durableQueues", true);
            String fileOrDirs = this.props.getProperty("fileOrDirs");
            String propertyFile = this.props.getProperty("propertyFile");
            if (log.isInfoEnabled()) {
                log.info("DataLoader called ( rdfFormat = " + rdfFormat + " ; baseURI = " + baseURI + " ; defaultGraph = " + defaultGraph + " ; quiet = " + quiet + " ; verbose = " + verbose + " ; " + "durableQueues = " + durableQueues + " ; namespace = " + this.namespace + "propertyFile = " + propertyFile + " ; fileOrDirs = " + fileOrDirs + " )");
            }
            Properties properties = DataLoader.processProperties(propertyFile, quiet, verbose, durableQueues);
            long begin = System.currentTimeMillis();
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getConnection();
                AtomicLong nmodified = new AtomicLong(0L);
                AbstractTripleStore kb = conn.getSailConnection().getTripleStore();
                DataLoader dataLoader = new DataLoader(properties, kb);
                DataLoader.MyLoadStats totals = dataLoader.newLoadStats();
                String[] fileToLoad = fileOrDirs.split(",");
                for (int i = 0; i < fileToLoad.length; ++i) {
                    File nextFile = new File(fileToLoad[i]);
                    if (!nextFile.exists()) {
                        if (!log.isInfoEnabled()) continue;
                        log.info(nextFile.getName() + " does not exist.  Skipping.");
                        continue;
                    }
                    if (nextFile.isHidden()) {
                        if (!log.isInfoEnabled()) continue;
                        log.info(nextFile.getName() + " is hidden.  Skipping.");
                        continue;
                    }
                    dataLoader.loadFiles(totals, 0, nextFile, baseURI, rdfFormat, defaultGraph, DataLoader.getFilenameFilter(), true);
                }
                dataLoader.endSource();
                if (dataLoader.getClosureEnum() == DataLoader.ClosureEnum.None && closure) {
                    if (verbose > 0) {
                        dataLoader.logCounters(dataLoader.getDatabase());
                    }
                    if (log.isInfoEnabled()) {
                        log.info("Computing closure.");
                    }
                    ClosureStats stats = dataLoader.doClosure();
                    if (log.isInfoEnabled()) {
                        log.info("Closure: " + stats.toString());
                    }
                }
                conn.commit();
                success = true;
                totals.commit();
                if (verbose > 1) {
                    dataLoader.logCounters(dataLoader.getDatabase());
                }
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }
    }
}

