/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.HttpOperationException;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpUpdate;
import com.bigdata.util.NV;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.sail.SailException;

public class InsertServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(InsertServlet.class);

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!InsertServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        if (req.getParameter("uri") != null) {
            this.doPostWithURIs(req, resp);
            return;
        }
        this.doPostWithBody(req, resp);
    }

    private void doPostWithBody(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object[] defaultContext;
        RDFParserFactory rdfParserFactory;
        String mimeTypeStr;
        RDFFormat format;
        String baseURI = req.getRequestURL().toString();
        String contentType = req.getContentType();
        if (contentType == null) {
            InsertServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not specified.", new NV[0]);
        }
        if (log.isInfoEnabled()) {
            log.info("Request body: " + contentType);
        }
        if ((format = RDFFormat.forMIMEType(mimeTypeStr = new MiniMime(contentType).getMimeType())) == null) {
            InsertServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as RDF: " + contentType, new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("RDFFormat=" + format);
        }
        if ((rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get(format)) == null) {
            InsertServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + format, new NV[0]);
            return;
        }
        String[] s = req.getParameterValues("context-uri");
        if (s != null && s.length > 0) {
            try {
                defaultContext = InsertServlet.toURIs(s);
            }
            catch (IllegalArgumentException ex) {
                InsertServlet.buildAndCommitResponse(resp, 500, "text/plain", ex.getLocalizedMessage(), new NV[0]);
                return;
            }
        } else {
            defaultContext = new Resource[]{};
        }
        try {
            this.submitApiTask(new InsertWithBodyTask(req, resp, this.getNamespace(req), 0L, baseURI, (Resource[])defaultContext, rdfParserFactory)).get();
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, "INSERT-WITH-BODY: baseURI=" + baseURI + ", Content-Type=" + contentType + ", " + "context-uri" + "=" + Arrays.toString(defaultContext));
        }
    }

    private void doPostWithURIs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Object[] defaultContext;
        String namespace = this.getNamespace(req);
        Object[] uris = req.getParameterValues("uri");
        if (uris == null || uris.length == 0) {
            InsertServlet.buildAndCommitResponse(resp, 400, "text/plain", "Parameter must be specified one or more times: 'uri'", new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("URIs: " + Arrays.toString(uris));
        }
        Vector<URL> urls = new Vector<URL>(uris.length);
        for (Object uri : uris) {
            urls.add(new URL((String)uri));
        }
        String[] s = req.getParameterValues("context-uri");
        if (s != null && s.length > 0) {
            try {
                defaultContext = InsertServlet.toURIs(s);
            }
            catch (IllegalArgumentException ex) {
                InsertServlet.buildAndCommitResponse(resp, 500, "text/plain", ex.getLocalizedMessage(), new NV[0]);
                return;
            }
        } else {
            defaultContext = new Resource[]{};
        }
        try {
            this.submitApiTask(new InsertWithURLsTask(req, resp, namespace, 0L, (Resource[])defaultContext, urls)).get();
        }
        catch (Throwable t) {
            InsertServlet.launderThrowable(t, resp, "uri=" + urls + ", " + "context-uri" + "=" + Arrays.toString(defaultContext));
        }
    }

    static class AddStatementHandler
    extends RDFHandlerBase {
        private final BigdataSail.BigdataSailConnection conn;
        private final AtomicLong nmodified;
        private final Resource[] defaultContext;

        public AddStatementHandler(BigdataSail.BigdataSailConnection conn, AtomicLong nmodified, Resource ... defaultContext) {
            this.conn = conn;
            this.nmodified = nmodified;
            boolean quads = conn.getTripleStore().isQuads();
            this.defaultContext = quads && defaultContext != null ? defaultContext : new Resource[0];
        }

        @Override
        public void handleStatement(Statement stmt) throws RDFHandlerException {
            Resource[] resourceArray;
            if (stmt.getContext() == null) {
                resourceArray = this.defaultContext;
            } else {
                Resource[] resourceArray2 = new Resource[1];
                resourceArray = resourceArray2;
                resourceArray2[0] = stmt.getContext();
            }
            Resource[] c = resourceArray;
            try {
                this.conn.addStatement(stmt.getSubject(), stmt.getPredicate(), stmt.getObject(), c);
            }
            catch (SailException e) {
                throw new RDFHandlerException(e);
            }
            if (c.length >= 2) {
                this.nmodified.addAndGet(c.length);
            } else {
                this.nmodified.incrementAndGet();
            }
        }
    }

    private static class InsertWithURLsTask
    extends AbstractRestApiTask<Void> {
        private final Vector<URL> urls;
        private final Resource[] defaultContext;

        public InsertWithURLsTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, Resource[] defaultContext, Vector<URL> urls) {
            super(req, resp, namespace, timestamp);
            this.urls = urls;
            this.defaultContext = defaultContext;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getConnection();
                AtomicLong nmodified = new AtomicLong(0L);
                for (URL url : this.urls) {
                    Resource[] resourceArray;
                    if (this.defaultContext.length == 0) {
                        Resource[] resourceArray2 = new Resource[1];
                        resourceArray = resourceArray2;
                        resourceArray2[0] = new URIImpl(url.toExternalForm());
                    } else {
                        resourceArray = this.defaultContext;
                    }
                    Resource[] defactoContext = resourceArray;
                    URLConnection hconn = null;
                    try {
                        hconn = url.openConnection();
                        if (hconn instanceof HttpURLConnection) {
                            ((HttpURLConnection)hconn).setRequestMethod("GET");
                        }
                        hconn.setDoInput(true);
                        hconn.setDoOutput(false);
                        hconn.setReadTimeout(0);
                        String contentType = hconn.getContentType();
                        RDFFormat format = RDFFormat.forMIMEType(new MiniMime(contentType).getMimeType());
                        String fileName = url.getPath();
                        if (format == null) {
                            format = AST2BOpUpdate.rdfFormatForFile(fileName);
                        }
                        if (format == null) {
                            throw new HttpOperationException(400, "text/plain", "Content-Type not recognized as RDF: " + contentType);
                        }
                        RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get(format);
                        if (rdfParserFactory == null) {
                            throw new HttpOperationException(500, "text/plain", "Parser not found: Content-Type=" + contentType);
                        }
                        RDFParser rdfParser = rdfParserFactory.getParser();
                        rdfParser.setValueFactory(conn.getTripleStore().getValueFactory());
                        rdfParser.setVerifyData(true);
                        rdfParser.setStopAtFirstError(true);
                        rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                        rdfParser.setRDFHandler(new AddStatementHandler(conn.getSailConnection(), nmodified, defactoContext));
                        InputStream is = hconn.getInputStream();
                        if (fileName.endsWith(".gz")) {
                            is = new GZIPInputStream(hconn.getInputStream());
                        }
                        rdfParser.parse(is, url.toExternalForm());
                    }
                    finally {
                        if (!(hconn instanceof HttpURLConnection)) continue;
                        ((HttpURLConnection)hconn).disconnect();
                    }
                }
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }
    }

    private static class InsertWithBodyTask
    extends AbstractRestApiTask<Void> {
        private final String baseURI;
        private final Resource[] defaultContext;
        private final RDFParserFactory rdfParserFactory;

        public InsertWithBodyTask(HttpServletRequest req, HttpServletResponse resp, String namespace, long timestamp, String baseURI, Resource[] defaultContext, RDFParserFactory rdfParserFactory) {
            super(req, resp, namespace, timestamp);
            this.baseURI = baseURI;
            this.defaultContext = defaultContext;
            this.rdfParserFactory = rdfParserFactory;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            long begin = System.currentTimeMillis();
            AtomicLong nmodified = new AtomicLong(0L);
            BigdataSailRepositoryConnection conn = null;
            boolean success = false;
            try {
                conn = this.getConnection();
                RDFParser rdfParser = this.rdfParserFactory.getParser();
                rdfParser.setValueFactory(conn.getTripleStore().getValueFactory());
                rdfParser.setVerifyData(true);
                rdfParser.setStopAtFirstError(true);
                rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
                rdfParser.setRDFHandler(new AddStatementHandler(conn.getSailConnection(), nmodified, this.defaultContext));
                rdfParser.parse(this.req.getInputStream(), this.baseURI);
                conn.commit();
                success = true;
                long elapsed = System.currentTimeMillis() - begin;
                this.reportModifiedCount(nmodified.get(), elapsed);
                Void void_ = null;
                return void_;
            }
            finally {
                if (conn != null) {
                    if (!success) {
                        conn.rollback();
                    }
                    conn.close();
                }
            }
        }
    }
}

