/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.Banner;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.sail.webapp.NanoSparqlServer;
import java.util.LinkedHashMap;
import org.eclipse.jetty.server.Server;

public class StandaloneNanoSparqlServer
extends NanoSparqlServer {
    public static void main(String[] args) throws Exception {
        String arg;
        Banner.banner();
        int port = -1;
        String namespace = "kb";
        int queryThreadPoolSize = 16;
        boolean forceOverflow = false;
        Long readLock = null;
        String jettyXml = System.getProperty("jettyXml", "jetty.xml");
        String propertyFile = System.getProperty("bigdata.propertyFile", "RWStore.properties");
        String portStr = System.getProperty("jetty.port", Integer.toString(9999));
        port = Integer.parseInt(portStr);
        for (int i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            String s;
            if (arg.equals("-forceOverflow")) {
                forceOverflow = true;
                continue;
            }
            if (arg.equals("-nthreads")) {
                if ((queryThreadPoolSize = Integer.valueOf(s = args[++i]).intValue()) >= 0) continue;
                StandaloneNanoSparqlServer.usage(1, "-nthreads must be non-negative, not: " + s);
                continue;
            }
            if (arg.equals("-readLock")) {
                if ((readLock = Long.valueOf(s = args[++i])) == -1L || TimestampUtility.isCommitTime(readLock)) continue;
                StandaloneNanoSparqlServer.usage(1, "Read lock must be commit time or -1 (MINUS ONE) to assert a read lock on the last commit time: " + readLock);
                continue;
            }
            if (arg.equals("-jettyXml")) {
                jettyXml = args[++i];
                continue;
            }
            StandaloneNanoSparqlServer.usage(1, "Unknown argument: " + arg);
        }
        LinkedHashMap<String, String> initParams = new LinkedHashMap<String, String>();
        initParams.put("propertyFile", propertyFile);
        initParams.put("namespace", namespace);
        initParams.put("queryThreadPoolSize", Integer.toString(queryThreadPoolSize));
        initParams.put("forceOverflow", Boolean.toString(forceOverflow));
        if (readLock != null) {
            initParams.put("readLock", Long.toString(readLock));
        }
        System.setProperty("jetty.home", jettyXml.getClass().getResource("/war").toExternalForm());
        Server server = StandaloneNanoSparqlServer.newInstance(port, jettyXml, null, initParams);
        StandaloneNanoSparqlServer.awaitServerStart(server);
        System.out.println("\n\nWelcome to the Blazegraph(tm) Database.\n");
        System.out.println("Go to http://" + StandaloneNanoSparqlServer.getHost() + ":" + port + "/" + "blazegraph" + "/ to get started.");
        server.join();
    }
}

