/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.util.NV;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;
import org.openrdf.rio.helpers.StatementCollector;

public class WorkbenchServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(WorkbenchServlet.class);
    static final transient String ATTR_WORKBENCH = "workbench";
    static final transient String ATTR_CONVERT = "convert";

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(ATTR_CONVERT) != null) {
            this.doConvert(req, resp);
        }
    }

    private void doConvert(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RDFFormat requestBodyFormat;
        String baseURI = req.getRequestURL().toString();
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info("Request body: " + contentType);
        }
        if ((requestBodyFormat = RDFFormat.forMIMEType(new MiniMime(contentType).getMimeType())) == null) {
            WorkbenchServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as RDF: " + contentType, new NV[0]);
            return;
        }
        RDFParserFactory rdfParserFactory = (RDFParserFactory)RDFParserRegistry.getInstance().get(requestBodyFormat);
        if (rdfParserFactory == null) {
            WorkbenchServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + requestBodyFormat, new NV[0]);
            return;
        }
        LinkedHashModel g = new LinkedHashModel();
        try {
            RDFParser rdfParser = rdfParserFactory.getParser();
            rdfParser.setValueFactory(new ValueFactoryImpl());
            rdfParser.setVerifyData(true);
            rdfParser.setStopAtFirstError(true);
            rdfParser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            rdfParser.setRDFHandler(new StatementCollector(g));
            rdfParser.parse(req.getInputStream(), baseURI);
            WorkbenchServlet.sendGraph(req, resp, g);
        }
        catch (Throwable t) {
            BigdataRDFServlet.launderThrowable(t, resp, null);
        }
    }
}

