/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.parser.sparql.SPARQLUtil;

public class AST2SPARQLUtil {
    private final Map<String, String> prefixDecls;
    private final Map<String, String> namespaces;

    public AST2SPARQLUtil(Map<String, String> prefixDecls) {
        this.prefixDecls = prefixDecls;
        if (prefixDecls != null) {
            this.namespaces = new HashMap<String, String>();
            for (Map.Entry<String, String> e : prefixDecls.entrySet()) {
                this.namespaces.put(e.getValue(), e.getKey());
            }
        } else {
            this.namespaces = null;
        }
    }

    public String toExternal(Value val) {
        if (val instanceof URI) {
            return this.toExternal((URI)val);
        }
        if (val instanceof Literal) {
            return this.toExternal((Literal)val);
        }
        if (val instanceof BNode) {
            return this.toExternal((BNode)val);
        }
        throw new AssertionError();
    }

    public String toExternal(BNode bnd) {
        String id = bnd.stringValue();
        return "_:B" + id;
    }

    public String toExternal(URI uri) {
        String prefix;
        if (this.prefixDecls != null && (prefix = this.namespaces.get(uri.getNamespace())) != null) {
            return prefix + ":" + uri.getLocalName();
        }
        return "<" + uri.stringValue() + ">";
    }

    public String toExternal(Literal lit) {
        String label = lit.getLabel();
        String languageCode = lit.getLanguage();
        URI datatypeURI = lit.getDatatype();
        String datatypeStr = datatypeURI == null ? null : this.toExternal(datatypeURI);
        StringBuilder sb = new StringBuilder(label.length() + 2 + (languageCode != null ? languageCode.length() + 1 : 0) + (datatypeURI != null ? datatypeStr.length() + 2 : 0));
        sb.append('\"');
        sb.append(SPARQLUtil.encodeString(label));
        sb.append('\"');
        if (languageCode != null) {
            sb.append('@');
            sb.append(languageCode);
        }
        if (datatypeURI != null) {
            sb.append("^^");
            sb.append(datatypeStr);
        }
        return sb.toString();
    }
}

