/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openrdf.model.Statement;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.sparql.query.QueueCursor;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;

public class BackgroundGraphResult
implements GraphQueryResult,
Runnable,
RDFHandler {
    private volatile boolean closed;
    private Thread parserThread;
    private final RDFParser parser;
    private final Charset charset;
    private final InputStream in;
    private final String baseURI;
    private final CountDownLatch namespacesReady = new CountDownLatch(1);
    private final Map<String, String> namespaces = new ConcurrentHashMap<String, String>();
    private final QueueCursor<Statement> queue;
    private final Lock lock = new ReentrantLock();

    public BackgroundGraphResult(RDFParser parser, InputStream in, Charset charset, String baseURI) {
        this(new QueueCursor<Statement>(10), parser, in, charset, baseURI);
    }

    public BackgroundGraphResult(QueueCursor<Statement> queue, RDFParser parser, InputStream in, Charset charset, String baseURI) {
        this.queue = queue;
        this.parser = parser;
        this.in = in;
        this.charset = charset;
        this.baseURI = baseURI;
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        return this.queue.hasNext();
    }

    @Override
    public Statement next() throws QueryEvaluationException {
        return (Statement)this.queue.next();
    }

    @Override
    public void remove() throws QueryEvaluationException {
        this.queue.remove();
    }

    @Override
    public void close() throws QueryEvaluationException {
        this.closed = true;
        this.interruptParserThread();
        try {
            this.queue.close();
            this.in.close();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParserThread() {
        this.lock.lock();
        try {
            this.parserThread = Thread.currentThread();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptParserThread() {
        this.lock.lock();
        try {
            Thread t = this.parserThread;
            if (t != null) {
                t.interrupt();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearParserThread() {
        this.lock.lock();
        try {
            this.parserThread = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setParserThread();
        try {
            this.parser.setRDFHandler(this);
            if (this.charset == null) {
                this.parser.parse(this.in, this.baseURI);
            } else {
                this.parser.parse(new InputStreamReader(this.in, this.charset), this.baseURI);
            }
        }
        catch (RDFHandlerException e) {
        }
        catch (RDFParseException e) {
            this.queue.toss(e);
        }
        catch (IOException e) {
            this.queue.toss(e);
        }
        finally {
            this.clearParserThread();
            this.queue.done();
        }
    }

    @Override
    public void startRDF() throws RDFHandlerException {
    }

    @Override
    public Map<String, String> getNamespaces() {
        try {
            this.namespacesReady.await();
            return this.namespaces;
        }
        catch (InterruptedException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void handleComment(String comment) throws RDFHandlerException {
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.put(prefix, uri);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.namespacesReady.countDown();
        if (this.closed) {
            throw new RDFHandlerException("Result closed");
        }
        try {
            this.queue.put(st);
        }
        catch (InterruptedException e) {
            throw new RDFHandlerException(e);
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.namespacesReady.countDown();
    }
}

