/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.eclipse.jetty.client.api.ContentProvider;

public class EntityContentProvider
implements ContentProvider {
    private final HttpEntity m_entity;

    public EntityContentProvider(HttpEntity entity) {
        this.m_entity = entity;
    }

    @Override
    public long getLength() {
        return this.m_entity.getContentLength();
    }

    public String getContentType() {
        return this.m_entity.getContentType().getValue();
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        try {
            InputStream instr;
            if (this.m_entity.isStreaming()) {
                instr = this.m_entity.getContent();
            } else {
                ByteArrayOutputStream streambuf = new ByteArrayOutputStream();
                this.m_entity.writeTo(streambuf);
                instr = new ByteArrayInputStream(streambuf.toByteArray());
            }
            return new Iterator<ByteBuffer>(){
                boolean eof = false;
                int bufindex = 0;

                @Override
                public boolean hasNext() {
                    return !this.eof;
                }

                @Override
                public ByteBuffer next() {
                    byte[] buf = new byte[1024];
                    try {
                        int rdlen = instr.read(buf);
                        if (rdlen == -1) {
                            this.eof = true;
                            return ByteBuffer.wrap(buf, 0, 0);
                        }
                        return ByteBuffer.wrap(buf, 0, rdlen);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected", e);
        }
    }
}

