/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.util.BytesUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.B64Code;

public class MultipartContentProvider
implements AsyncContentProvider {
    final String m_boundary;
    final ByteArrayOutputStream m_data = new ByteArrayOutputStream();
    final Writer m_writer = new OutputStreamWriter(this.m_data);

    public MultipartContentProvider() {
        this.m_boundary = BytesUtil.toHexString(new int[]{new Random().nextInt()});
        try {
            this.m_writer.write("Content-Type: multipart/mixed; boundary=" + this.m_boundary + "\n");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new Iterator<ByteBuffer>(){
            ByteBuffer bb;
            {
                this.bb = ByteBuffer.wrap(MultipartContentProvider.this.m_data.toByteArray());
            }

            @Override
            public boolean hasNext() {
                return this.bb != null;
            }

            @Override
            public ByteBuffer next() {
                if (this.bb == null) {
                    throw new NoSuchElementException();
                }
                ByteBuffer ret = this.bb;
                this.bb = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public long getLength() {
        return this.m_data.size();
    }

    public void addPart(String name, ContentProvider part, String mimetype) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setListener(AsyncContentProvider.Listener arg0) {
        throw new UnsupportedOperationException("Async support not yet available");
    }

    public void addPart(String name, byte[] data, String mimetype) {
        try {
            this.m_writer.write("\n--" + this.m_boundary + "\n");
            this.m_writer.write("Content-Disposition: form-data;");
            this.m_writer.write(" name=\"" + name + "\"\n");
            this.m_writer.write("Content-Type: " + mimetype + "\n");
            this.m_writer.write("Content-Transfer-Encoding: base64\n\n");
            this.m_writer.write(B64Code.encode(data));
            this.m_writer.write("\n");
            this.m_writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected", e);
        }
    }
}

