/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepository;
import com.bigdata.rdf.sail.webapp.client.AST2SPARQLUtil;
import com.bigdata.rdf.sail.webapp.client.BooleanResult;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.ContextsResult;
import com.bigdata.rdf.sail.webapp.client.EncodeDecodeValue;
import com.bigdata.rdf.sail.webapp.client.IPreparedBooleanQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedGraphQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedOperation;
import com.bigdata.rdf.sail.webapp.client.IPreparedQuery;
import com.bigdata.rdf.sail.webapp.client.IPreparedQueryListener;
import com.bigdata.rdf.sail.webapp.client.IPreparedSparqlUpdate;
import com.bigdata.rdf.sail.webapp.client.IPreparedTupleQuery;
import com.bigdata.rdf.sail.webapp.client.IRemoteTx;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.rdf.sail.webapp.client.MutationResult;
import com.bigdata.rdf.sail.webapp.client.RangeCountResult;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryBase;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import com.bigdata.rdf.sail.webapp.client.StringUtil;
import info.aduna.io.IOUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.log4j.Logger;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.rio.RDFFormat;

public class RemoteRepository
extends RemoteRepositoryBase {
    private static final transient Logger log = Logger.getLogger(RemoteRepository.class);
    private final RemoteRepositoryManager mgr;
    private final String sparqlEndpointURL;
    private final IRemoteTx tx;

    public String getSparqlEndPoint() {
        return this.sparqlEndpointURL;
    }

    public String toString() {
        return super.toString() + "{sparqlEndpoint=" + this.sparqlEndpointURL + ", mgr=" + this.getRemoteRepositoryManager() + (this.tx == null ? "" : ", tx=" + this.tx) + "}";
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        return this.mgr;
    }

    RemoteRepository(RemoteRepositoryManager mgr, String sparqlEndpointURL, IRemoteTx tx) {
        if (mgr == null) {
            throw new IllegalArgumentException();
        }
        if (sparqlEndpointURL == null) {
            throw new IllegalArgumentException();
        }
        this.mgr = mgr;
        this.sparqlEndpointURL = sparqlEndpointURL;
        this.tx = tx;
    }

    public BigdataSailRemoteRepository getBigdataSailRemoteRepository() {
        return new BigdataSailRemoteRepository(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long postGraphML(String path) throws Exception {
        UUID uuid = UUID.randomUUID();
        ConnectOptions opts = this.mgr.newConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        opts.addRequestParam("blueprints");
        JettyResponseListener response = null;
        try {
            File file = new File(path);
            if (!file.exists()) {
                throw new RuntimeException("cannot locate file: " + file.getAbsolutePath());
            }
            byte[] data = IOUtil.readBytes(file);
            ByteArrayEntity entity = new ByteArrayEntity(data);
            entity.setContentType("application/graphml+xml");
            opts.entity = entity;
            opts.setAcceptHeader("application/xml");
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            MutationResult result = RemoteRepository.mutationResults(response);
            long l = result.mutationCount;
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public GraphQueryResult getServiceDescription() throws Exception {
        return this.getServiceDescription(UUID.randomUUID());
    }

    public GraphQueryResult getServiceDescription(UUID uuid) throws Exception {
        ConnectOptions opts = this.mgr.newConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        opts.method = "GET";
        opts.setAcceptHeader(ConnectOptions.DEFAULT_GRAPH_ACCEPT_HEADER);
        return this.mgr.graphResults(opts, uuid, null);
    }

    public IPreparedTupleQuery prepareTupleQuery(String query) throws Exception {
        return this.prepareTupleQuery(query, UUID.randomUUID());
    }

    public IPreparedTupleQuery prepareTupleQuery(String query, UUID uuid) throws Exception {
        return new TupleQuery(this.mgr.newQueryConnectOptions(this.sparqlEndpointURL, uuid, this.tx), uuid, query);
    }

    public IPreparedGraphQuery prepareGraphQuery(String query) throws Exception {
        return this.prepareGraphQuery(query, UUID.randomUUID());
    }

    public IPreparedGraphQuery prepareGraphQuery(String query, UUID uuid) throws Exception {
        return new GraphQuery(this.mgr.newQueryConnectOptions(this.sparqlEndpointURL, uuid, this.tx), uuid, query);
    }

    public IPreparedBooleanQuery prepareBooleanQuery(String query) throws Exception {
        return this.prepareBooleanQuery(query, UUID.randomUUID());
    }

    public IPreparedBooleanQuery prepareBooleanQuery(String query, UUID uuid) throws Exception {
        return new BooleanQuery(this.mgr.newQueryConnectOptions(this.sparqlEndpointURL, uuid, this.tx), uuid, query);
    }

    public IPreparedSparqlUpdate prepareUpdate(String updateStr) throws Exception {
        return this.prepareUpdate(updateStr, UUID.randomUUID());
    }

    public IPreparedSparqlUpdate prepareUpdate(String updateStr, UUID uuid) throws Exception {
        return new SparqlUpdate(this.mgr.newUpdateConnectOptions(this.sparqlEndpointURL, uuid, this.tx), uuid, updateStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphQueryResult getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws Exception {
        if (contexts == null) {
            throw new IllegalArgumentException();
        }
        UUID uuid = UUID.randomUUID();
        ConnectOptions opts = this.mgr.newQueryConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        opts.addRequestParam("GETSTMTS");
        opts.addRequestParam("includeInferred", Boolean.toString(includeInferred));
        if (subj != null) {
            opts.addRequestParam("s", EncodeDecodeValue.encodeValue(subj));
        }
        if (pred != null) {
            opts.addRequestParam("p", EncodeDecodeValue.encodeValue(pred));
        }
        if (obj != null) {
            opts.addRequestParam("o", EncodeDecodeValue.encodeValue(obj));
        }
        opts.addRequestParam("c", EncodeDecodeValue.encodeContexts(contexts));
        opts.setAcceptHeader(ConnectOptions.DEFAULT_GRAPH_ACCEPT_HEADER);
        JettyResponseListener resp = null;
        try {
            GraphQueryResult result;
            resp = this.doConnect(opts);
            RemoteRepository.checkResponseCode(resp);
            GraphQueryResult graphQueryResult = result = this.mgr.graphResults(opts, null, null);
            return graphQueryResult;
        }
        finally {
            if (resp != null) {
                resp.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStatement(Resource s, URI p, Value o, boolean includeInferred, Resource ... c) throws Exception {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        UUID uuid = UUID.randomUUID();
        ConnectOptions opts = this.mgr.newQueryConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        opts.addRequestParam("HASSTMT");
        opts.addRequestParam("includeInferred", Boolean.toString(includeInferred));
        if (s != null) {
            opts.addRequestParam("s", EncodeDecodeValue.encodeValue(s));
        }
        if (p != null) {
            opts.addRequestParam("p", EncodeDecodeValue.encodeValue(p));
        }
        if (o != null) {
            opts.addRequestParam("o", EncodeDecodeValue.encodeValue(o));
        }
        opts.addRequestParam("c", EncodeDecodeValue.encodeContexts(c));
        JettyResponseListener resp = null;
        try {
            opts.setAcceptHeader("application/xml");
            resp = this.doConnect(opts);
            RemoteRepository.checkResponseCode(resp);
            BooleanResult result = RemoteRepositoryManager.booleanResults(resp);
            boolean bl = result.result;
            return bl;
        }
        finally {
            if (resp != null) {
                resp.abort();
            }
        }
    }

    private String asConstOrVar(AST2SPARQLUtil util, String var, Value val) {
        if (val == null) {
            return var;
        }
        return util.toExternal(val);
    }

    public void cancel(UUID queryId) throws Exception {
        this.mgr.cancel(queryId);
    }

    public long rangeCount(Resource s, URI p, Value o, Resource ... c) throws Exception {
        return this.rangeCount(false, s, p, o, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long rangeCount(boolean exact, Resource s, URI p, Value o, Resource ... c) throws Exception {
        if (c == null) {
            throw new IllegalArgumentException();
        }
        UUID uuid = UUID.randomUUID();
        ConnectOptions opts = this.mgr.newQueryConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        opts.addRequestParam("ESTCARD");
        if (exact) {
            opts.addRequestParam("exact", "true");
        }
        if (s != null) {
            opts.addRequestParam("s", EncodeDecodeValue.encodeValue(s));
        }
        if (p != null) {
            opts.addRequestParam("p", EncodeDecodeValue.encodeValue(p));
        }
        if (o != null) {
            opts.addRequestParam("o", EncodeDecodeValue.encodeValue(o));
        }
        opts.addRequestParam("c", EncodeDecodeValue.encodeContexts(c));
        JettyResponseListener resp = null;
        try {
            opts.setAcceptHeader("application/xml");
            resp = this.doConnect(opts);
            RemoteRepository.checkResponseCode(resp);
            RangeCountResult result = RemoteRepository.rangeCountResults(resp);
            long l = result.rangeCount;
            return l;
        }
        finally {
            if (resp != null) {
                resp.abort();
            }
        }
    }

    public long size() throws Exception {
        return this.rangeCount(null, null, null, new Resource[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Resource> getContexts() throws Exception {
        UUID uuid = UUID.randomUUID();
        ConnectOptions opts = this.mgr.newQueryConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        opts.addRequestParam("CONTEXTS");
        JettyResponseListener resp = null;
        try {
            opts.setAcceptHeader("application/xml");
            resp = this.doConnect(opts);
            RemoteRepository.checkResponseCode(resp);
            ContextsResult result = RemoteRepository.contextsResults(resp);
            Collection<Resource> collection = result.contexts;
            return collection;
        }
        finally {
            if (resp != null) {
                resp.abort();
            }
        }
    }

    public long add(AddOp add) throws Exception {
        return this.add(add, UUID.randomUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long add(AddOp add, UUID uuid) throws Exception {
        if (add == null) {
            throw new IllegalArgumentException();
        }
        ConnectOptions opts = this.mgr.newUpdateConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        add.prepareForWire();
        if (add.format != null) {
            ByteArrayEntity entity = new ByteArrayEntity(add.data);
            entity.setContentType(add.format.getDefaultMIMEType());
            opts.entity = entity;
        }
        if (add.uris != null) {
            opts.addRequestParam("uri", add.uris.toArray(new String[0]));
        }
        if (add.context != null && add.context.length > 0) {
            opts.addRequestParam("context-uri", RemoteRepository.toStrings(add.context));
        }
        opts.setAcceptHeader("application/xml");
        JettyResponseListener response = null;
        boolean ok = false;
        try {
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            MutationResult result = RemoteRepository.mutationResults(response);
            ok = true;
            long l = result.mutationCount;
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
                if (!ok) {
                    try {
                        this.cancel(uuid);
                    }
                    catch (Exception ex) {
                        log.warn(ex);
                    }
                }
            }
        }
    }

    public long remove(RemoveOp remove) throws Exception {
        return this.remove(remove, UUID.randomUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long remove(RemoveOp remove, UUID uuid) throws Exception {
        if (remove == null) {
            throw new IllegalArgumentException();
        }
        ConnectOptions opts = this.mgr.newUpdateConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        remove.prepareForWire();
        if (remove.format != null) {
            opts.method = "POST";
            opts.addRequestParam("delete");
            ByteArrayEntity entity = new ByteArrayEntity(remove.data);
            entity.setContentType(remove.format.getDefaultMIMEType());
            opts.entity = entity;
            if (remove.context != null && remove.context.length > 0) {
                opts.addRequestParam("context-uri", RemoteRepository.toStrings(remove.context));
            }
        } else {
            opts.method = "DELETE";
            if (remove.query != null) {
                opts.addRequestParam("query", remove.query);
            }
            if (remove.s != null) {
                opts.addRequestParam("s", EncodeDecodeValue.encodeValue(remove.s));
            }
            if (remove.p != null) {
                opts.addRequestParam("p", EncodeDecodeValue.encodeValue(remove.p));
            }
            if (remove.o != null) {
                opts.addRequestParam("o", EncodeDecodeValue.encodeValue(remove.o));
            }
            if (remove.c != null) {
                opts.addRequestParam("c", EncodeDecodeValue.encodeContexts(remove.c));
            }
        }
        opts.setAcceptHeader("application/xml");
        JettyResponseListener response = null;
        boolean ok = false;
        try {
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            MutationResult result = RemoteRepository.mutationResults(response);
            ok = true;
            long l = result.mutationCount;
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
                if (!ok) {
                    try {
                        this.cancel(uuid);
                    }
                    catch (Exception ex) {
                        log.warn(ex);
                    }
                }
            }
        }
    }

    public long update(RemoveOp remove, AddOp add) throws Exception {
        return this.update(remove, add, UUID.randomUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long update(RemoveOp remove, AddOp add, UUID uuid) throws Exception {
        HttpEntity entity;
        if (remove == null) {
            throw new IllegalArgumentException();
        }
        if (add == null) {
            throw new IllegalArgumentException();
        }
        remove.prepareForWire();
        add.prepareForWire();
        ConnectOptions opts = this.mgr.newUpdateConnectOptions(this.sparqlEndpointURL, uuid, this.tx);
        if (remove.format != null) {
            opts.method = "POST";
            opts.addRequestParam("update");
            entity = new MultipartEntity();
            ((MultipartEntity)entity).addPart(new FormBodyPart("remove", new ByteArrayBody(remove.data, remove.format.getDefaultMIMEType(), "remove")));
            ((MultipartEntity)entity).addPart(new FormBodyPart("add", new ByteArrayBody(add.data, add.format.getDefaultMIMEType(), "add")));
            opts.entity = entity;
        } else {
            opts.method = "PUT";
            opts.addRequestParam("query", remove.query);
            entity = new ByteArrayEntity(add.data);
            ((AbstractHttpEntity)entity).setContentType(add.format.getDefaultMIMEType());
            opts.entity = entity;
        }
        if (add.context != null) {
            opts.addRequestParam("context-uri-insert", RemoteRepository.toStrings(add.context));
        }
        if (remove.context != null) {
            opts.addRequestParam("context-uri-delete", RemoteRepository.toStrings(remove.context));
        }
        opts.setAcceptHeader("application/xml");
        JettyResponseListener response = null;
        boolean ok = false;
        try {
            response = this.doConnect(opts);
            RemoteRepository.checkResponseCode(response);
            MutationResult result = RemoteRepository.mutationResults(response);
            ok = true;
            long l = result.mutationCount;
            return l;
        }
        finally {
            if (response != null) {
                response.abort();
                if (!ok) {
                    try {
                        this.cancel(uuid);
                    }
                    catch (Exception ex) {
                        log.warn(ex);
                    }
                }
            }
        }
    }

    private JettyResponseListener doConnect(ConnectOptions opts) throws Exception {
        return this.mgr.doConnect(opts);
    }

    public static class RemoveOp {
        private String query;
        private Iterable<? extends Statement> stmts;
        private Value s;
        private Value p;
        private Value o;
        private Resource[] c;
        private byte[] data;
        private File file;
        private RDFFormat format;
        private Resource[] context;

        public RemoveOp(String query) {
            this.query = query;
        }

        public RemoveOp(Iterable<? extends Statement> stmts) {
            this.stmts = stmts;
        }

        public RemoveOp(Resource s, URI p, Value o, Resource ... c) {
            if (c == null) {
                throw new IllegalArgumentException();
            }
            this.s = s;
            this.p = p;
            this.o = o;
            this.c = c;
        }

        public RemoveOp(File file, RDFFormat format) {
            this.file = file;
            this.format = format;
        }

        public RemoveOp(byte[] data, RDFFormat format) {
            this.data = data;
            this.format = format;
        }

        public void setContext(Resource ... context) {
            this.context = context;
        }

        private void prepareForWire() throws Exception {
            if (this.file != null) {
                this.data = IOUtil.readBytes(this.file);
            } else if (this.stmts != null) {
                this.format = RDFFormat.TRIG;
                this.data = RemoteRepositoryBase.serialize(this.stmts, this.format);
            }
        }
    }

    public static class AddOp {
        private List<String> uris;
        private Iterable<? extends Statement> stmts;
        private byte[] data;
        private File file;
        private InputStream is;
        private Reader reader;
        private RDFFormat format;
        private Resource[] context;

        public AddOp(String uri) {
            if (uri == null) {
                throw new IllegalArgumentException();
            }
            this.uris = Collections.singletonList(uri);
        }

        public AddOp(Collection<String> uris) {
            if (uris == null) {
                throw new IllegalArgumentException();
            }
            if (uris.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.uris = new LinkedList<String>(uris);
        }

        public AddOp(Iterable<? extends Statement> stmts) {
            this.stmts = stmts;
        }

        public AddOp(File file, RDFFormat format) {
            this.file = file;
            this.format = format;
        }

        public AddOp(InputStream is, RDFFormat format) {
            this.is = is;
            this.format = format;
        }

        public AddOp(Reader reader, RDFFormat format) {
            this.reader = reader;
            this.format = format;
        }

        public AddOp(byte[] data, RDFFormat format) {
            this.data = data;
            this.format = format;
        }

        public void setContext(Resource ... context) {
            this.context = context;
        }

        private void prepareForWire() throws Exception {
            if (this.file != null) {
                this.data = IOUtil.readBytes(this.file);
            } else if (this.is != null) {
                this.data = IOUtil.readBytes(this.is);
            } else if (this.reader != null) {
                this.data = IOUtil.readString(this.reader).getBytes();
            } else if (this.stmts != null) {
                this.format = RDFFormat.TRIG;
                this.data = RemoteRepositoryBase.serialize(this.stmts, this.format);
            }
        }
    }

    private final class SparqlUpdate
    extends QueryOrUpdate
    implements IPreparedSparqlUpdate {
        public SparqlUpdate(ConnectOptions opts, UUID uuid, String updateStr) {
            super(opts, uuid, updateStr, true);
        }

        @Override
        public void evaluate() throws Exception {
            this.evaluate(null);
        }

        @Override
        public void evaluate(IPreparedQueryListener listener) throws Exception {
            this.setupConnectOptions();
            RemoteRepository.this.mgr.sparqlUpdateResults(this.opts, this.getQueryId(), listener);
        }
    }

    private final class BooleanQuery
    extends QueryOrUpdate
    implements IPreparedBooleanQuery {
        public BooleanQuery(ConnectOptions opts, UUID id, String query) {
            super(opts, id, query);
        }

        @Override
        protected void setupConnectOptions() {
            super.setupConnectOptions();
            if (this.opts.getAcceptHeader() == null) {
                this.opts.setAcceptHeader(ConnectOptions.DEFAULT_BOOLEAN_ACCEPT_HEADER);
            }
        }

        @Override
        public boolean evaluate() throws Exception {
            return this.evaluate(null);
        }

        @Override
        public boolean evaluate(IPreparedQueryListener listener) throws Exception {
            this.setupConnectOptions();
            return RemoteRepository.this.mgr.booleanResults(this.opts, this.getQueryId(), listener);
        }
    }

    private final class GraphQuery
    extends QueryOrUpdate
    implements IPreparedGraphQuery {
        public GraphQuery(ConnectOptions opts, UUID id, String query) {
            super(opts, id, query);
        }

        @Override
        protected void setupConnectOptions() {
            super.setupConnectOptions();
            if (this.opts.getAcceptHeader() == null) {
                this.opts.setAcceptHeader(ConnectOptions.DEFAULT_GRAPH_ACCEPT_HEADER);
            }
        }

        @Override
        public GraphQueryResult evaluate() throws Exception {
            return this.evaluate(null);
        }

        @Override
        public GraphQueryResult evaluate(IPreparedQueryListener listener) throws Exception {
            this.setupConnectOptions();
            return RemoteRepository.this.mgr.graphResults(this.opts, this.getQueryId(), listener);
        }
    }

    private final class TupleQuery
    extends QueryOrUpdate
    implements IPreparedTupleQuery {
        public TupleQuery(ConnectOptions opts, UUID id, String query) {
            super(opts, id, query);
        }

        @Override
        protected void setupConnectOptions() {
            super.setupConnectOptions();
            if (this.opts.getAcceptHeader() == null) {
                this.opts.setAcceptHeader(ConnectOptions.DEFAULT_SOLUTIONS_ACCEPT_HEADER);
            }
        }

        @Override
        public TupleQueryResult evaluate() throws Exception {
            return this.evaluate(null);
        }

        @Override
        public TupleQueryResult evaluate(IPreparedQueryListener listener) throws Exception {
            this.setupConnectOptions();
            return RemoteRepository.this.mgr.tupleResults(this.opts, this.getQueryId(), listener);
        }
    }

    protected abstract class QueryOrUpdate
    implements IPreparedOperation,
    IPreparedQuery {
        protected final ConnectOptions opts;
        private final UUID uuid;
        protected final String query;
        private final boolean update;

        public QueryOrUpdate(ConnectOptions opts, UUID id, String query) {
            this(opts, id, query, false);
        }

        public QueryOrUpdate(ConnectOptions opts, UUID uuid, String query, boolean update) {
            if (opts == null) {
                throw new IllegalArgumentException();
            }
            if (query == null) {
                throw new IllegalArgumentException();
            }
            if (uuid == null) {
                throw new IllegalArgumentException();
            }
            this.opts = opts;
            this.uuid = uuid;
            this.query = query;
            this.update = update;
        }

        @Override
        public final UUID getQueryId() {
            return this.uuid;
        }

        @Override
        public final boolean isUpdate() {
            return this.update;
        }

        @Override
        public void addRequestParam(String name, String ... val) {
            this.opts.addRequestParam(name, val);
        }

        protected void setupConnectOptions() {
            this.opts.method = RemoteRepository.this.mgr.getQueryMethod();
            if (this.update) {
                this.opts.addRequestParam("update", this.query);
            } else {
                this.opts.addRequestParam("query", this.query);
            }
            UUID queryId = this.getQueryId();
            if (queryId != null) {
                this.opts.addRequestParam("queryId", queryId.toString());
            }
        }

        @Override
        public void setAcceptHeader(String value) {
            this.opts.setAcceptHeader(value);
        }

        @Override
        public void setHeader(String name, String value) {
            this.opts.setHeader(name, value);
        }

        @Override
        public void setMaxQueryMillis(long timeout) {
            this.opts.setHeader("X-BIGDATA-MAX-QUERY-MILLIS", Long.toString(timeout));
        }

        @Override
        public long getMaxQueryMillis() {
            String s = this.opts.getHeader("X-BIGDATA-MAX-QUERY-MILLIS");
            if (s == null) {
                return -1L;
            }
            return StringUtil.toLong(s);
        }

        @Override
        public String getHeader(String name) {
            return this.opts.getHeader(name);
        }
    }
}

