/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.sail.webapp.client.BooleanResult;
import com.bigdata.rdf.sail.webapp.client.ContextsResult;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.rdf.sail.webapp.client.MutationResult;
import com.bigdata.rdf.sail.webapp.client.RangeCountResult;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryDecls;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RDFWriterFactory;
import org.openrdf.rio.RDFWriterRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class RemoteRepositoryBase
extends RemoteRepositoryDecls {
    private static final transient Logger log = Logger.getLogger(RemoteRepositoryDecls.class);

    protected static final String getContextPath() {
        return "/bigdata";
    }

    public static JettyResponseListener checkResponseCode(JettyResponseListener responseListener) throws IOException {
        int rc = responseListener.getStatus();
        if (rc < 200 || rc >= 300) {
            throw new HttpException(rc, "Status Code=" + rc + ", Status Line=" + responseListener.getReason() + ", Response=" + responseListener.getResponseBody());
        }
        if (log.isDebugEnabled()) {
            log.debug("*** Response ***");
            log.debug("Status Line: " + responseListener.getReason());
        }
        return responseListener;
    }

    public static Graph asGraph(GraphQueryResult result) throws Exception {
        LinkedHashModel g = new LinkedHashModel();
        while (result.hasNext()) {
            g.add(result.next());
        }
        return g;
    }

    protected static byte[] serialize(Iterable<? extends Statement> stmts, RDFFormat format) throws Exception {
        RDFWriterFactory writerFactory = (RDFWriterFactory)RDFWriterRegistry.getInstance().get(format);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        RDFWriter writer = writerFactory.getWriter(baos);
        writer.startRDF();
        for (Statement statement : stmts) {
            writer.handleStatement(statement);
        }
        writer.endRDF();
        byte[] data = baos.toByteArray();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MutationResult mutationResults(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final AtomicLong mutationCount = new AtomicLong();
            final AtomicLong elapsedMillis = new AtomicLong();
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if (!"data".equals(qName)) {
                        throw new RuntimeException("Expecting: 'data', but have: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
                    }
                    mutationCount.set(Long.valueOf(attributes.getValue("modified")));
                    elapsedMillis.set(Long.valueOf(attributes.getValue("milliseconds")));
                }
            });
            MutationResult mutationResult = new MutationResult(mutationCount.get(), elapsedMillis.get());
            return mutationResult;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static BooleanResult booleanResults(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final AtomicBoolean result = new AtomicBoolean();
            final AtomicLong elapsedMillis = new AtomicLong();
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if (!"data".equals(qName)) {
                        throw new RuntimeException("Expecting: 'data', but have: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
                    }
                    result.set(Boolean.valueOf(attributes.getValue("result")));
                    elapsedMillis.set(Long.valueOf(attributes.getValue("milliseconds")));
                }
            });
            BooleanResult booleanResult = new BooleanResult(result.get(), elapsedMillis.get());
            return booleanResult;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RangeCountResult rangeCountResults(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final AtomicLong rangeCount = new AtomicLong();
            final AtomicLong elapsedMillis = new AtomicLong();
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if (!"data".equals(qName)) {
                        throw new RuntimeException("Expecting: 'data', but have: uri=" + uri + ", localName=" + localName + ", qName=" + qName);
                    }
                    rangeCount.set(Long.valueOf(attributes.getValue("rangeCount")));
                    elapsedMillis.set(Long.valueOf(attributes.getValue("milliseconds")));
                }
            });
            RangeCountResult rangeCountResult = new RangeCountResult(rangeCount.get(), elapsedMillis.get());
            return rangeCountResult;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ContextsResult contextsResults(JettyResponseListener response) throws Exception {
        try {
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new RuntimeException("Expecting Content-Type of application/xml, not " + contentType);
            }
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            final Collection<Resource> contexts = Collections.synchronizedCollection(new LinkedList());
            parser.parse(response.getInputStream(), (DefaultHandler)new DefaultHandler2(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    if ("context".equals(qName)) {
                        contexts.add(new URIImpl(attributes.getValue("uri")));
                    }
                }
            });
            ContextsResult contextsResult = new ContextsResult(contexts);
            return contextsResult;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    protected static String[] toStrings(Resource[] resources) {
        if (resources == null) {
            return null;
        }
        if (resources.length == 0) {
            return new String[0];
        }
        String[] uris = new String[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            uris[i] = resources[i].stringValue();
        }
        return uris;
    }
}

