/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.rdf.ServiceProviderHook;
import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.properties.PropertiesParser;
import com.bigdata.rdf.properties.PropertiesParserFactory;
import com.bigdata.rdf.properties.PropertiesParserRegistry;
import com.bigdata.rdf.properties.PropertiesWriter;
import com.bigdata.rdf.properties.PropertiesWriterFactory;
import com.bigdata.rdf.properties.PropertiesWriterRegistry;
import com.bigdata.rdf.sail.model.JsonHelper;
import com.bigdata.rdf.sail.model.RunningQuery;
import com.bigdata.rdf.sail.webapp.client.BackgroundGraphResult;
import com.bigdata.rdf.sail.webapp.client.BackgroundTupleResult;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.DaemonThreadFactory;
import com.bigdata.rdf.sail.webapp.client.EntityContentProvider;
import com.bigdata.rdf.sail.webapp.client.HttpClientConfigurator;
import com.bigdata.rdf.sail.webapp.client.HttpException;
import com.bigdata.rdf.sail.webapp.client.IPreparedQueryListener;
import com.bigdata.rdf.sail.webapp.client.IRemoteTx;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.rdf.sail.webapp.client.MiniMime;
import com.bigdata.rdf.sail.webapp.client.NoGPUAccelerationAvailable;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryBase;
import com.bigdata.rdf.sail.webapp.client.RemoteTransactionManager;
import com.bigdata.rdf.sail.webapp.client.StringUtil;
import com.bigdata.util.InnerCause;
import com.bigdata.util.PropertyUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpMethod;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.BooleanQueryResultFormat;
import org.openrdf.query.resultio.BooleanQueryResultParser;
import org.openrdf.query.resultio.BooleanQueryResultParserFactory;
import org.openrdf.query.resultio.BooleanQueryResultParserRegistry;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.query.resultio.TupleQueryResultParserFactory;
import org.openrdf.query.resultio.TupleQueryResultParserRegistry;
import org.openrdf.repository.sparql.query.InsertBindingSetCursor;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.RDFParserFactory;
import org.openrdf.rio.RDFParserRegistry;

public class RemoteRepositoryManager
extends RemoteRepositoryBase
implements AutoCloseable {
    private static final transient Logger log = Logger.getLogger(RemoteRepositoryManager.class);
    static final String EXCEPTION_MSG = "Class not found for service provider hook. Blazegraph specific parser extensions will not be available.";
    private final String baseServiceURL;
    protected final boolean useLBS;
    protected final HttpClient httpClient;
    private final HttpClient our_httpClient;
    protected final Executor executor;
    private final ExecutorService our_executor;
    private volatile int maxRequestURLLength;
    private volatile String queryMethod;
    private final RemoteTransactionManager transactionManager;
    private volatile boolean m_closed;
    private static String SHOW_QUERIES = "showQueries";
    private static final String COMPUTE_MODE = "computeMode";
    private static final String MAPGRAPH = "mapgraph";
    private static final String MAPGRAPH_RESET = "reset";
    private static final String MAPGRAPH_PUBLISH = "publish";
    private static final String MAPGRAPH_DROP = "drop";
    private static final String MAPGRAPH_CHECK_RUNTIME_AVAILABLE = "runtimeAvailable";
    private static final String CHECK_PUBLISHED = "checkPublished";

    public RemoteTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public String getBaseServiceURL() {
        return this.baseServiceURL;
    }

    public boolean getUseLBS() {
        return this.useLBS;
    }

    public int getMaxRequestURLLength() {
        return this.maxRequestURLLength;
    }

    public void setMaxRequestURLLength(int newVal) {
        if (newVal <= 0) {
            throw new IllegalArgumentException();
        }
        this.maxRequestURLLength = newVal;
    }

    public String getQueryMethod() {
        return this.queryMethod;
    }

    public void setQueryMethod(String method) {
        if (!"POST".equalsIgnoreCase(method) && !"GET".equalsIgnoreCase(method)) {
            throw new IllegalArgumentException();
        }
        this.queryMethod = method.toUpperCase();
    }

    public RemoteRepositoryManager() {
        this("http://localhost/no-service-URL");
    }

    public RemoteRepositoryManager(String serviceURL) {
        this(serviceURL, false);
    }

    public RemoteRepositoryManager(String serviceURL, boolean useLBS) {
        this(serviceURL, useLBS, null, null);
    }

    public RemoteRepositoryManager(String serviceURL, HttpClient httpClient, Executor executor) {
        this(serviceURL, false, httpClient, executor);
    }

    public RemoteRepositoryManager(String serviceURL, boolean useLBS, HttpClient httpClient, Executor executor) {
        block7: {
            this.m_closed = false;
            if (serviceURL == null) {
                throw new IllegalArgumentException();
            }
            this.baseServiceURL = serviceURL;
            this.useLBS = useLBS;
            if (httpClient == null) {
                this.httpClient = this.our_httpClient = HttpClientConfigurator.getInstance().newInstance();
            } else {
                this.httpClient = httpClient;
                this.our_httpClient = null;
            }
            if (executor == null) {
                this.our_executor = Executors.newCachedThreadPool(DaemonThreadFactory.defaultThreadFactory());
                this.executor = this.our_executor;
            } else {
                this.executor = executor;
                this.our_executor = null;
            }
            this.assertHttpClientRunning();
            this.transactionManager = new RemoteTransactionManager(this);
            this.setMaxRequestURLLength(Integer.parseInt(System.getProperty(MAX_REQUEST_URL_LENGTH, Integer.toString(1000))));
            this.setQueryMethod(System.getProperty(QUERY_METHOD, "POST"));
            try {
                ServiceProviderHook.forceLoad();
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError e) {
                if (!log.isInfoEnabled()) break block7;
                log.info(EXCEPTION_MSG);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws Exception {
        if (this.m_closed) {
            return;
        }
        if (this.our_httpClient != null) {
            if (this.our_httpClient instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.our_httpClient)).close();
            } else if (!this.our_httpClient.isStopping() && !this.our_httpClient.isStopped()) {
                this.our_httpClient.stop();
            }
        }
        if (this.our_executor != null) {
            this.our_executor.shutdownNow();
        }
        this.m_closed = true;
    }

    public String toString() {
        return super.toString() + "{baseServiceURL=" + this.baseServiceURL + ", useLBS=" + this.useLBS + "}";
    }

    protected String getRepositoryBaseURLForNamespace(String namespace) {
        return this.baseServiceURL + "/namespace/" + ConnectOptions.urlEncode(namespace);
    }

    private String getSparqlEndpointUrlForNamespaceOrDefault(String namespace) {
        return namespace == null ? this.baseServiceURL + "/sparql" : this.getRepositoryBaseURLForNamespace(namespace) + "/sparql";
    }

    public RemoteRepository getRepositoryForDefaultNamespace() {
        return this.getRepositoryForURL(this.baseServiceURL + "/sparql");
    }

    public RemoteRepository getRepositoryForNamespace(String namespace) {
        return this.getRepositoryForURL(this.getRepositoryBaseURLForNamespace(namespace) + "/sparql");
    }

    public RemoteRepository getRepositoryForURL(String sparqlEndpointURL) {
        return this.getRepositoryForURL(sparqlEndpointURL, null);
    }

    public RemoteRepository getRepositoryForURL(String sparqlEndpointURL, IRemoteTx tx) {
        return new RemoteRepository(this, sparqlEndpointURL, tx);
    }

    public GraphQueryResult getRepositoryDescriptions() throws Exception {
        return this.getRepositoryDescriptions(UUID.randomUUID());
    }

    public GraphQueryResult getRepositoryDescriptions(UUID uuid) throws Exception {
        ConnectOptions opts = this.newConnectOptions(this.baseServiceURL + "/namespace", uuid, null);
        opts.method = "GET";
        opts.setAcceptHeader(ConnectOptions.DEFAULT_GRAPH_ACCEPT_HEADER);
        return this.graphResults(opts, uuid, null);
    }

    public void createRepository(String namespace, Properties properties) throws Exception {
        this.createRepository(namespace, properties, UUID.randomUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRepository(String namespace, Properties properties, UUID uuid) throws Exception {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        Properties tmp = PropertyUtil.flatCopy(properties);
        tmp.setProperty("com.bigdata.rdf.sail.namespace", namespace);
        ConnectOptions opts = this.newConnectOptions(this.baseServiceURL + "/namespace", uuid, null);
        JettyResponseListener response = null;
        PropertiesFormat format = PropertiesFormat.XML;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PropertiesWriter writer = ((PropertiesWriterFactory)PropertiesWriterRegistry.getInstance().get(format)).getWriter(baos);
        writer.write(tmp);
        byte[] data = baos.toByteArray();
        ByteArrayEntity entity = new ByteArrayEntity(data);
        entity.setContentType(format.getDefaultMIMEType());
        opts.entity = entity;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public Properties getPreparedProperties(String namespace, Properties properties) throws Exception {
        return this.getPreparedProperties(namespace, properties, UUID.randomUUID());
    }

    public Properties getPreparedProperties(String namespace, Properties properties, UUID uuid) throws Exception {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        Properties tmp = PropertyUtil.flatCopy(properties);
        tmp.setProperty("com.bigdata.rdf.sail.namespace", namespace);
        String sparqlEndpointURL = this.baseServiceURL + "/namespace/prepareProperties";
        ConnectOptions opts = this.newConnectOptions(this.baseServiceURL + "/namespace/prepareProperties", uuid, null);
        JettyResponseListener response = null;
        PropertiesFormat format = PropertiesFormat.XML;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PropertiesWriter writer = ((PropertiesWriterFactory)PropertiesWriterRegistry.getInstance().get(format)).getWriter(baos);
        writer.write(tmp);
        byte[] data = baos.toByteArray();
        ByteArrayEntity entity = new ByteArrayEntity(data);
        entity.setContentType(format.getDefaultMIMEType());
        opts.entity = entity;
        boolean consumeNeeded = true;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            String contentType = response.getContentType();
            if (contentType == null) {
                throw new RuntimeException("Not found: Content-Type");
            }
            MiniMime mimeType = new MiniMime(contentType);
            PropertiesFormat format2 = PropertiesFormat.forMIMEType(mimeType.getMimeType());
            if (format2 == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + sparqlEndpointURL + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            PropertiesParserFactory factory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get(format2);
            if (factory == null) {
                throw new RuntimeException("ParserFactory not found: Content-Type=" + contentType + ", format=" + format2);
            }
            PropertiesParser parser = factory.getParser();
            Properties preparedProperties = parser.parse(response.getInputStream());
            consumeNeeded = false;
            Properties properties2 = preparedProperties;
            return properties2;
        }
        catch (Exception e) {
            consumeNeeded = !InnerCause.isInnerCause(e, HttpException.class);
            throw e;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public void rebuildTextIndex(String namespace, boolean forceBuildTextIndex) throws Exception {
        this.rebuildTextIndex(namespace, forceBuildTextIndex, UUID.randomUUID());
    }

    public void rebuildTextIndex(String namespace, boolean forceBuildTextIndex, UUID uuid) throws Exception {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        if (uuid == null) {
            throw new IllegalArgumentException();
        }
        String endpointURL = this.baseServiceURL + "/namespace/" + namespace + "/textIndex";
        ConnectOptions opts = this.newConnectOptions(endpointURL, uuid, null);
        if (forceBuildTextIndex) {
            opts.addRequestParam("force-index-create", "true");
        }
        JettyResponseListener response = null;
        boolean consumeNeeded = true;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            consumeNeeded = false;
        }
        catch (Exception e) {
            consumeNeeded = !InnerCause.isInnerCause(e, HttpException.class);
            throw e;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public void deleteRepository(String namespace) throws Exception {
        this.deleteRepository(namespace, UUID.randomUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRepository(String namespace, UUID uuid) throws Exception {
        ConnectOptions opts = this.newConnectOptions(this.getRepositoryBaseURLForNamespace(namespace), uuid, null);
        opts.method = "DELETE";
        JettyResponseListener response = null;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean publishNamespaceToMapgraph(String namespace) throws Exception {
        this.assertMapgraphRuntimeAvailable();
        if (this.namespacePublishedToMapgraph(namespace)) {
            return false;
        }
        String repositoryUrl = this.getSparqlEndpointUrlForNamespaceOrDefault(namespace);
        ConnectOptions opts = this.newConnectOptions(repositoryUrl, UUID.randomUUID(), null);
        JettyResponseListener response = null;
        opts.addRequestParam(MAPGRAPH, MAPGRAPH_PUBLISH);
        opts.method = "POST";
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dropNamespaceFromMapgraph(String namespace) throws Exception {
        this.assertMapgraphRuntimeAvailable();
        if (!this.namespacePublishedToMapgraph(namespace)) {
            return false;
        }
        String repositoryUrl = this.getSparqlEndpointUrlForNamespaceOrDefault(namespace);
        ConnectOptions opts = this.newConnectOptions(repositoryUrl, UUID.randomUUID(), null);
        JettyResponseListener response = null;
        opts.addRequestParam(MAPGRAPH, MAPGRAPH_DROP);
        opts.method = "POST";
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean namespacePublishedToMapgraph(String namespace) throws Exception {
        this.assertMapgraphRuntimeAvailable();
        String repositoryUrl = this.getSparqlEndpointUrlForNamespaceOrDefault(namespace);
        ConnectOptions opts = this.newConnectOptions(repositoryUrl, UUID.randomUUID(), null);
        JettyResponseListener response = null;
        opts.setAcceptHeader("Accept: text/plain");
        opts.addRequestParam(MAPGRAPH, CHECK_PUBLISHED);
        opts.method = "POST";
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            String responseBody = response.getResponseBody();
            boolean bl = responseBody != null && responseBody.contains("true");
            return bl;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMapgraphRuntime(ComputeMode computeMode) throws Exception {
        this.assertMapgraphRuntimeAvailable();
        if (computeMode == null) {
            throw new IllegalArgumentException("Compute mode must not be null");
        }
        String repositoryUrl = this.getSparqlEndpointUrlForNamespaceOrDefault(null);
        ConnectOptions opts = this.newConnectOptions(repositoryUrl, UUID.randomUUID(), null);
        JettyResponseListener response = null;
        opts.addRequestParam(MAPGRAPH, MAPGRAPH_RESET);
        opts.addRequestParam(COMPUTE_MODE, computeMode.toString());
        opts.method = "POST";
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMapgraphStatus() throws Exception {
        String repositoryUrl = this.baseServiceURL + "/status";
        ConnectOptions opts = this.newConnectOptions(repositoryUrl, UUID.randomUUID(), null);
        JettyResponseListener response = null;
        opts.addRequestParam(MAPGRAPH, "");
        opts.method = "GET";
        try {
            response = this.doConnect(opts);
            String string = response.getResponseBody();
            return string;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mapgraphRuntimeAvailable() throws Exception {
        String repositoryUrl = this.getSparqlEndpointUrlForNamespaceOrDefault(null);
        ConnectOptions opts = this.newConnectOptions(repositoryUrl, UUID.randomUUID(), null);
        JettyResponseListener response = null;
        opts.addRequestParam(MAPGRAPH, MAPGRAPH_CHECK_RUNTIME_AVAILABLE);
        opts.method = "POST";
        try {
            response = this.doConnect(opts);
            boolean bl = response.getStatus() == 200;
            return bl;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    void assertMapgraphRuntimeAvailable() throws Exception {
        if (!this.mapgraphRuntimeAvailable()) {
            throw new NoGPUAccelerationAvailable();
        }
    }

    public Properties getRepositoryProperties(String namespace) throws Exception {
        return this.getRepositoryProperties(namespace, UUID.randomUUID());
    }

    public Properties getRepositoryProperties(String namespace, UUID uuid) throws Exception {
        String sparqlEndpointURL = this.getRepositoryBaseURLForNamespace(namespace);
        ConnectOptions opts = this.newConnectOptions(sparqlEndpointURL + "/properties", uuid, null);
        opts.method = "GET";
        JettyResponseListener response = null;
        opts.setAcceptHeader("application/xml");
        boolean consumeNeeded = true;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            String contentType = response.getContentType();
            if (contentType == null) {
                throw new RuntimeException("Not found: Content-Type");
            }
            MiniMime mimeType = new MiniMime(contentType);
            PropertiesFormat format = PropertiesFormat.forMIMEType(mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + sparqlEndpointURL + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            PropertiesParserFactory factory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get(format);
            if (factory == null) {
                throw new RuntimeException("ParserFactory not found: Content-Type=" + contentType + ", format=" + format);
            }
            PropertiesParser parser = factory.getParser();
            Properties properties = parser.parse(response.getInputStream());
            consumeNeeded = false;
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception e) {
            consumeNeeded = !InnerCause.isInnerCause(e, HttpException.class);
            throw e;
        }
        finally {
            if (response != null && consumeNeeded) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onlineBackup(String file, boolean compress, boolean block) throws Exception {
        String COMPRESS = "compress";
        String FILE = "file";
        String BLOCK = "block";
        ConnectOptions opts = this.newConnectOptions(this.baseServiceURL + "/backup", UUID.randomUUID(), null);
        JettyResponseListener response = null;
        opts.addRequestParam("file", file);
        opts.addRequestParam("compress", Boolean.toString(compress));
        opts.addRequestParam("block", Boolean.toString(block));
        opts.method = "POST";
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDataLoader(Properties properties) throws Exception {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        Properties tmp = PropertyUtil.flatCopy(properties);
        ConnectOptions opts = this.newConnectOptions(this.baseServiceURL + "/dataloader", UUID.randomUUID(), null);
        JettyResponseListener response = null;
        PropertiesFormat format = PropertiesFormat.XML;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PropertiesWriter writer = ((PropertiesWriterFactory)PropertiesWriterRegistry.getInstance().get(format)).getWriter(baos);
        writer.write(tmp);
        byte[] data = baos.toByteArray();
        ByteArrayEntity entity = new ByteArrayEntity(data);
        entity.setContentType(format.getDefaultMIMEType());
        opts.entity = entity;
        opts.method = "POST";
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    public JettyResponseListener doConnect(ConnectOptions opts) throws Exception {
        boolean isLongRequestURL;
        this.assertHttpClientRunning();
        String requestURL = opts.getRequestURL(RemoteRepositoryManager.getContextPath(), this.getUseLBS());
        StringBuilder urlString = new StringBuilder(requestURL);
        ConnectOptions.addQueryParams(urlString, opts.requestParams);
        boolean bl = isLongRequestURL = urlString.length() > this.getMaxRequestURLLength();
        if (isLongRequestURL && opts.method.equals("POST") && opts.entity == null) {
            urlString.setLength(0);
            urlString.append(requestURL);
            opts.entity = ConnectOptions.getFormEntity(opts.requestParams);
        } else if (isLongRequestURL && opts.method.equals("GET") && opts.entity == null) {
            opts.method = "POST";
            urlString.setLength(0);
            urlString.append(requestURL);
            opts.entity = ConnectOptions.getFormEntity(opts.requestParams);
        }
        if (log.isDebugEnabled()) {
            log.debug("*** Request ***");
            log.debug(requestURL);
            log.debug(opts.method);
            log.debug("query=" + opts.getRequestParam("query"));
            log.debug(urlString.toString());
        }
        HttpRequest request = null;
        try {
            String s;
            request = (HttpRequest)this.newRequest(urlString.toString(), opts.method);
            if (opts.requestHeaders != null) {
                for (Map.Entry e : opts.requestHeaders.entrySet()) {
                    request.header((String)e.getKey(), (String)e.getValue());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((String)e.getKey() + ": " + (String)e.getValue());
                }
            }
            if (opts.entity != null) {
                EntityContentProvider cp = new EntityContentProvider(opts.entity);
                request.content(cp, cp.getContentType());
            }
            long queryTimeoutMillis = (s = opts.getHeader("X-BIGDATA-MAX-QUERY-MILLIS")) == null ? -1L : StringUtil.toLong(s);
            JettyResponseListener listener = new JettyResponseListener(request, queryTimeoutMillis);
            request.send(listener);
            return listener;
        }
        catch (Throwable t) {
            try {
                if (request != null) {
                    request.abort(t);
                }
            }
            catch (Throwable t2) {
                log.warn(t2);
            }
            throw new RuntimeException(requestURL + " : " + t, t);
        }
    }

    public Request newRequest(String uri, String method) {
        if (this.httpClient == null) {
            throw new IllegalArgumentException();
        }
        this.assertHttpClientRunning();
        return this.httpClient.newRequest(uri).method(this.getMethod(method));
    }

    private void assertHttpClientRunning() {
        if (this.httpClient.isStopped() || this.httpClient.isStopping()) {
            throw new IllegalStateException("The HTTPClient has been stopped");
        }
    }

    HttpMethod getMethod(String method) {
        if (method.equals("GET")) {
            return HttpMethod.GET;
        }
        if (method.equals("POST")) {
            return HttpMethod.POST;
        }
        if (method.equals("DELETE")) {
            return HttpMethod.DELETE;
        }
        if (method.equals("PUT")) {
            return HttpMethod.PUT;
        }
        throw new IllegalArgumentException();
    }

    protected final ConnectOptions newQueryConnectOptions(String sparqlEndpointURL, UUID uuid, IRemoteTx tx) {
        ConnectOptions opts = this.newConnectOptions(sparqlEndpointURL, uuid, tx);
        opts.method = this.getQueryMethod();
        opts.update = false;
        return opts;
    }

    protected final ConnectOptions newUpdateConnectOptions(String sparqlEndpointURL, UUID uuid, IRemoteTx tx) {
        ConnectOptions opts = this.newConnectOptions(sparqlEndpointURL, uuid, tx);
        opts.method = "POST";
        opts.update = true;
        return opts;
    }

    ConnectOptions newConnectOptions(String serviceURL, UUID uuid, IRemoteTx tx) {
        ConnectOptions opts = new ConnectOptions(serviceURL);
        if (tx != null) {
            if (tx.isReadOnly()) {
                opts.addRequestParam("timestamp", Long.toString(tx.getReadsOnCommitTime()));
            } else {
                opts.addRequestParam("timestamp", Long.toString(tx.getTxId()));
            }
        }
        if (uuid != null) {
            opts.addRequestParam("queryId", uuid.toString());
        }
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphQueryResult graphResults(ConnectOptions opts, final UUID queryId, final IPreparedQueryListener listener) throws Exception {
        JettyResponseListener response = null;
        BackgroundGraphResult result = null;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            String baseURI = "";
            String contentType = response.getContentType();
            if (contentType == null) {
                throw new RuntimeException("Not found: Content-Type");
            }
            MiniMime mimeType = new MiniMime(contentType);
            RDFFormat format = RDFFormat.forMIMEType(mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + opts.getBestRequestURL() + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            RDFParserFactory factory = (RDFParserFactory)RDFParserRegistry.getInstance().get(format);
            if (factory == null) {
                throw new RuntimeException("RDFParserFactory not found: Content-Type=" + contentType + ", format=" + format);
            }
            RDFParser parser = factory.getParser();
            parser.setValueFactory(new ValueFactoryImpl());
            parser.setVerifyData(true);
            parser.setStopAtFirstError(true);
            parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
            Charset charset = format.getCharset();
            try {
                String encoding = response.getContentEncoding();
                if (encoding != null) {
                    charset = Charset.forName(encoding);
                }
            }
            catch (IllegalCharsetNameException e) {
                // empty catch block
            }
            BackgroundGraphResult tmp = new BackgroundGraphResult(parser, response.getInputStream(), charset, ""){
                final AtomicBoolean notDone;
                {
                    super(x0, x1, x2, x3);
                    this.notDone = new AtomicBoolean(true);
                }

                @Override
                public boolean hasNext() throws QueryEvaluationException {
                    boolean hasNext = super.hasNext();
                    if (!hasNext) {
                        this.notDone.set(false);
                    }
                    return hasNext;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws QueryEvaluationException {
                    try {
                        super.close();
                    }
                    finally {
                        if (this.notDone.compareAndSet(true, false)) {
                            try {
                                RemoteRepositoryManager.this.cancel(queryId);
                            }
                            catch (Exception ex) {
                                log.warn(ex);
                            }
                        }
                        if (listener != null) {
                            listener.closed(queryId);
                        }
                    }
                }
            };
            this.executor.execute(tmp);
            BackgroundGraphResult backgroundGraphResult = result = tmp;
            return backgroundGraphResult;
        }
        finally {
            if (response != null && result == null) {
                response.abort();
                try {
                    this.cancel(queryId);
                }
                catch (Exception ex) {
                    log.warn(ex);
                }
                if (listener != null) {
                    listener.closed(queryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sparqlUpdateResults(ConnectOptions opts, UUID queryId, IPreparedQueryListener listener) throws Exception {
        JettyResponseListener response = null;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response == null) {
                try {
                    this.cancel(queryId);
                }
                catch (Exception ex) {
                    log.warn(ex);
                }
            }
            if (listener != null) {
                listener.closed(queryId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(UUID queryId) throws Exception {
        if (queryId == null) {
            return;
        }
        ConnectOptions opts = this.newUpdateConnectOptions(this.baseServiceURL, queryId, null);
        opts.addRequestParam("cancelQuery");
        JettyResponseListener response = null;
        try {
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<RunningQuery> showQueries() throws Exception {
        ConnectOptions opts = this.newUpdateConnectOptions(this.baseServiceURL, null, null);
        opts.addRequestParam(SHOW_QUERIES);
        opts.setAcceptHeader("application/json");
        JettyResponseListener response = null;
        try {
            List<RunningQuery> runningQueries;
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            String contentType = response.getContentType();
            if (!"application/json".equals(contentType)) {
                throw new RuntimeException("Expected MIME_TYPE application/json but received : " + contentType + ".");
            }
            InputStream is = response.getInputStream();
            List<RunningQuery> list = runningQueries = JsonHelper.readRunningQueryList(is);
            return list;
        }
        finally {
            if (response != null) {
                response.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TupleQueryResult tupleResults(ConnectOptions opts, final UUID queryId, final IPreparedQueryListener listener) throws Exception {
        JettyResponseListener response = null;
        FutureTask<Object> ft = null;
        TupleQueryResultImpl tqrImpl = null;
        try {
            TupleQueryResultImpl tmp;
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            String contentType = response.getContentType();
            MiniMime mimeType = new MiniMime(contentType);
            TupleQueryResultFormat format = TupleQueryResultFormat.forMIMEType(mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + opts.getBestRequestURL() + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            TupleQueryResultParserFactory parserFactory = (TupleQueryResultParserFactory)TupleQueryResultParserRegistry.getInstance().get(format);
            if (parserFactory == null) {
                throw new IOException("No parser for format for service response: serviceURI=" + opts.getBestRequestURL() + ", contentType=" + contentType + ", format=" + format + " : response=" + response.getResponseBody());
            }
            TupleQueryResultParser parser = parserFactory.getParser();
            BackgroundTupleResult result = new BackgroundTupleResult(parser, response.getInputStream());
            MapBindingSet bindings = new MapBindingSet();
            InsertBindingSetCursor cursor = new InsertBindingSetCursor(result, bindings);
            ft = new FutureTask<Object>(result, null);
            this.executor.execute(ft);
            ArrayList<String> list = new ArrayList<String>(result.getBindingNames());
            TupleQueryResultImpl tupleQueryResultImpl = tqrImpl = (tmp = new TupleQueryResultImpl(list, cursor){
                private final AtomicBoolean notDone;
                {
                    super((List<String>)x0, x1);
                    this.notDone = new AtomicBoolean(true);
                }

                @Override
                public boolean hasNext() throws QueryEvaluationException {
                    boolean hasNext = super.hasNext();
                    if (!hasNext) {
                        this.notDone.set(false);
                    }
                    return hasNext;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleClose() throws QueryEvaluationException {
                    try {
                        super.handleClose();
                    }
                    finally {
                        if (this.notDone.compareAndSet(true, false)) {
                            try {
                                RemoteRepositoryManager.this.cancel(queryId);
                            }
                            catch (Exception ex) {
                                log.warn(ex);
                            }
                        }
                        if (listener != null) {
                            listener.closed(queryId);
                        }
                    }
                }
            });
            return tupleQueryResultImpl;
        }
        finally {
            if (response != null && tqrImpl == null) {
                if (ft != null) {
                    ft.cancel(true);
                }
                response.abort();
                try {
                    this.cancel(queryId);
                }
                catch (Exception ex) {
                    log.warn(ex);
                }
                if (listener != null) {
                    listener.closed(queryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean booleanResults(ConnectOptions opts, UUID queryId, IPreparedQueryListener listener) throws Exception {
        JettyResponseListener response = null;
        Boolean result = null;
        try {
            boolean bl;
            response = this.doConnect(opts);
            RemoteRepositoryManager.checkResponseCode(response);
            String contentType = response.getContentType();
            MiniMime mimeType = new MiniMime(contentType);
            BooleanQueryResultFormat format = BooleanQueryResultFormat.forMIMEType(mimeType.getMimeType());
            if (format == null) {
                throw new IOException("Could not identify format for service response: serviceURI=" + opts.getBestRequestURL() + ", contentType=" + contentType + " : response=" + response.getResponseBody());
            }
            BooleanQueryResultParserFactory factory = (BooleanQueryResultParserFactory)BooleanQueryResultParserRegistry.getInstance().get(format);
            if (factory == null) {
                throw new RuntimeException("No factory for Content-Type: " + contentType);
            }
            BooleanQueryResultParser parser = factory.getParser();
            InputStream is = response.getInputStream();
            try {
                result = parser.parse(is);
                bl = result;
            }
            catch (Throwable throwable) {
                is.close();
                throw throwable;
            }
            is.close();
            return bl;
        }
        finally {
            if (result == null) {
                if (response != null) {
                    response.abort();
                }
                try {
                    this.cancel(queryId);
                }
                catch (Exception ex) {
                    log.warn(ex);
                }
            }
            if (listener != null) {
                listener.closed(queryId);
            }
        }
    }

    public static enum ComputeMode {
        CPU,
        GPU;

    }
}

