/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs;

import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.journal.PlatformStatsPlugIn;
import com.bigdata.rdf.sail.webapp.HALoadBalancerServlet;
import com.bigdata.rdf.sail.webapp.lbs.AbstractLBSPolicy;
import com.bigdata.rdf.sail.webapp.lbs.HostScore;
import com.bigdata.rdf.sail.webapp.lbs.HostTable;
import com.bigdata.rdf.sail.webapp.lbs.IHostMetrics;
import com.bigdata.rdf.sail.webapp.lbs.IHostScoringRule;
import com.bigdata.rdf.sail.webapp.lbs.ServiceScore;
import com.bigdata.util.InnerCause;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractHostLBSPolicy
extends AbstractLBSPolicy {
    private static final Logger log = Logger.getLogger(AbstractHostLBSPolicy.class);
    private static final long serialVersionUID = 1L;
    private static final RuntimeException CAUSE_EMPTY_HOST_TABLE = new RuntimeException("Empty host table.");
    private static final RuntimeException CAUSE_EMPTY_SERVICE_TABLE = new RuntimeException("Empty service table.");
    private static final RuntimeException CAUSE_NO_HOST_SELECTED = new RuntimeException("No host selected for request.");
    private static final RuntimeException CAUSE_NO_SERVICE_SELECTED = new RuntimeException("No service selected for request.");
    private final AtomicReference<Double> localForwardThresholdRef = new AtomicReference();
    private final AtomicReference<IHostScoringRule> scoringRuleRef = new AtomicReference();
    private long hostDiscoveryInitialDelay = -1L;
    private long hostDiscoveryDelay = -1L;
    private final Random rand = new Random();
    private final AtomicReference<HostTable> hostTableRef = new AtomicReference<Object>(null);
    private ScheduledFuture<?> scheduledFuture;

    protected abstract String getDefaultScoringRule();

    protected long getHostDiscoveryDelay() {
        return this.hostDiscoveryDelay;
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(",localForwardThreshold=" + this.localForwardThresholdRef.get());
        sb.append(",hostDiscoveryInitialDelay=" + this.hostDiscoveryInitialDelay);
        sb.append(",hostDiscoveryDelay=" + this.hostDiscoveryDelay);
        sb.append(",scoringRule=" + this.scoringRuleRef.get());
        ScheduledFuture<?> tmp = this.scheduledFuture;
        boolean futureIsDone = tmp == null ? true : tmp.isDone();
        sb.append(",scheduledFuture=" + (tmp == null ? "N/A" : (futureIsDone ? "done" : "running")));
        if (futureIsDone && tmp != null) {
            Exception cause = null;
            try {
                tmp.get();
            }
            catch (CancellationException ex) {
                cause = ex;
            }
            catch (ExecutionException ex) {
                cause = ex;
            }
            catch (InterruptedException ex) {
                cause = ex;
            }
            if (cause != null) {
                sb.append("(cause=" + cause + ")");
            }
        }
        sb.append(",hostTable=" + this.hostTableRef.get());
    }

    @Override
    public void init(ServletConfig servletConfig, IIndexManager indexManager) throws ServletException {
        super.init(servletConfig, indexManager);
        Journal journal = (Journal)indexManager;
        if (journal.getPlatformStatisticsCollector() == null) {
            throw new ServletException("LBS requires " + PlatformStatsPlugIn.class.getName());
        }
        String s = HALoadBalancerServlet.getConfigParam(servletConfig, AbstractHostLBSPolicy.class, "localForwardThreshold", "1.0");
        double d = Double.valueOf(s);
        if (log.isInfoEnabled()) {
            log.info("localForwardThreshold=" + d);
        }
        this.setLocalForwardThreshold(d);
        this.scoringRuleRef.set(HALoadBalancerServlet.newInstance(servletConfig, AbstractHostLBSPolicy.class, IHostScoringRule.class, "hostScoringRule", this.getDefaultScoringRule()));
        if (log.isInfoEnabled()) {
            log.info("hostScoringRule=" + this.scoringRuleRef.getClass().getName());
        }
        s = HALoadBalancerServlet.getConfigParam(servletConfig, AbstractHostLBSPolicy.class, "hostDiscoveryInitialDelay", "10000");
        this.hostDiscoveryInitialDelay = Long.valueOf(s);
        if (log.isInfoEnabled()) {
            log.info("hostDiscoveryDelay=" + this.hostDiscoveryDelay);
        }
        s = HALoadBalancerServlet.getConfigParam(servletConfig, AbstractHostLBSPolicy.class, "hostDiscoveryDelay", "10000");
        this.hostDiscoveryDelay = Long.valueOf(s);
        if (log.isInfoEnabled()) {
            log.info("hostDiscoveryDelay=" + this.hostDiscoveryDelay);
        }
        this.scheduledFuture = ((Journal)indexManager).addScheduledTask(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractHostLBSPolicy.this.updateHostTable();
                }
                catch (RuntimeException ex) {
                    if (InnerCause.isInnerCause(ex, InterruptedException.class)) {
                        throw ex;
                    }
                    log.error(ex, ex);
                }
            }
        }, this.hostDiscoveryInitialDelay, this.hostDiscoveryDelay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.localForwardThresholdRef.set(null);
        this.scoringRuleRef.set(null);
        this.hostTableRef.set(null);
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
            this.scheduledFuture = null;
        }
    }

    public void setLocalForwardThreshold(double newValue) {
        if (newValue < 0.0 || newValue > 1.0) {
            throw new IllegalArgumentException();
        }
        this.localForwardThresholdRef.set(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void conditionallyUpdateServiceTable() {
        HostScore[] hostScores;
        super.conditionallyUpdateServiceTable();
        HostTable hostTable = this.hostTableRef.get();
        HostScore[] hostScoreArray = hostScores = hostTable == null ? null : hostTable.hostScores;
        if (hostScores == null || hostScores.length == 0) {
            AtomicReference<HostTable> atomicReference = this.hostTableRef;
            synchronized (atomicReference) {
                this.updateHostTable();
            }
        }
    }

    @Override
    protected void updateServiceTable() {
        super.updateServiceTable();
        this.updateHostTable();
    }

    protected void updateHostTable() {
        ServiceScore[] serviceScores = (ServiceScore[])this.serviceTableRef.get();
        IHostScoringRule scoringRule = this.scoringRuleRef.get();
        if (serviceScores == null || serviceScores.length == 0 || scoringRule == null) {
            this.hostTableRef.set(null);
            return;
        }
        Map<String, IHostMetrics> hostMetricsMap = this.getHostReportForKnownServices(scoringRule, serviceScores);
        if (hostMetricsMap == null || hostMetricsMap.isEmpty()) {
            this.hostTableRef.set(null);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("hostMetricsMap=" + hostMetricsMap);
        }
        HostTable newHostTable = AbstractHostLBSPolicy.normalizeHostScores(scoringRule, hostMetricsMap);
        if (log.isTraceEnabled()) {
            log.trace("newHostTable=" + newHostTable);
        }
        this.hostTableRef.set(newHostTable);
    }

    private static HostTable normalizeHostScores(IHostScoringRule scoringRule, Map<String, IHostMetrics> hostMetricsMap) {
        int nhosts = hostMetricsMap.size();
        String[] hostnames = new String[nhosts];
        IHostMetrics[] metrics2 = new IHostMetrics[nhosts];
        double[] load = new double[nhosts];
        double totalLoad = 0.0;
        double NO_INFO = 0.5;
        int i = 0;
        for (Map.Entry<String, IHostMetrics> e : hostMetricsMap.entrySet()) {
            double hostScore;
            String hostname = e.getKey();
            assert (hostname != null);
            IHostMetrics metrics = e.getValue();
            double d = hostScore = metrics == null ? 0.5 : scoringRule.getScore(metrics);
            if (hostScore < 0.0) {
                log.error("Negative score: " + hostname);
                hostScore = 0.5;
            }
            hostnames[i] = hostname;
            load[i] = hostScore;
            metrics2[i] = metrics;
            totalLoad += hostScore;
            ++i;
        }
        double totalAvailability = 0.0;
        double[] availability = new double[nhosts];
        for (int i2 = 0; i2 < nhosts; ++i2) {
            double avail = availability[i2] = totalLoad - load[i2];
            totalAvailability += avail;
        }
        HostScore thisHostScore = null;
        HostScore[] scores = new HostScore[nhosts];
        for (int i3 = 0; i3 < nhosts; ++i3) {
            String hostname = hostnames[i3];
            double normalizedAvailability = totalAvailability == 0.0 ? 1.0 / (double)nhosts : availability[i3] / totalAvailability;
            HostScore hostScore = scores[i3] = new HostScore(hostname, normalizedAvailability);
            if (thisHostScore != null && hostScore.isThisHost()) {
                thisHostScore = hostScore;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("hostname=" + hostname + ", metrics=" + metrics2[i3] + ", score=" + hostScore.getAvailability());
        }
        Arrays.sort(scores, HostScore.COMPARE_BY_HOSTNAME);
        return new HostTable(thisHostScore, scores);
    }

    @Override
    public String getReaderURI(HttpServletRequest req) {
        HostTable hostTable = this.hostTableRef.get();
        HostScore[] hostScores = hostTable == null ? null : hostTable.hostScores;
        ServiceScore[] serviceScores = (ServiceScore[])this.serviceTableRef.get();
        if (hostScores == null || hostScores.length == 0) {
            throw CAUSE_EMPTY_HOST_TABLE;
        }
        if (serviceScores == null) {
            throw CAUSE_EMPTY_SERVICE_TABLE;
        }
        HostScore hostScore = AbstractHostLBSPolicy.getHost(this.rand.nextDouble(), hostScores);
        if (hostScore == null) {
            throw CAUSE_NO_HOST_SELECTED;
        }
        ServiceScore serviceScore = AbstractHostLBSPolicy.getService(this.rand, hostScore, serviceScores);
        if (serviceScore == null) {
            throw CAUSE_NO_SERVICE_SELECTED;
        }
        serviceScore.nrequests.increment();
        if (serviceScore.getServiceUUID().equals(this.serviceIDRef.get())) {
            return null;
        }
        String requestURI = serviceScore.getRequestURI();
        return requestURI;
    }

    static HostScore getHost(double d, HostScore[] hostScores) {
        if (d < 0.0 || d >= 1.0) {
            throw new IllegalArgumentException();
        }
        if (hostScores == null) {
            throw new IllegalArgumentException();
        }
        HostScore hostScore = null;
        if (hostScores.length == 1) {
            hostScore = hostScores[0];
        } else {
            HostScore tmp;
            double sum = 0.0;
            HostScore[] arr$ = hostScores;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !((sum += (hostScore = (tmp = arr$[i$])).getAvailability()) >= d); ++i$) {
            }
        }
        return hostScore;
    }

    static ServiceScore getService(Random rand, HostScore hostScore, ServiceScore[] serviceScores) {
        LinkedList<ServiceScore> foundServices = new LinkedList<ServiceScore>();
        for (ServiceScore tmp : serviceScores) {
            if (tmp == null || tmp.getRequestURI() == null || !hostScore.getHostname().equals(tmp.getHostname())) continue;
            foundServices.add(tmp);
        }
        int nservices = foundServices.size();
        if (nservices == 0) {
            log.warn("No services on host: hostname=" + hostScore.getHostname());
            return null;
        }
        int n = rand.nextInt(nservices);
        ServiceScore serviceScore = (ServiceScore)foundServices.get(n);
        return serviceScore;
    }

    @Override
    protected boolean conditionallyForwardReadRequest(HALoadBalancerServlet servlet, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HostScore thisHostScore;
        HostTable hostTable = this.hostTableRef.get();
        HostScore hostScore = thisHostScore = hostTable == null ? null : hostTable.thisHost;
        if (thisHostScore != null && thisHostScore.getAvailability() >= this.localForwardThresholdRef.get()) {
            servlet.forwardToLocalService(false, request, response);
            return true;
        }
        return false;
    }

    protected abstract Map<String, IHostMetrics> getHostReportForKnownServices(IHostScoringRule var1, ServiceScore[] var2);

    public static interface InitParams
    extends AbstractLBSPolicy.InitParams {
        public static final String HOST_SCORING_RULE = "hostScoringRule";
        public static final String LOCAL_FORWARD_THRESHOLD = "localForwardThreshold";
        public static final String DEFAULT_LOCAL_FORWARD_THRESHOLD = "1.0";
        public static final String HOST_DISCOVERY_INITIAL_DELAY = "hostDiscoveryInitialDelay";
        public static final String DEFAULT_HOST_DISCOVERY_INITIAL_DELAY = "10000";
        public static final String HOST_DISCOVERY_DELAY = "hostDiscoveryDelay";
        public static final String DEFAULT_HOST_DISCOVERY_DELAY = "10000";
    }
}

