/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs;

import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.IHAJournal;
import com.bigdata.ha.QuorumService;
import com.bigdata.journal.IIndexManager;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumEvent;
import com.bigdata.quorum.QuorumListener;
import com.bigdata.rdf.sail.webapp.BigdataServlet;
import com.bigdata.rdf.sail.webapp.HALoadBalancerServlet;
import com.bigdata.rdf.sail.webapp.lbs.IHALoadBalancerPolicy;
import com.bigdata.rdf.sail.webapp.lbs.ServiceScore;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public abstract class AbstractLBSPolicy
implements IHALoadBalancerPolicy,
QuorumListener,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractLBSPolicy.class);
    private static final long serialVersionUID = 1L;
    private final AtomicReference<String> contextPath = new AtomicReference();
    protected final AtomicReference<WeakReference<IHAJournal>> journalRef = new AtomicReference();
    protected final AtomicReference<UUID> serviceIDRef = new AtomicReference();
    protected final AtomicReference<ServiceScore[]> serviceTableRef = new AtomicReference<Object>(null);

    public String toString() {
        Object[] serviceTable = this.serviceTableRef.get();
        String tmp = serviceTable != null ? Arrays.toString(serviceTable) : "N/A";
        StringBuilder sb = new StringBuilder(256);
        sb.append(this.getClass().getName());
        sb.append("{contextPath=" + this.contextPath.get());
        sb.append(",journal=" + this.journalRef.get());
        sb.append(",serviceID=" + this.serviceIDRef.get());
        sb.append(",services=" + tmp);
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
    }

    protected IHAJournal getJournal() {
        WeakReference<IHAJournal> ref = this.journalRef.get();
        if (ref == null) {
            return null;
        }
        return (IHAJournal)ref.get();
    }

    @Override
    public void destroy() {
        this.contextPath.set(null);
        this.journalRef.set(null);
        this.serviceTableRef.set(null);
    }

    @Override
    public void init(ServletConfig servletConfig, IIndexManager indexManager) throws ServletException {
        ServletContext servletContext = servletConfig.getServletContext();
        this.contextPath.set(servletContext.getContextPath());
        IHAJournal journal = (IHAJournal)BigdataServlet.getIndexManager(servletContext);
        if (journal == null) {
            throw new ServletException("No journal?");
        }
        this.serviceIDRef.compareAndSet(null, journal.getServiceID());
        this.journalRef.set(new WeakReference<IHAJournal>(journal));
        Quorum<HAGlue, QuorumService<HAGlue>> quorum = journal.getQuorum();
        quorum.addListener(this);
    }

    @Override
    public boolean service(boolean isLeaderRequest, HALoadBalancerServlet servlet, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IHAJournal journal = this.getJournal();
        Quorum<HAGlue, QuorumService<HAGlue>> quorum = null;
        QuorumService<HAGlue> quorumService = null;
        long token = -1L;
        boolean isLeader = false;
        boolean isQuorumMet = false;
        if (journal != null && (quorum = journal.getQuorum()) != null) {
            try {
                quorumService = quorum.getClient();
                token = quorum.token();
                isLeader = quorumService.isLeader(token);
                isQuorumMet = token != -1L;
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
        }
        if (isLeader && isLeaderRequest || !isQuorumMet) {
            servlet.forwardToLocalService(isLeaderRequest, request, response);
            return true;
        }
        this.conditionallyUpdateServiceTable();
        return !isLeaderRequest && this.conditionallyForwardReadRequest(servlet, request, response);
    }

    protected boolean conditionallyForwardReadRequest(HALoadBalancerServlet servlet, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return false;
    }

    @Override
    public final String getLeaderURI(HttpServletRequest request) {
        ServletContext servletContext = request.getServletContext();
        IHAJournal journal = (IHAJournal)BigdataServlet.getIndexManager(servletContext);
        Quorum<HAGlue, QuorumService<HAGlue>> quorum = journal.getQuorum();
        UUID leaderId = quorum.getLeaderId();
        if (leaderId == null) {
            return null;
        }
        ServiceScore[] services = this.serviceTableRef.get();
        if (services == null) {
            return null;
        }
        for (ServiceScore s : services) {
            if (!s.getServiceUUID().equals(leaderId)) continue;
            return s.getRequestURI();
        }
        return null;
    }

    protected ServiceScore getLocalServiceScore() {
        ServiceScore[] services = this.serviceTableRef.get();
        if (services == null) {
            return null;
        }
        for (ServiceScore s : services) {
            if (!s.getServiceUUID().equals(this.serviceIDRef.get())) continue;
            return s;
        }
        return null;
    }

    protected ServiceScore getServiceScoreForHostname(String hostname) {
        if (hostname == null) {
            throw new IllegalArgumentException();
        }
        ServiceScore[] services = this.serviceTableRef.get();
        if (services == null) {
            return null;
        }
        for (ServiceScore s : services) {
            if (!hostname.equals(s.getHostname())) continue;
            return s;
        }
        return null;
    }

    @Override
    public void notify(QuorumEvent e) {
        switch (e.getEventType()) {
            case SERVICE_JOIN: 
            case SERVICE_LEAVE: {
                this.getJournal().getExecutorService().execute(new FutureTaskMon<Void>(new Runnable(){

                    @Override
                    public void run() {
                        AbstractLBSPolicy.this.updateServiceTable();
                    }
                }, (Void)null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void conditionallyUpdateServiceTable() {
        ServiceScore[] services = this.serviceTableRef.get();
        if (services == null || services.length == 0) {
            AtomicReference<ServiceScore[]> atomicReference = this.serviceTableRef;
            synchronized (atomicReference) {
                this.updateServiceTable();
            }
        }
    }

    protected void updateServiceTable() {
        IHAJournal journal = this.getJournal();
        if (journal == null) {
            return;
        }
        Quorum<HAGlue, QuorumService<HAGlue>> quorum = journal.getQuorum();
        UUID[] joined = quorum.getJoined();
        ServiceScore[] oldTable = this.serviceTableRef.get();
        ServiceScore[] serviceScores = new ServiceScore[joined.length];
        for (int i = 0; i < joined.length; ++i) {
            UUID serviceId = joined[i];
            if (oldTable != null) {
                for (int j = 0; j < oldTable.length; ++j) {
                    ServiceScore oldScore = oldTable[j];
                    if (oldScore == null || !serviceId.equals(oldScore.getServiceUUID())) continue;
                    serviceScores[i] = oldTable[j];
                    break;
                }
            }
            try {
                serviceScores[i] = ServiceScore.newInstance(journal, this.contextPath.get(), serviceId);
                continue;
            }
            catch (Exception ex) {
                log.warn(ex, ex);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("Updated servicesTable: #services=" + serviceScores.length);
        }
        this.serviceTableRef.set(serviceScores);
    }

    public static interface InitParams {
    }
}

